/*
 * Decompiled with CFR 0.152.
 */
package ifc.beans;

import com.sun.star.beans.Property;
import com.sun.star.beans.PropertyChangeEvent;
import com.sun.star.beans.PropertyVetoException;
import com.sun.star.beans.XMultiPropertySet;
import com.sun.star.beans.XPropertiesChangeListener;
import com.sun.star.beans.XPropertySetInfo;
import com.sun.star.lang.EventObject;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.lang.WrappedTargetException;
import java.io.PrintWriter;
import java.util.HashSet;
import java.util.Set;
import java.util.StringTokenizer;
import lib.MultiMethodTest;
import lib.Status;
import util.ValueChanger;
import util.utils;

public class _XMultiPropertySet
extends MultiMethodTest {
    public XMultiPropertySet oObj = null;
    private boolean propertiesChanged = false;
    private XPropertySetInfo propertySetInfo = null;
    private String[] testPropsNames = null;
    private int testPropsAmount = 0;
    private PrintWriter _log = null;
    private Object[] values = null;
    private Set exclProps = null;
    private XPropertiesChangeListener PClistener = new MyChangeListener();

    public void before() {
        this._log = this.log;
        this.exclProps = (Set)this.tEnv.getObjRelation("XMultiPropertySet.ExcludeProps");
        if (this.exclProps == null) {
            this.exclProps = new HashSet(0);
        }
    }

    public void _getPropertySetInfo() {
        boolean bl = true;
        this.propertySetInfo = this.oObj.getPropertySetInfo();
        if (this.propertySetInfo == null) {
            this.log.println("getPropertySetInfo() method returned null");
            bl = false;
        }
        this.tRes.tested("getPropertySetInfo()", bl);
    }

    public void _getPropertyValues() {
        this.requiredMethod("getPropertySetInfo()");
        boolean bl = true;
        Property[] propertyArray = this.propertySetInfo.getProperties();
        String[] stringArray = new String[propertyArray.length];
        for (int i = 0; i < propertyArray.length; ++i) {
            stringArray[i] = propertyArray[i].Name;
        }
        this.values = this.oObj.getPropertyValues(stringArray);
        this.tRes.tested("getPropertyValues()", bl &= this.values != null);
        this.getPropsToTest(propertyArray);
    }

    public void _addPropertiesChangeListener() {
        this.requiredMethod("getPropertyValues()");
        boolean bl = true;
        this.oObj.addPropertiesChangeListener(this.testPropsNames, this.PClistener);
        if (this.testPropsAmount == 1 && this.testPropsNames[0].equals("none")) {
            this.testPropsAmount = 0;
        }
        for (int i = 0; i < this.testPropsAmount; ++i) {
            this.log.print("Trying to change property " + this.testPropsNames[i]);
            try {
                Object object;
                Object[] objectArray = this.oObj.getPropertyValues(this.testPropsNames);
                objectArray[i] = object = ValueChanger.changePValue(objectArray[i]);
                this.propertiesChanged = false;
                this.oObj.setPropertyValues(this.testPropsNames, objectArray);
                this.waitAMoment();
                bl &= this.propertiesChanged;
                this.log.println(" ... done");
                continue;
            }
            catch (PropertyVetoException propertyVetoException) {
                this.log.println("Exception occured while trying to change property '" + this.testPropsNames[i] + "' :" + propertyVetoException);
                propertyVetoException.printStackTrace(this.log);
                continue;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                this.log.println("Exception occured while trying to change property '" + this.testPropsNames[i] + "' :" + illegalArgumentException);
                illegalArgumentException.printStackTrace(this.log);
                continue;
            }
            catch (WrappedTargetException wrappedTargetException) {
                this.log.println("Exception occured while trying to change property '" + this.testPropsNames[i] + "' :" + wrappedTargetException);
                wrappedTargetException.printStackTrace(this.log);
            }
        }
        if (this.testPropsAmount == 0) {
            this.log.println("all properties are read only");
            this.tRes.tested("addPropertiesChangeListener()", Status.skipped(true));
        } else {
            this.tRes.tested("addPropertiesChangeListener()", this.propertiesChanged);
        }
    }

    public void _firePropertiesChangeEvent() {
        this.requiredMethod("addPropertiesChangeListener()");
        this.propertiesChanged = false;
        this.oObj.firePropertiesChangeEvent(this.testPropsNames, this.PClistener);
        this.waitAMoment();
        this.tRes.tested("firePropertiesChangeEvent()", this.propertiesChanged);
    }

    public void _removePropertiesChangeListener() {
        this.requiredMethod("firePropertiesChangeEvent()");
        boolean bl = true;
        this.oObj.removePropertiesChangeListener(this.PClistener);
        this.tRes.tested("removePropertiesChangeListener()", bl);
    }

    public void _setPropertyValues() {
        this.requiredMethod("getPropertyValues()");
        boolean bl = true;
        if (this.testPropsNames.length == 1 && this.testPropsNames[0].equals("none")) {
            this.log.println("all properties are readOnly");
            this.tRes.tested("setPropertyValues()", Status.skipped(true));
            return;
        }
        this.log.println("Changing all properties");
        Object[] objectArray = this.oObj.getPropertyValues(this.testPropsNames);
        for (int i = 0; i < this.testPropsAmount; ++i) {
            Object object;
            Object object2 = objectArray[i];
            objectArray[i] = object = ValueChanger.changePValue(object2);
        }
        try {
            this.oObj.setPropertyValues(this.testPropsNames, objectArray);
            Object[] objectArray2 = this.oObj.getPropertyValues(this.testPropsNames);
            for (int i = 0; i < this.testPropsAmount; ++i) {
                if (!objectArray2[i].equals(objectArray[i])) continue;
                bl = true;
            }
        }
        catch (PropertyVetoException propertyVetoException) {
            this.log.println("Exception occured while setting properties");
            propertyVetoException.printStackTrace(this.log);
            bl = false;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.log.println("Exception occured while setting properties");
            illegalArgumentException.printStackTrace(this.log);
            bl = false;
        }
        catch (WrappedTargetException wrappedTargetException) {
            this.log.println("Exception occured while setting properties");
            wrappedTargetException.printStackTrace(this.log);
            bl = false;
        }
        this.tRes.tested("setPropertyValues()", bl);
    }

    private void getPropsToTest(Property[] propertyArray) {
        String string = "";
        for (int i = 0; i < propertyArray.length; ++i) {
            Property property = propertyArray[i];
            String string2 = property.Name;
            boolean bl = (property.Attributes & 0x10) == 0;
            boolean bl2 = (property.Attributes & 1) == 0;
            boolean bl3 = (property.Attributes & 2) != 0;
            boolean bl4 = this.exclProps.contains(string2);
            if (string2.indexOf("UserDefined") > 0 || string2.indexOf("Device") > 0) {
                bl = false;
            }
            this.values = this.oObj.getPropertyValues(new String[]{property.Name});
            boolean bl5 = utils.isVoid(this.values[0]);
            if (!bl || !bl2 || !bl3 || bl4 || bl5) continue;
            string = string + string2 + ";";
        }
        if (string.equals("")) {
            string = "none";
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ";");
        int n = stringTokenizer.countTokens();
        this.testPropsNames = new String[n];
        for (int i = 0; i < n; ++i) {
            this.testPropsNames[i] = stringTokenizer.nextToken();
        }
        this.testPropsAmount = n;
    }

    private void waitAMoment() {
        try {
            Thread.sleep(200L);
        }
        catch (InterruptedException interruptedException) {
            this.log.println("!!! Exception while waiting !!!");
        }
    }

    protected void after() {
        this.disposeEnvironment();
    }

    public class MyChangeListener
    implements XPropertiesChangeListener {
        public void propertiesChange(PropertyChangeEvent[] propertyChangeEventArray) {
            _XMultiPropertySet.this.propertiesChanged = true;
        }

        public void disposing(EventObject eventObject) {
        }
    }
}

