/*
 * Decompiled with CFR 0.152.
 */
package ifc.beans;

import com.sun.star.beans.PropertyVetoException;
import com.sun.star.beans.XHierarchicalPropertySetInfo;
import com.sun.star.beans.XMultiHierarchicalPropertySet;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.lang.WrappedTargetException;
import lib.MultiMethodTest;
import lib.Status;
import util.ValueChanger;
import util.ValueComparer;

public class _XMultiHierarchicalPropertySet
extends MultiMethodTest {
    public XMultiHierarchicalPropertySet oObj;

    public void _getHierarchicalPropertySetInfo() {
        XHierarchicalPropertySetInfo xHierarchicalPropertySetInfo = this.oObj.getHierarchicalPropertySetInfo();
        boolean bl = true;
        if (xHierarchicalPropertySetInfo == null) {
            this.log.println("The component doesn't provide HierarchicalPropertySetInfo");
            this.tRes.tested("getHierarchicalPropertySetInfo()", Status.skipped(true));
            return;
        }
        bl = this.checkHPSI(xHierarchicalPropertySetInfo);
        this.tRes.tested("getMultiHierarchicalPropertySetInfo()", bl);
    }

    public void _getHierarchicalPropertyValues() {
        String[] stringArray = (String[])this.tEnv.getObjRelation("PropertyNames");
        String[] stringArray2 = (String[])this.tEnv.getObjRelation("PropertyTypes");
        boolean bl = true;
        try {
            Object[] objectArray = this.oObj.getHierarchicalPropertyValues(stringArray);
            bl &= this.checkType(stringArray, stringArray2, objectArray);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.log.println("Exception " + illegalArgumentException.getMessage());
        }
        catch (WrappedTargetException wrappedTargetException) {
            this.log.println("Exception " + wrappedTargetException.getMessage());
        }
        this.tRes.tested("getHierarchicalPropertyValues()", bl);
    }

    public void _setHierarchicalPropertyValues() {
        String string = (String)this.tEnv.getObjRelation("allReadOnly");
        if (string != null) {
            this.log.println(string);
            this.tRes.tested("setHierarchicalPropertyValues()", Status.skipped(true));
            return;
        }
        String[] stringArray = (String[])this.tEnv.getObjRelation("PropertyNames");
        boolean bl = true;
        try {
            Object[] objectArray = this.oObj.getHierarchicalPropertyValues(stringArray);
            Object[] objectArray2 = new Object[objectArray.length];
            for (int i = 0; i < objectArray.length; ++i) {
                objectArray2[i] = ValueChanger.changePValue(objectArray[i]);
            }
            this.oObj.setHierarchicalPropertyValues(stringArray, objectArray2);
            Object[] objectArray3 = this.oObj.getHierarchicalPropertyValues(stringArray);
            for (int i = 0; i < stringArray.length; ++i) {
                boolean bl2 = ValueComparer.equalValue(objectArray3[i], objectArray2[i]);
                if (!bl2) {
                    this.log.println("didn't work for " + stringArray[i]);
                    this.log.println("Expected " + objectArray2[i].toString());
                    this.log.println("Getting " + objectArray3[i].toString());
                }
                this.oObj.setHierarchicalPropertyValues(stringArray, objectArray);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.log.println("IllegalArgument " + illegalArgumentException.getMessage());
        }
        catch (PropertyVetoException propertyVetoException) {
            this.log.println("VetoException " + propertyVetoException.getMessage());
        }
        catch (WrappedTargetException wrappedTargetException) {
            this.log.println("WrappedTarget " + wrappedTargetException.getMessage());
        }
        this.tRes.tested("setHierarchicalPropertyValues()", bl);
    }

    protected boolean checkHPSI(XHierarchicalPropertySetInfo xHierarchicalPropertySetInfo) {
        this.log.println("Checking the resulting HierarchicalPropertySetInfo");
        this.log.println("### NOT yet implemented");
        return true;
    }

    protected boolean checkType(String[] stringArray, String[] stringArray2, Object[] objectArray) {
        boolean bl = true;
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray2[i].equals("Boolean")) {
                bl &= objectArray[i] instanceof Boolean;
                if (objectArray[i] instanceof Boolean) continue;
                this.log.println("Wrong Type for property " + stringArray[i]);
                this.log.println("Expected " + stringArray2[i]);
                this.log.println("getting " + objectArray[i].getClass());
                continue;
            }
            if (!stringArray2[i].equals("Short")) continue;
            bl &= objectArray[i] instanceof Short;
            if (objectArray[i] instanceof Short) continue;
            this.log.println("Wrong Type for property " + stringArray[i]);
            this.log.println("Expected " + stringArray2[i]);
            this.log.println("getting " + objectArray[i].getClass());
        }
        return bl;
    }
}

