/*
 * Decompiled with CFR 0.152.
 */
package ifc.accessibility;

import com.sun.star.accessibility.IllegalAccessibleComponentStateException;
import com.sun.star.accessibility.XAccessible;
import com.sun.star.accessibility.XAccessibleContext;
import com.sun.star.accessibility.XAccessibleRelationSet;
import com.sun.star.accessibility.XAccessibleStateSet;
import com.sun.star.lang.IndexOutOfBoundsException;
import com.sun.star.lang.Locale;
import lib.MultiMethodTest;
import util.AccessibilityTools;
import util.utils;

public class _XAccessibleContext
extends MultiMethodTest {
    private static final String className = "com.sun.star.accessibility.XAccessibleContext";
    public XAccessibleContext oObj = null;
    private int childCount = 0;
    private XAccessible parent = null;

    protected String getTestedClassName() {
        return className;
    }

    public void _getAccessibleChildCount() {
        this.childCount = this.oObj.getAccessibleChildCount();
        this.log.println("" + this.childCount + " children found.");
        this.tRes.tested("getAccessibleChildCount()", this.childCount > -1);
    }

    public void _getAccessibleChild() {
        this.requiredMethod("getAccessibleChildCount()");
        this.log.println("testing 'getAccessibleChild()'...");
        boolean bl = true;
        int n = this.childCount;
        if (this.childCount > 500) {
            n = 500;
        }
        for (int i = 0; i < n; ++i) {
            try {
                XAccessible xAccessible = this.oObj.getAccessibleChild(i);
                XAccessibleContext xAccessibleContext = xAccessible.getAccessibleContext();
                this.log.println("## Child " + i + ": " + xAccessibleContext.getAccessibleDescription());
                if (!AccessibilityTools.equals(xAccessibleContext.getAccessibleParent().getAccessibleContext(), this.oObj)) {
                    this.log.println("The parent of child and component itself differ.");
                    this.log.println("\tRole:");
                    this.log.println("Getting:  " + xAccessibleContext.getAccessibleParent().getAccessibleContext().getAccessibleRole());
                    this.log.println("Expected: " + this.oObj.getAccessibleRole());
                    this.log.println("\tImplementationName:");
                    this.log.println("Getting:  " + utils.getImplName(xAccessibleContext.getAccessibleParent().getAccessibleContext()));
                    this.log.println("Expected: " + utils.getImplName(this.oObj));
                    this.log.println("\tAccessibleDescription:");
                    this.log.println("Getting(Description):  " + xAccessibleContext.getAccessibleParent().getAccessibleContext().getAccessibleDescription());
                    this.log.println("Expected(Description): " + this.oObj.getAccessibleDescription());
                    this.log.println("\tAccessibleName:");
                    this.log.println("Getting(Name):  " + xAccessibleContext.getAccessibleParent().getAccessibleContext().getAccessibleName());
                    this.log.println("Expected(Name): " + this.oObj.getAccessibleName());
                    this.log.println("\tChildCount:");
                    this.log.println("Getting:  " + xAccessibleContext.getAccessibleParent().getAccessibleContext().getAccessibleChildCount());
                    this.log.println("Expected: " + this.oObj.getAccessibleChildCount());
                    this.log.println("\tParentName:");
                    this.log.println("Getting (Name):  " + xAccessibleContext.getAccessibleParent().getAccessibleContext().getAccessibleParent().getAccessibleContext().getAccessibleName());
                    this.log.println("Expected(Name): " + this.oObj.getAccessibleParent().getAccessibleContext().getAccessibleName());
                    this.log.println("##");
                    bl = false;
                    continue;
                }
                this.log.println("Role: " + xAccessibleContext.getAccessibleRole());
                this.log.println("Name: " + xAccessibleContext.getAccessibleName());
                this.log.println("IndexInParent: " + xAccessibleContext.getAccessibleIndexInParent());
                this.log.println("ImplementationName: " + utils.getImplName(xAccessibleContext));
                continue;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                indexOutOfBoundsException.printStackTrace(this.log);
                bl = false;
            }
        }
        this.tRes.tested("getAccessibleChild()", bl);
    }

    public void _getAccessibleParent() {
        this.parent = this.oObj.getAccessibleParent();
        this.tRes.tested("getAccessibleParent()", this.parent != null);
    }

    public void _getAccessibleIndexInParent() {
        this.requiredMethod("getAccessibleParent()");
        boolean bl = true;
        int n = this.oObj.getAccessibleIndexInParent();
        XAccessibleContext xAccessibleContext = this.parent.getAccessibleContext();
        try {
            if (xAccessibleContext.getAccessibleChild(n) == null) {
                this.log.println("Parent has no child with this index");
                bl &= false;
            } else {
                bl &= AccessibilityTools.equals(xAccessibleContext.getAccessibleChild(n).getAccessibleContext(), this.oObj);
            }
            if (!bl) {
                this.log.println("Expected: " + utils.getImplName(this.oObj));
                if (xAccessibleContext.getAccessibleChild(n) != null) {
                    this.log.println("Getting: " + utils.getImplName(xAccessibleContext.getAccessibleChild(n).getAccessibleContext()));
                }
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            indexOutOfBoundsException.printStackTrace(this.log);
            bl = false;
        }
        this.tRes.tested("getAccessibleIndexInParent()", bl);
    }

    public void _getAccessibleRole() {
        short s = this.oObj.getAccessibleRole();
        this.log.println("The role is " + s);
        this.tRes.tested("getAccessibleRole()", s > -1);
    }

    public void _getAccessibleName() {
        String string = this.oObj.getAccessibleName();
        this.log.println("The name is '" + string + "'");
        this.tRes.tested("getAccessibleName()", string != null);
    }

    public void _getAccessibleDescription() {
        String string = this.oObj.getAccessibleDescription();
        this.log.println("The description is '" + string + "'");
        this.tRes.tested("getAccessibleDescription()", string != null);
    }

    public void _getAccessibleRelationSet() {
        XAccessibleRelationSet xAccessibleRelationSet = this.oObj.getAccessibleRelationSet();
        this.tRes.tested("getAccessibleRelationSet()", true);
    }

    public void _getAccessibleStateSet() {
        XAccessibleStateSet xAccessibleStateSet = this.oObj.getAccessibleStateSet();
        boolean bl = true;
        String[] stringArray = (String[])this.tEnv.getObjRelation("expectedStateNames");
        short[] sArray = (short[])this.tEnv.getObjRelation("expectedStates");
        bl = stringArray != null && sArray != null ? this.checkStates(stringArray, sArray, xAccessibleStateSet) : xAccessibleStateSet != null;
        this.tRes.tested("getAccessibleStateSet()", bl);
    }

    public void _getLocale() {
        Locale locale = null;
        try {
            locale = this.oObj.getLocale();
            this.log.println("The locale is " + locale.Language + "," + locale.Country);
        }
        catch (IllegalAccessibleComponentStateException illegalAccessibleComponentStateException) {
            illegalAccessibleComponentStateException.printStackTrace(this.log);
        }
        this.tRes.tested("getLocale()", locale != null && locale.Language.length() > 0 && locale.Country.length() > 0);
    }

    protected boolean checkStates(String[] stringArray, short[] sArray, XAccessibleStateSet xAccessibleStateSet) {
        boolean bl = true;
        for (int i = 0; i < stringArray.length; ++i) {
            boolean bl2 = xAccessibleStateSet.contains(sArray[i]);
            if (bl2) {
                this.log.println("Set contains " + stringArray[i] + " ... OK");
                bl &= true;
                continue;
            }
            this.log.println("Set doesn't contain " + stringArray[i] + " ... FAILED");
            bl &= false;
        }
        return bl;
    }
}

