/*
 * Decompiled with CFR 0.152.
 */
package org.openoffice.xmerge.converter.xml.sxw.pocketword;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Vector;
import org.openoffice.xmerge.Document;
import org.openoffice.xmerge.converter.xml.ParaStyle;
import org.openoffice.xmerge.converter.xml.TextStyle;
import org.openoffice.xmerge.converter.xml.sxw.pocketword.DocumentDescriptor;
import org.openoffice.xmerge.converter.xml.sxw.pocketword.Paragraph;
import org.openoffice.xmerge.converter.xml.sxw.pocketword.PocketWordConstants;

public class PocketWordDocument
implements Document,
PocketWordConstants {
    private String docName;
    private byte[] preamble;
    private Vector fonts;
    private DocumentDescriptor descriptor;
    private Vector paragraphs;
    private ParaStyle pStyle;
    private Paragraph currentPara;
    private static final byte[] trailer;

    static {
        byte[] byArray = new byte[18];
        byArray[0] = -126;
        byArray[2] = 9;
        byArray[4] = 3;
        byArray[6] = -126;
        trailer = byArray;
    }

    public PocketWordDocument(String string) {
        this.docName = this.trimDocumentName(string);
        this.preamble = new byte[52];
        this.fonts = new Vector(0, 1);
        this.descriptor = new DocumentDescriptor();
        this.paragraphs = new Vector(0, 1);
    }

    public void addParagraph(ParaStyle paraStyle, boolean bl) {
        Paragraph paragraph = new Paragraph(paraStyle);
        this.paragraphs.add(paragraph);
        this.pStyle = paraStyle;
        this.currentPara = paragraph;
        if (bl) {
            paragraph.setBullets(true);
        }
    }

    public void addParagraphData(String string, TextStyle textStyle) {
        if (this.currentPara == null) {
            this.addParagraph(null, false);
        }
        this.currentPara.addTextSegment(string, textStyle);
    }

    public String getFileName() {
        return new String(String.valueOf(this.docName) + ".psw");
    }

    public String getName() {
        return this.docName;
    }

    public Enumeration getParagraphEnumeration() {
        return this.paragraphs.elements();
    }

    private void initPreamble() {
        byte[] byArray = new byte[52];
        byArray[0] = 123;
        byArray[1] = 92;
        byArray[2] = 112;
        byArray[3] = 119;
        byArray[4] = 105;
        byArray[5] = 21;
        byArray[8] = 1;
        byArray[9] = 1;
        byArray[10] = 6;
        byArray[16] = 2;
        byArray[18] = 44;
        byArray[20] = 1;
        byArray[22] = 10;
        byArray[24] = 2;
        byArray[36] = 1;
        byArray[38] = 1;
        this.preamble = byArray;
    }

    private void loadFonts() {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            byteArrayOutputStream.write(new String("Tahoma").getBytes("UTF-16LE"));
            byteArrayOutputStream.write(new byte[52]);
            byte[] byArray = new byte[4];
            byArray[0] = 2;
            byArray[2] = 1;
            byteArrayOutputStream.write(byArray);
            byte[] byArray2 = new byte[4];
            byArray2[2] = 1;
            byteArrayOutputStream.write(byArray2);
            byteArrayOutputStream.write(new byte[4]);
            byteArrayOutputStream.write(new byte[4]);
            this.fonts.add(byteArrayOutputStream);
            byteArrayOutputStream = new ByteArrayOutputStream();
            byteArrayOutputStream.write(new String("Courier New").getBytes("UTF-16LE"));
            byteArrayOutputStream.write(new byte[42]);
            byte[] byArray3 = new byte[4];
            byArray3[0] = 20;
            byArray3[2] = 4;
            byteArrayOutputStream.write(byArray3);
            byte[] byArray4 = new byte[4];
            byArray4[0] = 1;
            byteArrayOutputStream.write(byArray4);
            byte[] byArray5 = new byte[4];
            byArray5[2] = 21;
            byteArrayOutputStream.write(byArray5);
            byte[] byArray6 = new byte[4];
            byArray6[0] = 5;
            byArray6[2] = 1;
            byteArrayOutputStream.write(byArray6);
            this.fonts.add(byteArrayOutputStream);
        }
        catch (IOException iOException) {}
    }

    public void read(InputStream inputStream) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream;
        int n;
        if (inputStream == null) {
            throw new IOException("No input stream to convert");
        }
        int n2 = inputStream.read(this.preamble);
        if (n2 == -1) {
            System.err.println("Error:invalid input stream");
            return;
        }
        byte[] byArray = new byte[80];
        boolean bl = false;
        do {
            inputStream.read(byArray);
            String string = new String(byArray, 0, 64, "UTF-16LE");
            this.fonts.add(string.trim());
        } while (byArray[76] != 5 || byArray[77] != 0 || byArray[78] != 1 || byArray[79] != 0);
        ByteArrayOutputStream byteArrayOutputStream2 = new ByteArrayOutputStream();
        while ((n = inputStream.read()) != -1) {
            byteArrayOutputStream2.write(n);
        }
        byte[] byArray2 = byteArrayOutputStream2.toByteArray();
        int n3 = 0;
        int n4 = 0;
        boolean bl2 = false;
        int n5 = 0;
        while (n5 < byArray2.length) {
            if (byArray2[n5 + 2] == -1 && byArray2[n5 + 3] == -1 && !bl2) {
                n3 = n5 - 8;
                bl2 = true;
            } else if (byArray2[n5 + 2] == -1 && byArray2[n5 + 3] == -1 && bl2) {
                n4 = n5 - 8;
                byteArrayOutputStream = new ByteArrayOutputStream();
                byteArrayOutputStream.write(byArray2, n3, n4 - n3);
                this.paragraphs.add(new Paragraph(byteArrayOutputStream.toByteArray()));
                bl2 = false;
                n5 -= 4;
            }
            n5 += 4;
        }
        byteArrayOutputStream = new ByteArrayOutputStream();
        if (byArray2[byArray2.length - 19] == 0) {
            byteArrayOutputStream.write(byArray2, n3, byArray2.length - n3 - 20);
        } else {
            byteArrayOutputStream.write(byArray2, n3, byArray2.length - n3 - 18);
        }
        this.paragraphs.add(new Paragraph(byteArrayOutputStream.toByteArray()));
    }

    private String trimDocumentName(String string) {
        String string2 = string.toLowerCase();
        if (string2.endsWith(".psw")) {
            int n = string.length();
            int n2 = n - ".psw".length();
            string = string.substring(0, n2);
        }
        return string;
    }

    public void write(OutputStream outputStream) throws IOException {
        DataOutputStream dataOutputStream = new DataOutputStream(outputStream);
        this.initPreamble();
        dataOutputStream.write(this.preamble);
        this.loadFonts();
        int n = 0;
        while (n < this.fonts.size()) {
            ByteArrayOutputStream byteArrayOutputStream = (ByteArrayOutputStream)this.fonts.elementAt(n);
            dataOutputStream.write(byteArrayOutputStream.toByteArray());
            ++n;
        }
        int n2 = 0;
        while (n2 < this.paragraphs.size()) {
            Paragraph paragraph = (Paragraph)this.paragraphs.elementAt(n2);
            this.descriptor.addParagraph((short)paragraph.getTextLength(), paragraph.getLines());
            ++n2;
        }
        dataOutputStream.write(this.descriptor.getDescriptor());
        int n3 = 0;
        while (n3 < this.paragraphs.size()) {
            Paragraph paragraph = (Paragraph)this.paragraphs.elementAt(n3);
            if (n3 + 1 == this.paragraphs.size()) {
                paragraph.setLastParagraph(true);
            }
            dataOutputStream.write(paragraph.getParagraphData());
            ++n3;
        }
        if (dataOutputStream.size() % 4 == 0) {
            dataOutputStream.write(0);
            dataOutputStream.write(0);
        }
        dataOutputStream.write(trailer);
        dataOutputStream.flush();
        dataOutputStream.close();
    }
}

