/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.bdb.bind.tuple;

import com.sleepycat.bdb.bind.DataBinding;
import com.sleepycat.bdb.bind.DataBuffer;
import com.sleepycat.bdb.bind.DataFormat;
import com.sleepycat.bdb.bind.tuple.TupleFormat;
import com.sleepycat.bdb.bind.tuple.TupleInput;
import com.sleepycat.bdb.bind.tuple.TupleOutput;
import java.io.IOException;

public abstract class TupleBinding
implements DataBinding {
    protected TupleFormat format;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Character;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Double;

    public TupleBinding(TupleFormat format) {
        this.format = format;
    }

    public Object dataToObject(DataBuffer data) throws IOException {
        return this.dataToObject(this.format.dataToInput(data));
    }

    public void objectToData(Object object, DataBuffer data) throws IOException {
        TupleOutput output = this.format.newOutput();
        this.objectToData(object, output);
        this.format.outputToData(output, data);
    }

    public DataFormat getDataFormat() {
        return this.format;
    }

    public abstract Object dataToObject(TupleInput var1) throws IOException;

    public abstract void objectToData(Object var1, TupleOutput var2) throws IOException;

    public static TupleBinding getPrimitiveBinding(Class cls, TupleFormat format) {
        if (cls == (class$java$lang$String == null ? (class$java$lang$String = TupleBinding.class$("java.lang.String")) : class$java$lang$String)) {
            return new StringBinding(format);
        }
        if (cls == (class$java$lang$Character == null ? (class$java$lang$Character = TupleBinding.class$("java.lang.Character")) : class$java$lang$Character)) {
            return new CharacterBinding(format);
        }
        if (cls == (class$java$lang$Boolean == null ? (class$java$lang$Boolean = TupleBinding.class$("java.lang.Boolean")) : class$java$lang$Boolean)) {
            return new BooleanBinding(format);
        }
        if (cls == (class$java$lang$Byte == null ? (class$java$lang$Byte = TupleBinding.class$("java.lang.Byte")) : class$java$lang$Byte)) {
            return new ByteBinding(format);
        }
        if (cls == (class$java$lang$Short == null ? (class$java$lang$Short = TupleBinding.class$("java.lang.Short")) : class$java$lang$Short)) {
            return new ShortBinding(format);
        }
        if (cls == (class$java$lang$Integer == null ? (class$java$lang$Integer = TupleBinding.class$("java.lang.Integer")) : class$java$lang$Integer)) {
            return new IntegerBinding(format);
        }
        if (cls == (class$java$lang$Long == null ? (class$java$lang$Long = TupleBinding.class$("java.lang.Long")) : class$java$lang$Long)) {
            return new LongBinding(format);
        }
        if (cls == (class$java$lang$Float == null ? (class$java$lang$Float = TupleBinding.class$("java.lang.Float")) : class$java$lang$Float)) {
            return new FloatBinding(format);
        }
        if (cls == (class$java$lang$Double == null ? (class$java$lang$Double = TupleBinding.class$("java.lang.Double")) : class$java$lang$Double)) {
            return new DoubleBinding(format);
        }
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class DoubleBinding
    extends TupleBinding {
        public DoubleBinding(TupleFormat format) {
            super(format);
        }

        public Object dataToObject(TupleInput input) throws IOException {
            return new Double(input.readDouble());
        }

        public void objectToData(Object object, TupleOutput output) throws IOException {
            output.writeDouble(((Number)object).doubleValue());
        }
    }

    private static class FloatBinding
    extends TupleBinding {
        public FloatBinding(TupleFormat format) {
            super(format);
        }

        public Object dataToObject(TupleInput input) throws IOException {
            return new Float(input.readFloat());
        }

        public void objectToData(Object object, TupleOutput output) throws IOException {
            output.writeFloat(((Number)object).floatValue());
        }
    }

    private static class LongBinding
    extends TupleBinding {
        public LongBinding(TupleFormat format) {
            super(format);
        }

        public Object dataToObject(TupleInput input) throws IOException {
            return new Long(input.readLong());
        }

        public void objectToData(Object object, TupleOutput output) throws IOException {
            output.writeLong(((Number)object).longValue());
        }
    }

    private static class IntegerBinding
    extends TupleBinding {
        public IntegerBinding(TupleFormat format) {
            super(format);
        }

        public Object dataToObject(TupleInput input) throws IOException {
            return new Integer(input.readInt());
        }

        public void objectToData(Object object, TupleOutput output) throws IOException {
            output.writeInt(((Number)object).intValue());
        }
    }

    private static class ShortBinding
    extends TupleBinding {
        public ShortBinding(TupleFormat format) {
            super(format);
        }

        public Object dataToObject(TupleInput input) throws IOException {
            return new Short(input.readShort());
        }

        public void objectToData(Object object, TupleOutput output) throws IOException {
            output.writeShort(((Number)object).shortValue());
        }
    }

    private static class ByteBinding
    extends TupleBinding {
        public ByteBinding(TupleFormat format) {
            super(format);
        }

        public Object dataToObject(TupleInput input) throws IOException {
            return new Byte(input.readByte());
        }

        public void objectToData(Object object, TupleOutput output) throws IOException {
            output.writeByte(((Number)object).byteValue());
        }
    }

    private static class BooleanBinding
    extends TupleBinding {
        public BooleanBinding(TupleFormat format) {
            super(format);
        }

        public Object dataToObject(TupleInput input) throws IOException {
            return new Boolean(input.readBoolean());
        }

        public void objectToData(Object object, TupleOutput output) throws IOException {
            output.writeBoolean((Boolean)object);
        }
    }

    private static class CharacterBinding
    extends TupleBinding {
        public CharacterBinding(TupleFormat format) {
            super(format);
        }

        public Object dataToObject(TupleInput input) throws IOException {
            return new Character(input.readChar());
        }

        public void objectToData(Object object, TupleOutput output) throws IOException {
            output.writeChar(((Character)object).charValue());
        }
    }

    private static class StringBinding
    extends TupleBinding {
        public StringBinding(TupleFormat format) {
            super(format);
        }

        public Object dataToObject(TupleInput input) throws IOException {
            return input.readString();
        }

        public void objectToData(Object object, TupleOutput output) throws IOException {
            output.writeString((String)object);
        }
    }
}

