/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.bdb.bind.serial;

import com.sleepycat.bdb.bind.serial.SerialFormat;
import com.sleepycat.bdb.bind.serial.TupleSerialKeyExtractor;
import com.sleepycat.bdb.bind.serial.TupleSerialMarshalledBinding;
import com.sleepycat.bdb.bind.tuple.MarshalledTupleKeyEntity;
import com.sleepycat.bdb.bind.tuple.TupleFormat;
import com.sleepycat.bdb.bind.tuple.TupleInput;
import com.sleepycat.bdb.bind.tuple.TupleOutput;
import java.io.IOException;

public class TupleSerialMarshalledKeyExtractor
extends TupleSerialKeyExtractor {
    private TupleSerialMarshalledBinding binding;
    private String keyName;

    public TupleSerialMarshalledKeyExtractor(TupleSerialMarshalledBinding binding, TupleFormat indexKeyFormat, String keyName, boolean usePrimaryKey, boolean useValue) {
        super(usePrimaryKey ? (TupleFormat)binding.getKeyFormat() : null, useValue ? (SerialFormat)binding.getValueFormat() : null, indexKeyFormat);
        this.binding = binding;
        this.keyName = keyName;
        if (this.valueFormat == null) {
            throw new IllegalArgumentException("valueFormat may not be null");
        }
    }

    public void extractIndexKey(TupleInput primaryKeyInput, Object valueInput, TupleOutput indexKeyOutput) throws IOException {
        MarshalledTupleKeyEntity entity = (MarshalledTupleKeyEntity)this.binding.dataToObject(primaryKeyInput, valueInput);
        entity.marshalIndexKey(this.keyName, indexKeyOutput);
    }

    public void clearIndexKey(Object valueInput) throws IOException {
        MarshalledTupleKeyEntity entity = (MarshalledTupleKeyEntity)this.binding.dataToObject(null, valueInput);
        entity.clearIndexKey(this.keyName);
    }
}

