/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.bdb;

import com.sleepycat.bdb.CurrentTransaction;
import com.sleepycat.bdb.DataCursor;
import com.sleepycat.bdb.DataDb;
import com.sleepycat.bdb.DataIndex;
import com.sleepycat.bdb.DataStore;
import com.sleepycat.bdb.DataThang;
import com.sleepycat.bdb.KeyRange;
import com.sleepycat.bdb.KeyRangeException;
import com.sleepycat.bdb.RecordNumberFormat;
import com.sleepycat.bdb.bind.DataBinding;
import com.sleepycat.bdb.bind.DataFormat;
import com.sleepycat.bdb.bind.EntityBinding;
import com.sleepycat.bdb.bind.KeyExtractor;
import com.sleepycat.db.Db;
import com.sleepycat.db.DbEnv;
import com.sleepycat.db.DbException;
import com.sleepycat.db.Dbc;
import java.io.IOException;
import java.util.Collection;

public final class DataView
implements Cloneable {
    private static final KeyRange NULL_RANGE = new KeyRange();
    DataDb db;
    DataStore store;
    DataIndex index;
    KeyRange range;
    boolean writeAllowed;
    boolean dirtyRead;
    boolean transactional;
    boolean dirtyReadAllowed;
    boolean autoCommit;
    DataBinding keyBinding;
    DataBinding valueBinding;
    EntityBinding entityBinding;
    boolean recNumAccess;
    boolean btreeRecNumAccess;

    public DataView(DataStore store, DataIndex index, DataBinding keyBinding, DataBinding valueBinding, EntityBinding entityBinding, boolean writeAllowed) throws IllegalArgumentException {
        if (index != null) {
            this.db = index.db;
            this.index = index;
            this.store = index.store;
        } else {
            if (store == null) {
                throw new IllegalArgumentException("both store and index are null");
            }
            this.db = store.db;
            this.store = store;
        }
        this.writeAllowed = writeAllowed;
        this.range = NULL_RANGE;
        this.keyBinding = keyBinding;
        this.valueBinding = valueBinding;
        this.entityBinding = entityBinding;
        this.transactional = this.db.isTransactional();
        boolean bl = this.dirtyReadAllowed = !(!this.transactional || store != null && !store.db.isDirtyReadAllowed() || index != null && !index.db.isDirtyReadAllowed());
        if (valueBinding != null && entityBinding != null) {
            throw new IllegalArgumentException("both valueBinding and entityBinding are non-null");
        }
        if (keyBinding != null && keyBinding.getDataFormat() instanceof RecordNumberFormat) {
            if (!this.db.hasRecNumAccess()) {
                throw new IllegalArgumentException("RecordNumberFormat requires DB_BTREE/DB_RECNUM, DB_RECNO, or DB_QUEUE");
            }
            this.recNumAccess = true;
            if (this.db.type == 1) {
                this.btreeRecNumAccess = true;
            }
        }
        this.checkBindingFormats();
    }

    private DataView cloneView() {
        try {
            return (DataView)super.clone();
        }
        catch (CloneNotSupportedException willNeverOccur) {
            return null;
        }
    }

    public DataView keySetView() {
        if (this.keyBinding == null) {
            throw new UnsupportedOperationException("must have keyBinding");
        }
        DataView view = this.cloneView();
        view.valueBinding = null;
        view.entityBinding = null;
        return view;
    }

    public DataView valueSetView() {
        if (this.valueBinding == null && this.entityBinding == null) {
            throw new UnsupportedOperationException("must have valueBinding or entityBinding");
        }
        DataView view = this.cloneView();
        view.keyBinding = null;
        return view;
    }

    public DataView valueSetView(Object singleKey) throws DbException, IOException, KeyRangeException {
        KeyRange singleKeyRange = this.subRange(singleKey);
        DataView view = this.valueSetView();
        view.range = singleKeyRange;
        return view;
    }

    public DataView subView(Object beginKey, boolean beginInclusive, Object endKey, boolean endInclusive, DataBinding keyBinding) throws DbException, IOException, KeyRangeException {
        DataView view = this.cloneView();
        view.setRange(beginKey, beginInclusive, endKey, endInclusive);
        if (keyBinding != null) {
            view.keyBinding = keyBinding;
        }
        return view;
    }

    public DataView dirtyReadView(boolean enable) {
        if (!this.isDirtyReadAllowed()) {
            return this;
        }
        DataView view = this.cloneView();
        view.dirtyRead = enable;
        return view;
    }

    public DataView autoCommitView(boolean enable) {
        if (!this.isTransactional()) {
            return this;
        }
        DataView view = this.cloneView();
        view.autoCommit = enable;
        return view;
    }

    public CurrentTransaction getCurrentTxn() {
        return this.isTransactional() ? this.db.env : null;
    }

    private void setRange(Object beginKey, boolean beginInclusive, Object endKey, boolean endInclusive) throws DbException, IOException, KeyRangeException {
        this.range = this.subRange(beginKey, beginInclusive, endKey, endInclusive);
    }

    public DataThang getSingleKeyThang() {
        return this.range.getSingleKey();
    }

    public DataDb getDb() {
        return this.db;
    }

    public final DbEnv getEnv() {
        return this.db.env.getEnv();
    }

    public final boolean isAutoCommit() {
        return this.autoCommit || this.db.env.isAutoCommit();
    }

    public final DataStore getStore() {
        return this.store;
    }

    public final DataIndex getIndex() {
        return this.index;
    }

    public final DataBinding getKeyBinding() {
        return this.keyBinding;
    }

    public final DataBinding getValueBinding() {
        return this.valueBinding;
    }

    public final EntityBinding getValueEntityBinding() {
        return this.entityBinding;
    }

    public final boolean areDuplicatesAllowed() {
        return this.db.areDuplicatesAllowed();
    }

    public final boolean areDuplicatesOrdered() {
        return this.db.areDuplicatesOrdered();
    }

    public final boolean areKeysRenumbered() {
        return this.btreeRecNumAccess || this.db.areKeysRenumbered();
    }

    public final boolean isOrdered() {
        return this.db.isOrdered();
    }

    public final boolean isWriteAllowed() {
        return this.writeAllowed;
    }

    public final boolean isDirtyReadAllowed() {
        return this.dirtyReadAllowed;
    }

    public final boolean isDirtyReadEnabled() {
        return this.dirtyRead;
    }

    public final boolean isTransactional() {
        return this.transactional;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEmpty() throws DbException, IOException {
        Dbc cursor = this.db.openCursor(false);
        try {
            int err;
            DataThang val = DataThang.getDiscardDataThang();
            DataThang key = this.range.hasBound() ? new DataThang() : val;
            int flags = Db.DB_FIRST;
            if (this.dirtyRead) {
                flags |= Db.DB_DIRTY_READ;
            }
            boolean bl = (err = this.range.get(this.db, cursor, key, val, flags)) != 0 && err != 12;
            return bl;
        }
        finally {
            this.db.closeCursor(cursor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int get(Object key, Object value, int flags, boolean lockForWrite, Object[] retValue) throws DbException, IOException {
        if (flags == 0) {
            flags = Db.DB_SET;
        } else if (flags != Db.DB_SET && flags != Db.DB_GET_BOTH) {
            throw new IllegalArgumentException("flag not allowed");
        }
        DataCursor cursor = null;
        try {
            cursor = new DataCursor(this, false);
            int err = cursor.get(key, value, flags, lockForWrite);
            if (err == 0 && retValue != null) {
                retValue[0] = cursor.getCurrentValue();
            }
            int n = err;
            return n;
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
        }
    }

    public int consume(int flags, Object[] retPrimaryKey, Object[] retValue) throws DbException, IOException {
        if (!this.writeAllowed) {
            throw new UnsupportedOperationException("write not allowed");
        }
        if (flags != Db.DB_CONSUME && flags != Db.DB_CONSUME_WAIT) {
            throw new IllegalArgumentException("flag not allowed");
        }
        DataThang keyThang = new DataThang();
        DataThang valueThang = new DataThang();
        int err = this.store.db.get(keyThang, valueThang, flags);
        if (err == 0) {
            this.store.applyChange(keyThang, valueThang, null);
            this.returnPrimaryKeyAndValue(keyThang, valueThang, retPrimaryKey, retValue);
        }
        return err;
    }

    public int put(Object primaryKey, Object value, int flags, Object[] oldValue) throws DbException, IOException {
        if (!this.writeAllowed) {
            throw new UnsupportedOperationException("write not allowed");
        }
        if (flags != 0 && flags != Db.DB_NOOVERWRITE && flags != Db.DB_NODUPDATA) {
            throw new IllegalArgumentException("flags not allowed: " + flags);
        }
        if (this.index != null) {
            throw new UnsupportedOperationException("cannot put() with index");
        }
        if (oldValue != null) {
            oldValue[0] = null;
        }
        DataThang keyThang = new DataThang();
        DataThang valueThang = new DataThang();
        DataThang oldValueThang = null;
        int err = this.useKey(primaryKey, value, keyThang, this.range);
        if (err != 0) {
            throw new IllegalArgumentException("primaryKey out of range " + keyThang + this.range);
        }
        if (flags == 0 && !this.areDuplicatesAllowed()) {
            oldValueThang = new DataThang();
            err = this.store.db.get(keyThang, oldValueThang, this.db.env.getWriteLockFlag());
            if (err == 0) {
                if (oldValue != null) {
                    oldValue[0] = this.makeValue(keyThang, oldValueThang);
                }
            } else {
                oldValueThang = null;
            }
        }
        this.useValue(value, valueThang, null);
        err = this.store.db.put(keyThang, valueThang, flags);
        if (err == 0) {
            this.store.applyChange(keyThang, oldValueThang, valueThang);
        }
        return err;
    }

    public int addValue(DataThang primaryKeyThang, Object value, int flags) throws DbException, IOException {
        if (!this.writeAllowed) {
            throw new UnsupportedOperationException("write not allowed");
        }
        if (!this.areDuplicatesAllowed()) {
            throw new UnsupportedOperationException("duplicates required");
        }
        if (flags != 0 && flags != Db.DB_NODUPDATA && flags != Db.DB_KEYFIRST && flags != Db.DB_KEYLAST) {
            throw new IllegalArgumentException("flags not allowed: " + flags);
        }
        DataThang valueThang = new DataThang();
        if (!this.range.check(primaryKeyThang)) {
            throw new IllegalArgumentException("primaryKey out of range");
        }
        this.useValue(value, valueThang, null);
        int err = this.store.db.put(primaryKeyThang, valueThang, flags);
        if (err == 0) {
            this.store.applyChange(primaryKeyThang, null, valueThang);
        }
        return err;
    }

    public int append(Object value, Object[] retPrimaryKey, Object[] retValue) throws DbException, IOException {
        int flags;
        if (!this.writeAllowed) {
            throw new UnsupportedOperationException("write not allowed");
        }
        DataThang keyThang = new DataThang();
        DataThang valueThang = new DataThang();
        if (this.store.keyAssigner != null) {
            this.store.keyAssigner.assignKey(keyThang);
            if (!this.range.check(keyThang)) {
                throw new IllegalArgumentException("assigned key out of range");
            }
            flags = Db.DB_NOOVERWRITE;
        } else {
            if (this.db.type != 4 && this.db.type != 3) {
                throw new UnsupportedOperationException("DB_QUEUE or DB_RECNO type is required");
            }
            flags = Db.DB_APPEND;
        }
        this.useValue(value, valueThang, null);
        int err = this.store.db.put(keyThang, valueThang, flags);
        if (err == 0) {
            if (this.store.keyAssigner == null && !this.range.check(keyThang)) {
                this.store.db.delete(keyThang, 0);
                throw new IllegalArgumentException("appended record number out of range");
            }
            this.store.applyChange(keyThang, null, valueThang);
            this.returnPrimaryKeyAndValue(keyThang, valueThang, retPrimaryKey, retValue);
        }
        return err;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear(Collection oldValues) throws DbException, IOException {
        DataCursor cursor = null;
        try {
            cursor = new DataCursor(this, true);
            int op = this.areKeysRenumbered() ? Db.DB_FIRST : Db.DB_NEXT;
            int err = 0;
            while (err == 0) {
                err = cursor.get(null, null, op, true);
                if (err != 0) continue;
                if (oldValues != null) {
                    oldValues.add(cursor.getCurrentValue());
                }
                if ((err = cursor.delete()) == 0) continue;
                throw new DbException("Unexpected error on delete", err);
            }
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DataCursor join(DataView[] indexViews, Object[] indexKeys, boolean presorted) throws DbException, IOException {
        DataCursor dataCursor;
        block9: {
            DataCursor joinCursor = null;
            DataCursor[] indexCursors = new DataCursor[indexViews.length];
            try {
                for (int i = 0; i < indexViews.length; ++i) {
                    indexCursors[i] = new DataCursor(indexViews[i], false);
                    indexCursors[i].get(indexKeys[i], null, Db.DB_SET, false);
                }
                dataCursor = joinCursor = new DataCursor(this, indexCursors, presorted, true);
                Object var8_8 = null;
                if (joinCursor != null) break block9;
            }
            catch (Throwable throwable) {
                Object var8_9 = null;
                if (joinCursor == null) {
                    for (int i = 0; i < indexCursors.length; ++i) {
                        if (indexCursors[i] == null) continue;
                        try {
                            indexCursors[i].close();
                            continue;
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                    }
                }
                throw throwable;
            }
            for (int i = 0; i < indexCursors.length; ++i) {
                if (indexCursors[i] == null) continue;
                try {
                    indexCursors[i].close();
                    continue;
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
        }
        return dataCursor;
    }

    public DataCursor join(DataCursor[] indexCursors, boolean presorted) throws DbException, IOException {
        return new DataCursor(this, indexCursors, presorted, false);
    }

    private void returnPrimaryKeyAndValue(DataThang keyThang, DataThang valueThang, Object[] retPrimaryKey, Object[] retValue) throws DbException, IOException {
        if (retPrimaryKey != null) {
            if (this.keyBinding == null) {
                throw new IllegalArgumentException("returning key requires primary key binding");
            }
            if (this.index != null) {
                throw new IllegalArgumentException("returning key requires unindexed view");
            }
            retPrimaryKey[0] = this.keyBinding.dataToObject(keyThang);
        }
        if (retValue != null) {
            retValue[0] = this.makeValue(keyThang, valueThang);
        }
    }

    int useKey(Object key, Object value, DataThang keyThang, KeyRange checkRange) throws DbException, IOException {
        if (key != null) {
            if (this.keyBinding == null) {
                throw new IllegalArgumentException("non-null key with null key binding");
            }
            this.keyBinding.objectToData(key, keyThang);
        } else {
            if (value == null) {
                throw new IllegalArgumentException("null key and null value");
            }
            if (this.index == null) {
                if (this.entityBinding == null) {
                    throw new UnsupportedOperationException("null key, null index, and null entity binding");
                }
                this.entityBinding.objectToKey(value, keyThang);
            } else {
                KeyExtractor extractor = this.index.getKeyExtractor();
                DataThang primaryKeyThang = null;
                DataThang valueThang = null;
                if (this.entityBinding != null) {
                    if (extractor.getPrimaryKeyFormat() != null) {
                        primaryKeyThang = new DataThang();
                        this.entityBinding.objectToKey(value, primaryKeyThang);
                    }
                    if (extractor.getValueFormat() != null) {
                        valueThang = new DataThang();
                        this.entityBinding.objectToValue(value, valueThang);
                    }
                } else {
                    if (extractor.getPrimaryKeyFormat() != null) {
                        throw new IllegalStateException("primary key needed by index extractor");
                    }
                    if (extractor.getValueFormat() != null) {
                        valueThang = new DataThang();
                        this.valueBinding.objectToData(value, valueThang);
                    }
                }
                extractor.extractIndexKey(primaryKeyThang, valueThang, keyThang);
            }
        }
        if (checkRange != null) {
            return checkRange.check(keyThang) ? 0 : -30990;
        }
        return 0;
    }

    public boolean canDeriveKeyFromValue() {
        if (this.index == null) {
            return this.entityBinding != null;
        }
        KeyExtractor extractor = this.index.getKeyExtractor();
        if (extractor.getPrimaryKeyFormat() != null && this.entityBinding == null) {
            return false;
        }
        return extractor.getValueFormat() == null || this.entityBinding != null || this.valueBinding != null;
    }

    /*
     * Enabled aggressive block sorting
     */
    void useValue(Object value, DataThang valueThang, DataThang checkKeyThang) throws DbException, IOException {
        if (value == null) {
            valueThang.set_data(new byte[0]);
            valueThang.set_offset(0);
            valueThang.set_size(0);
            return;
        }
        if (this.valueBinding != null) {
            this.valueBinding.objectToData(value, valueThang);
            return;
        }
        if (this.entityBinding == null) throw new IllegalArgumentException("non-null value with null value/entity binding");
        this.entityBinding.objectToValue(value, valueThang);
        if (checkKeyThang == null) return;
        DataThang thang = new DataThang();
        this.entityBinding.objectToKey(value, thang);
        if (thang.equals(checkKeyThang)) return;
        throw new IllegalArgumentException("cannot change primary key");
    }

    Object makeKey(DataThang keyThang) throws DbException, IOException {
        if (keyThang.get_size() == 0) {
            return null;
        }
        return this.keyBinding.dataToObject(keyThang);
    }

    /*
     * WARNING - void declaration
     */
    Object makeValue(DataThang primaryKeyThang, DataThang valueThang) throws DbException, IOException {
        void var3_3;
        Object value;
        if (this.valueBinding != null) {
            value = this.valueBinding.dataToObject(valueThang);
        } else if (this.entityBinding != null) {
            value = this.entityBinding.dataToObject(primaryKeyThang, valueThang);
        } else {
            throw new UnsupportedOperationException("requires valueBinding or entityBinding");
        }
        return var3_3;
    }

    KeyRange subRange(Object singleKey) throws DbException, IOException, KeyRangeException {
        return this.range.subRange(this.makeRangeKey(singleKey));
    }

    KeyRange subRange(Object beginKey, boolean beginInclusive, Object endKey, boolean endInclusive) throws DbException, IOException, KeyRangeException {
        if (beginKey == endKey && beginInclusive && endInclusive) {
            return this.subRange(beginKey);
        }
        if (!this.isOrdered()) {
            throw new UnsupportedOperationException("Cannot use key ranges on an unsorted database");
        }
        DataThang beginThang = beginKey != null ? this.makeRangeKey(beginKey) : null;
        DataThang endThang = endKey != null ? this.makeRangeKey(endKey) : null;
        return this.range.subRange(beginThang, beginInclusive, endThang, endInclusive);
    }

    private void checkBindingFormats() {
        if (this.keyBinding != null && !this.recNumAccess) {
            DataFormat keyFormat;
            DataFormat dataFormat = keyFormat = this.index != null ? this.index.keyFormat : this.store.keyFormat;
            if (!keyFormat.equals(this.keyBinding.getDataFormat())) {
                throw new IllegalArgumentException(this.db.toString() + " key binding format mismatch");
            }
        }
        if (this.valueBinding != null && !this.store.valueFormat.equals(this.valueBinding.getDataFormat())) {
            throw new IllegalArgumentException(this.store.toString() + " value binding format mismatch");
        }
        if (this.entityBinding != null) {
            if (!this.store.keyFormat.equals(this.entityBinding.getKeyFormat())) {
                throw new IllegalArgumentException(this.store.toString() + " value entity binding keyFormat mismatch");
            }
            if (!this.store.valueFormat.equals(this.entityBinding.getValueFormat())) {
                throw new IllegalArgumentException(this.store.toString() + " value entity binding valueFormat mismatch");
            }
        }
    }

    private DataThang makeRangeKey(Object key) throws DbException, IOException {
        DataThang thang = new DataThang();
        if (this.keyBinding != null) {
            this.useKey(key, null, thang, null);
        } else {
            this.useKey(null, key, thang, null);
        }
        return thang;
    }
}

