/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.script.framework.provider.javascript;

import com.sun.star.frame.XModel;
import com.sun.star.lang.XMultiComponentFactory;
import com.sun.star.reflection.InvocationTargetException;
import com.sun.star.script.framework.container.ScriptMetaData;
import com.sun.star.script.framework.log.LogUtils;
import com.sun.star.script.framework.provider.ClassLoaderFactory;
import com.sun.star.script.framework.provider.NoSuitableClassLoaderException;
import com.sun.star.script.framework.provider.ScriptContext;
import com.sun.star.script.framework.provider.javascript.ScriptEditorForJavaScript;
import com.sun.star.script.provider.ScriptExceptionRaisedException;
import com.sun.star.script.provider.ScriptFrameworkErrorException;
import com.sun.star.script.provider.XScript;
import com.sun.star.uno.RuntimeException;
import com.sun.star.uno.XComponentContext;
import java.net.MalformedURLException;
import java.net.URL;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.ImporterTopLevel;
import org.mozilla.javascript.JavaScriptException;
import org.mozilla.javascript.Scriptable;

class ScriptImpl
implements XScript {
    private ScriptMetaData metaData;
    private XComponentContext m_xContext;
    private XMultiComponentFactory m_xMultiComponentFactory;
    private XModel m_xModel;

    ScriptImpl(XComponentContext xComponentContext, ScriptMetaData scriptMetaData, XModel xModel) throws RuntimeException {
        this.metaData = scriptMetaData;
        this.m_xContext = xComponentContext;
        this.m_xModel = xModel;
        try {
            this.m_xMultiComponentFactory = this.m_xContext.getServiceManager();
        }
        catch (Exception exception) {
            LogUtils.DEBUG((String)LogUtils.getTrace((Exception)exception));
            throw new RuntimeException("Error constructing  ScriptImpl: [javascript]");
        }
        LogUtils.DEBUG((String)("ScriptImpl [javascript] script data = " + scriptMetaData));
    }

    public Object invoke(Object[] objectArray, short[][] sArray, Object[][] objectArray2) throws ScriptFrameworkErrorException, InvocationTargetException {
        ScriptEditorForJavaScript scriptEditorForJavaScript;
        Object object;
        Object object2;
        sArray[0] = new short[0];
        objectArray2[0] = new Object[0];
        ClassLoader classLoader = null;
        URL uRL = null;
        try {
            classLoader = ClassLoaderFactory.getURLClassLoader((ScriptMetaData)this.metaData);
            uRL = this.metaData.getSourceURL();
        }
        catch (MalformedURLException malformedURLException) {
            throw new ScriptFrameworkErrorException(malformedURLException.getMessage(), null, this.metaData.getLanguageName(), this.metaData.getLanguage(), 0);
        }
        catch (NoSuitableClassLoaderException noSuitableClassLoaderException) {
            throw new ScriptFrameworkErrorException(noSuitableClassLoaderException.getMessage(), null, this.metaData.getLanguageName(), this.metaData.getLanguage(), 0);
        }
        Context context = null;
        try {
            String string = uRL.toString();
            object2 = null;
            object = null;
            scriptEditorForJavaScript = ScriptEditorForJavaScript.getEditor(this.metaData.getSourceURL());
            if (scriptEditorForJavaScript != null) {
                string = scriptEditorForJavaScript.getURL();
                object2 = scriptEditorForJavaScript.execute();
                if (object2 != null && object2.getClass().getName().equals("org.mozilla.javascript.Undefined")) {
                    String string2 = Context.toString((Object)object2);
                    return string2;
                }
            }
            if (scriptEditorForJavaScript != null && scriptEditorForJavaScript.isModified()) {
                LogUtils.DEBUG((String)"GOT A MODIFIED SOURCE");
                object = scriptEditorForJavaScript.getText();
            } else {
                this.metaData.loadSource();
                object = this.metaData.getSource();
            }
            if (object == null || ((String)object).length() == 0) {
                throw new ScriptFrameworkErrorException("Failed to read source data for script", null, this.metaData.getLanguageName(), this.metaData.getLanguage(), 0);
            }
            if (classLoader != null) {
                Thread.currentThread().setContextClassLoader(classLoader);
            }
            context = Context.enter();
            ImporterTopLevel importerTopLevel = new ImporterTopLevel(context);
            Scriptable scriptable = Context.toObject((Object)ScriptContext.createContext((XModel)this.m_xModel, (XComponentContext)this.m_xContext, (XMultiComponentFactory)this.m_xMultiComponentFactory), (Scriptable)importerTopLevel);
            importerTopLevel.put("XSCRIPTCONTEXT", (Scriptable)importerTopLevel, (Object)scriptable);
            Scriptable scriptable2 = Context.toObject((Object)objectArray, (Scriptable)importerTopLevel);
            importerTopLevel.put("ARGUMENTS", (Scriptable)importerTopLevel, (Object)scriptable2);
            object2 = context.evaluateString((Scriptable)importerTopLevel, (String)object, "<stdin>", 1, null);
            Object object3 = object2 = Context.toString((Object)object2);
            return object3;
        }
        catch (JavaScriptException javaScriptException) {
            LogUtils.DEBUG((String)("Caught JavaScriptException exception for JavaScript type = " + ((Object)((Object)javaScriptException)).getClass()));
            object2 = javaScriptException.getMessage();
            object = javaScriptException.getValue();
            LogUtils.DEBUG((String)("\t message  " + (String)object2));
            LogUtils.DEBUG((String)("\t wrapped type " + object.getClass()));
            LogUtils.DEBUG((String)("\t wrapped toString  " + object.toString()));
            scriptEditorForJavaScript = new ScriptExceptionRaisedException((String)object2);
            ((ScriptExceptionRaisedException)scriptEditorForJavaScript).lineNum = -1;
            ((ScriptExceptionRaisedException)scriptEditorForJavaScript).language = "JavaScript";
            ((ScriptExceptionRaisedException)scriptEditorForJavaScript).scriptName = this.metaData.getLanguageName();
            ((ScriptExceptionRaisedException)scriptEditorForJavaScript).exceptionType = object.getClass().getName();
            ((ScriptExceptionRaisedException)scriptEditorForJavaScript).language = this.metaData.getLanguage();
            LogUtils.DEBUG((String)"ExceptionRaised exception  ");
            LogUtils.DEBUG((String)("\t message  " + scriptEditorForJavaScript.getMessage()));
            LogUtils.DEBUG((String)("\t lineNum  " + ((ScriptExceptionRaisedException)scriptEditorForJavaScript).lineNum));
            LogUtils.DEBUG((String)("\t language  " + ((ScriptExceptionRaisedException)scriptEditorForJavaScript).language));
            LogUtils.DEBUG((String)("\t scriptName  " + ((ScriptExceptionRaisedException)scriptEditorForJavaScript).scriptName));
            this.raiseEditor(((ScriptExceptionRaisedException)scriptEditorForJavaScript).lineNum);
            throw new InvocationTargetException("JavaScript uncaught exception" + this.metaData.getLanguageName(), null, (Object)scriptEditorForJavaScript);
        }
        catch (Exception exception) {
            LogUtils.DEBUG((String)("Caught Exception " + exception));
            LogUtils.DEBUG((String)"rethrowing as ScriptFramework error");
            throw new ScriptFrameworkErrorException(exception.getMessage(), null, this.metaData.getLanguageName(), this.metaData.getLanguage(), 0);
        }
        finally {
            if (context != null) {
                Context.exit();
            }
        }
    }

    private void raiseEditor(int n) {
        ScriptEditorForJavaScript scriptEditorForJavaScript = null;
        try {
            URL uRL = this.metaData.getSourceURL();
            scriptEditorForJavaScript = ScriptEditorForJavaScript.getEditor(uRL);
            if (scriptEditorForJavaScript == null) {
                scriptEditorForJavaScript = ScriptEditorForJavaScript.getEditor();
                scriptEditorForJavaScript.edit(ScriptContext.createContext((XModel)this.m_xModel, (XComponentContext)this.m_xContext, (XMultiComponentFactory)this.m_xMultiComponentFactory), this.metaData);
                scriptEditorForJavaScript = ScriptEditorForJavaScript.getEditor(uRL);
            }
            if (scriptEditorForJavaScript != null) {
                System.out.println("** Have raised IDE for JavaScript, calling indicateErrorLine for line " + n);
                scriptEditorForJavaScript.indicateErrorLine(n);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

