/*
 * Decompiled with CFR 0.152.
 */
package util;

import com.sun.star.beans.PropertyValue;
import com.sun.star.beans.PropertyVetoException;
import com.sun.star.beans.UnknownPropertyException;
import com.sun.star.beans.XPropertySet;
import com.sun.star.container.NoSuchElementException;
import com.sun.star.container.XEnumeration;
import com.sun.star.container.XEnumerationAccess;
import com.sun.star.container.XNameAccess;
import com.sun.star.frame.XStorable;
import com.sun.star.io.XDataInputStream;
import com.sun.star.io.XInputStream;
import com.sun.star.io.XTextInputStream;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.lang.WrappedTargetException;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.sdb.XCompletedConnection;
import com.sun.star.sdb.XDocumentDataSource;
import com.sun.star.sdbc.SQLException;
import com.sun.star.sdbc.XCloseable;
import com.sun.star.sdbc.XConnection;
import com.sun.star.sdbc.XResultSet;
import com.sun.star.sdbc.XResultSetUpdate;
import com.sun.star.sdbc.XRowUpdate;
import com.sun.star.sdbc.XStatement;
import com.sun.star.task.XInteractionHandler;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XInterface;
import com.sun.star.uno.XNamingService;
import com.sun.star.util.Date;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.Statement;
import util.utils;

public class DBTools {
    private XMultiServiceFactory xMSF = null;
    private XNamingService dbContext = null;
    public static final String TST_JDBC_DRIVER = "org.gjt.mm.mysql.Driver";
    public static final int TST_STRING = 1;
    public static final int TST_INT = 2;
    public static final int TST_DOUBLE = 5;
    public static final int TST_DATE = 6;
    public static final int TST_BOOLEAN = 10;
    public static final int TST_CHARACTER_STREAM = 11;
    public static final int TST_BINARY_STREAM = 12;
    public static final String TST_STRING_F = "_TEXT";
    public static final String TST_INT_F = "_INT";
    public static final String TST_DOUBLE_F = "_DOUBLE";
    public static final String TST_DATE_F = "_DATE";
    public static final String TST_BOOLEAN_F = "_BOOL";
    public static final String TST_CHARACTER_STREAM_F = "_MEMO1";
    public static final String TST_BINARY_STREAM_F = "_MEMO2";
    public static final Object[][] TST_TABLE_VALUES = new Object[][]{{"String1", new Integer(1), null, null, new Double(1.1), new Date(1, 1, 2001), null, null, null, Boolean.TRUE, null, null}, {"String2", new Integer(2), null, null, new Double(1.2), new Date(2, 1, 2001), null, null, null, Boolean.FALSE, null, null}, {null, null, null, null, null, null, null, null, null, null, null, null}};
    public static final int[] TST_STREAM_LENGTHS = new int[]{0, 0, 0};
    static /* synthetic */ Class class$com$sun$star$beans$XPropertySet;
    static /* synthetic */ Class class$com$sun$star$uno$XNamingService;
    static /* synthetic */ Class class$com$sun$star$sdb$XDocumentDataSource;
    static /* synthetic */ Class class$com$sun$star$frame$XStorable;
    static /* synthetic */ Class class$com$sun$star$task$XInteractionHandler;
    static /* synthetic */ Class class$com$sun$star$sdb$XCompletedConnection;
    static /* synthetic */ Class class$com$sun$star$container$XNameAccess;
    static /* synthetic */ Class class$com$sun$star$sdbc$XResultSetUpdate;
    static /* synthetic */ Class class$com$sun$star$sdbc$XCloseable;
    static /* synthetic */ Class class$com$sun$star$sdbc$XRowUpdate;
    static /* synthetic */ Class class$com$sun$star$container$XEnumerationAccess;

    public DBTools(XMultiServiceFactory xMultiServiceFactory) {
        this.xMSF = xMultiServiceFactory;
        try {
            Object object = xMultiServiceFactory.createInstance("com.sun.star.sdb.DatabaseContext");
            this.dbContext = (XNamingService)UnoRuntime.queryInterface(class$com$sun$star$uno$XNamingService == null ? (class$com$sun$star$uno$XNamingService = DBTools.class$("com.sun.star.uno.XNamingService")) : class$com$sun$star$uno$XNamingService, object);
        }
        catch (com.sun.star.uno.Exception exception) {
            // empty catch block
        }
    }

    public DataSourceInfo newDataSourceInfo() {
        return new DataSourceInfo();
    }

    public DataSourceInfo newDataSourceInfo(Object object) {
        return new DataSourceInfo(object);
    }

    public void registerDB(String string, Object object) throws com.sun.star.uno.Exception {
        this.dbContext.registerObject(string, object);
    }

    public void reRegisterDB(String string, Object object) throws com.sun.star.uno.Exception {
        try {
            this.revokeDB(string);
        }
        catch (com.sun.star.uno.Exception exception) {
            // empty catch block
        }
        XDocumentDataSource xDocumentDataSource = (XDocumentDataSource)UnoRuntime.queryInterface(class$com$sun$star$sdb$XDocumentDataSource == null ? (class$com$sun$star$sdb$XDocumentDataSource = DBTools.class$("com.sun.star.sdb.XDocumentDataSource")) : class$com$sun$star$sdb$XDocumentDataSource, object);
        XStorable xStorable = (XStorable)UnoRuntime.queryInterface(class$com$sun$star$frame$XStorable == null ? (class$com$sun$star$frame$XStorable = DBTools.class$("com.sun.star.frame.XStorable")) : class$com$sun$star$frame$XStorable, (Object)xDocumentDataSource.getDatabaseDocument());
        String string2 = utils.getOfficeTemp(this.xMSF) + string + ".odb";
        xStorable.storeAsURL(string2, new PropertyValue[0]);
        this.registerDB(string, object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XConnection connectToTextDB(String string, String string2, String string3) throws com.sun.star.uno.Exception {
        try {
            XConnection xConnection;
            XInterface xInterface = (XInterface)this.xMSF.createInstance("com.sun.star.sdb.DataSource");
            XPropertySet xPropertySet = (XPropertySet)UnoRuntime.queryInterface(class$com$sun$star$beans$XPropertySet == null ? (class$com$sun$star$beans$XPropertySet = DBTools.class$("com.sun.star.beans.XPropertySet")) : class$com$sun$star$beans$XPropertySet, (Object)xInterface);
            xPropertySet.setPropertyValue("URL", "sdbc:text:" + DBTools.dirToUrl(string2));
            PropertyValue propertyValue = new PropertyValue();
            propertyValue.Name = "EXT";
            propertyValue.Value = string3;
            xPropertySet.setPropertyValue("Info", new PropertyValue[]{propertyValue});
            this.dbContext.registerObject(string, xInterface);
            Object object = this.xMSF.createInstance("com.sun.star.sdb.InteractionHandler");
            XInteractionHandler xInteractionHandler = (XInteractionHandler)UnoRuntime.queryInterface(class$com$sun$star$task$XInteractionHandler == null ? (class$com$sun$star$task$XInteractionHandler = DBTools.class$("com.sun.star.task.XInteractionHandler")) : class$com$sun$star$task$XInteractionHandler, object);
            XCompletedConnection xCompletedConnection = (XCompletedConnection)UnoRuntime.queryInterface(class$com$sun$star$sdb$XCompletedConnection == null ? (class$com$sun$star$sdb$XCompletedConnection = DBTools.class$("com.sun.star.sdb.XCompletedConnection")) : class$com$sun$star$sdb$XCompletedConnection, (Object)xInterface);
            XConnection xConnection2 = xConnection = xCompletedConnection.connectWithCompletion(xInteractionHandler);
            return xConnection2;
        }
        finally {
            try {
                this.dbContext.revokeObject(string);
            }
            catch (Exception exception) {}
        }
    }

    public XConnection connectToDBase(String string, String string2) throws com.sun.star.uno.Exception {
        try {
            XInterface xInterface = (XInterface)this.xMSF.createInstance("com.sun.star.sdb.DataSource");
            XPropertySet xPropertySet = (XPropertySet)UnoRuntime.queryInterface(class$com$sun$star$beans$XPropertySet == null ? (class$com$sun$star$beans$XPropertySet = DBTools.class$("com.sun.star.beans.XPropertySet")) : class$com$sun$star$beans$XPropertySet, (Object)xInterface);
            xPropertySet.setPropertyValue("URL", "sdbc:dbase:" + DBTools.dirToUrl(string2));
            this.dbContext.registerObject(string, xInterface);
            XConnection xConnection = this.connectToSource(xInterface);
            return xConnection;
        }
        catch (com.sun.star.uno.Exception exception) {
            try {
                this.dbContext.revokeObject(string);
            }
            catch (Exception exception2) {
                // empty catch block
            }
            throw exception;
        }
    }

    public XConnection connectToSource(Object object) throws com.sun.star.uno.Exception {
        Object object2 = this.xMSF.createInstance("com.sun.star.sdb.InteractionHandler");
        XInteractionHandler xInteractionHandler = (XInteractionHandler)UnoRuntime.queryInterface(class$com$sun$star$task$XInteractionHandler == null ? (class$com$sun$star$task$XInteractionHandler = DBTools.class$("com.sun.star.task.XInteractionHandler")) : class$com$sun$star$task$XInteractionHandler, object2);
        XCompletedConnection xCompletedConnection = (XCompletedConnection)UnoRuntime.queryInterface(class$com$sun$star$sdb$XCompletedConnection == null ? (class$com$sun$star$sdb$XCompletedConnection = DBTools.class$("com.sun.star.sdb.XCompletedConnection")) : class$com$sun$star$sdb$XCompletedConnection, object);
        return xCompletedConnection.connectWithCompletion(xInteractionHandler);
    }

    public Object registerTestDB(String string) throws com.sun.star.uno.Exception {
        Object object;
        String string2 = null;
        string2 = string.endsWith("/") || string.endsWith("\\") ? DBTools.dirToUrl(string + "TestDB") : DBTools.dirToUrl(string + "/" + "TestDB");
        string2 = "sdbc:dbase:" + string2;
        String string3 = null;
        XNameAccess xNameAccess = (XNameAccess)UnoRuntime.queryInterface(class$com$sun$star$container$XNameAccess == null ? (class$com$sun$star$container$XNameAccess = DBTools.class$("com.sun.star.container.XNameAccess")) : class$com$sun$star$container$XNameAccess, (Object)this.dbContext);
        Object object2 = null;
        if (xNameAccess.hasByName("APITestDatabase")) {
            object2 = this.dbContext.getRegisteredObject("APITestDatabase");
            object = (XPropertySet)UnoRuntime.queryInterface(class$com$sun$star$beans$XPropertySet == null ? (class$com$sun$star$beans$XPropertySet = DBTools.class$("com.sun.star.beans.XPropertySet")) : class$com$sun$star$beans$XPropertySet, object2);
            string3 = (String)object.getPropertyValue("URL");
        }
        if (object2 == null || !string2.equals(string3)) {
            object = new DataSourceInfo();
            ((DataSourceInfo)object).URL = string2;
            object2 = ((DataSourceInfo)object).getDataSourceService();
            this.reRegisterDB("APITestDatabase", object2);
            object2 = this.dbContext.getRegisteredObject("APITestDatabase");
        }
        return object2;
    }

    public XConnection connectToTestDB(String string) throws com.sun.star.uno.Exception {
        return this.connectToSource(this.registerTestDB(string));
    }

    public int deleteAllRows(XConnection xConnection, String string) throws SQLException {
        XStatement xStatement = xConnection.createStatement();
        XResultSet xResultSet = xStatement.executeQuery("SELECT * FROM " + string);
        XResultSetUpdate xResultSetUpdate = (XResultSetUpdate)UnoRuntime.queryInterface(class$com$sun$star$sdbc$XResultSetUpdate == null ? (class$com$sun$star$sdbc$XResultSetUpdate = DBTools.class$("com.sun.star.sdbc.XResultSetUpdate")) : class$com$sun$star$sdbc$XResultSetUpdate, (Object)xResultSet);
        int n = 0;
        xResultSet.last();
        int n2 = xResultSet.getRow();
        xResultSet.first();
        for (int i = 0; i < n2; ++i) {
            xResultSetUpdate.deleteRow();
            xResultSet.next();
            ++n;
        }
        XCloseable xCloseable = (XCloseable)UnoRuntime.queryInterface(class$com$sun$star$sdbc$XCloseable == null ? (class$com$sun$star$sdbc$XCloseable = DBTools.class$("com.sun.star.sdbc.XCloseable")) : class$com$sun$star$sdbc$XCloseable, (Object)xResultSet);
        xCloseable.close();
        return n;
    }

    public void addRowToTestTable(XConnection xConnection, String string, Object[] objectArray, int n) throws SQLException {
        XStatement xStatement = xConnection.createStatement();
        XResultSet xResultSet = xStatement.executeQuery("SELECT * FROM " + string);
        XResultSetUpdate xResultSetUpdate = (XResultSetUpdate)UnoRuntime.queryInterface(class$com$sun$star$sdbc$XResultSetUpdate == null ? (class$com$sun$star$sdbc$XResultSetUpdate = DBTools.class$("com.sun.star.sdbc.XResultSetUpdate")) : class$com$sun$star$sdbc$XResultSetUpdate, (Object)xResultSet);
        XRowUpdate xRowUpdate = (XRowUpdate)UnoRuntime.queryInterface(class$com$sun$star$sdbc$XRowUpdate == null ? (class$com$sun$star$sdbc$XRowUpdate = DBTools.class$("com.sun.star.sdbc.XRowUpdate")) : class$com$sun$star$sdbc$XRowUpdate, (Object)xResultSet);
        xResultSetUpdate.moveToInsertRow();
        for (int i = 0; i < objectArray.length; ++i) {
            if (objectArray[i] instanceof String) {
                xRowUpdate.updateString(1, (String)objectArray[i]);
                continue;
            }
            if (objectArray[i] instanceof Integer) {
                xRowUpdate.updateInt(2, (Integer)objectArray[i]);
                continue;
            }
            if (objectArray[i] instanceof Double) {
                xRowUpdate.updateDouble(5, (Double)objectArray[i]);
                continue;
            }
            if (objectArray[i] instanceof Date) {
                xRowUpdate.updateDate(6, (Date)objectArray[i]);
                continue;
            }
            if (objectArray[i] instanceof Boolean) {
                xRowUpdate.updateBoolean(10, (Boolean)objectArray[i]);
                continue;
            }
            if (objectArray[i] instanceof XTextInputStream) {
                xRowUpdate.updateCharacterStream(11, (XInputStream)objectArray[i], n);
                continue;
            }
            if (!(objectArray[i] instanceof XDataInputStream)) continue;
            xRowUpdate.updateBinaryStream(12, (XInputStream)objectArray[i], n);
        }
        xResultSetUpdate.insertRow();
        XCloseable xCloseable = (XCloseable)UnoRuntime.queryInterface(class$com$sun$star$sdbc$XCloseable == null ? (class$com$sun$star$sdbc$XCloseable = DBTools.class$("com.sun.star.sdbc.XCloseable")) : class$com$sun$star$sdbc$XCloseable, (Object)xResultSet);
        xCloseable.close();
    }

    public void initializeTestTable(XConnection xConnection, String string) throws SQLException {
        this.deleteAllRows(xConnection, string);
        for (int i = 0; i < TST_TABLE_VALUES.length; ++i) {
            this.addRowToTestTable(xConnection, string, TST_TABLE_VALUES[i], TST_STREAM_LENGTHS[i]);
        }
    }

    public void printRegisteredDatabasesInfo(PrintWriter printWriter) {
        XEnumerationAccess xEnumerationAccess = (XEnumerationAccess)UnoRuntime.queryInterface(class$com$sun$star$container$XEnumerationAccess == null ? (class$com$sun$star$container$XEnumerationAccess = DBTools.class$("com.sun.star.container.XEnumerationAccess")) : class$com$sun$star$container$XEnumerationAccess, (Object)this.dbContext);
        XEnumeration xEnumeration = xEnumerationAccess.createEnumeration();
        printWriter.println("DatabaseContext registered DataSource's :");
        while (xEnumeration.hasMoreElements()) {
            try {
                DataSourceInfo dataSourceInfo = new DataSourceInfo(xEnumeration.nextElement());
                dataSourceInfo.printInfo(printWriter);
            }
            catch (NoSuchElementException noSuchElementException) {
            }
            catch (WrappedTargetException wrappedTargetException) {}
        }
    }

    public static String dirToUrl(String string) {
        String string2 = null;
        if (string.startsWith("file:/")) {
            string2 = string;
        } else {
            string2 = string.replace(':', '|').replace('\\', '/');
            string2 = string.startsWith("\\\\") ? "file:" + string2 : "file:///" + string2;
        }
        return string2;
    }

    public void revokeDB(String string) throws com.sun.star.uno.Exception {
        this.dbContext.revokeObject(string);
    }

    public void initTestTableUsingJDBC(String string, DataSourceInfo dataSourceInfo) throws java.sql.SQLException, ClassNotFoundException {
        if (dataSourceInfo.Info[0].Name.equals("JavaDriverClass")) {
            Class.forName((String)dataSourceInfo.Info[0].Value);
        } else {
            Class.forName(TST_JDBC_DRIVER);
        }
        Connection connection = null;
        connection = DriverManager.getConnection(dataSourceInfo.URL, dataSourceInfo.User, dataSourceInfo.Password);
        Statement statement = connection.createStatement();
        this.dropMySQLTable(statement, string);
        this.createMySQLTable(statement, string);
        this.insertContentMySQLTable(statement, string);
    }

    protected void insertContentMySQLTable(Statement statement, String string) throws java.sql.SQLException {
        for (int i = 0; i < TST_TABLE_VALUES.length; ++i) {
            String string2 = "insert into " + string + " values (";
            for (int j = 0; j < TST_TABLE_VALUES[i].length; ++j) {
                Object object;
                if (j > 0) {
                    string2 = string2 + ", ";
                }
                if ((object = TST_TABLE_VALUES[i][j]) instanceof String || object instanceof Date) {
                    string2 = string2 + "'";
                }
                if (object instanceof Date) {
                    Date date = (Date)object;
                    string2 = string2 + date.Year + "-" + date.Month + "-" + date.Day;
                } else {
                    string2 = object instanceof Boolean ? string2 + ((Boolean)object != false ? "1" : "0") : string2 + object;
                }
                if (!(object instanceof String) && !(object instanceof Date)) continue;
                string2 = string2 + "'";
            }
            string2 = string2 + ")";
            statement.executeUpdate(string2);
        }
    }

    protected void createMySQLTable(Statement statement, String string) throws java.sql.SQLException {
        int n = 0;
        String string2 = "create table " + string + " (";
        block9: for (int i = 0; i < TST_TABLE_VALUES[0].length; ++i) {
            if (i > 0) {
                string2 = string2 + ",";
            }
            switch (i + 1) {
                case 12: {
                    string2 = string2 + "_MEMO2 BLOB";
                    continue block9;
                }
                case 10: {
                    string2 = string2 + "_BOOL TINYINT";
                    continue block9;
                }
                case 11: {
                    string2 = string2 + "_MEMO1 TEXT";
                    continue block9;
                }
                case 6: {
                    string2 = string2 + "_DATE DATE";
                    continue block9;
                }
                case 5: {
                    string2 = string2 + "_DOUBLE DOUBLE";
                    continue block9;
                }
                case 2: {
                    string2 = string2 + "_INT INT";
                    continue block9;
                }
                case 1: {
                    string2 = string2 + "_TEXT TEXT";
                    continue block9;
                }
                default: {
                    string2 = string2 + "Column" + n++ + " INT";
                    if (n != 1) continue block9;
                    string2 = string2 + " NOT NULL AUTO_INCREMENT";
                }
            }
        }
        string2 = string2 + ", PRIMARY KEY (Column0)";
        string2 = string2 + ")";
        statement.execute(string2);
    }

    protected void dropMySQLTable(Statement statement, String string) throws java.sql.SQLException {
        statement.executeUpdate("drop table if exists " + string);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public class DataSourceInfo {
        public String Name = null;
        public String URL = null;
        public PropertyValue[] Info = null;
        public String User = null;
        public String Password = null;
        public Boolean IsPasswordRequired = null;
        public Boolean SuppressVersionColumns = null;
        public Boolean IsReadOnly = null;
        public String[] TableFilter = null;
        public String[] TableTypeFilter = null;

        public DataSourceInfo() {
        }

        public DataSourceInfo(Object object) {
            XPropertySet xPropertySet = (XPropertySet)UnoRuntime.queryInterface(class$com$sun$star$beans$XPropertySet == null ? (class$com$sun$star$beans$XPropertySet = DBTools.class$("com.sun.star.beans.XPropertySet")) : class$com$sun$star$beans$XPropertySet, object);
            try {
                this.Name = (String)xPropertySet.getPropertyValue("Name");
                this.URL = (String)xPropertySet.getPropertyValue("URL");
                this.Info = (PropertyValue[])xPropertySet.getPropertyValue("Info");
                this.User = (String)xPropertySet.getPropertyValue("User");
                this.Password = (String)xPropertySet.getPropertyValue("Password");
                this.IsPasswordRequired = (Boolean)xPropertySet.getPropertyValue("IsPasswordRequired");
                this.SuppressVersionColumns = (Boolean)xPropertySet.getPropertyValue("SuppressVersionColumns");
                this.IsReadOnly = (Boolean)xPropertySet.getPropertyValue("IsReadOnly");
                this.TableFilter = (String[])xPropertySet.getPropertyValue("TableFilter");
                this.TableTypeFilter = (String[])xPropertySet.getPropertyValue("TableTypeFilter");
            }
            catch (UnknownPropertyException unknownPropertyException) {
                System.err.println("util.DBTools.DataSourceInfo: Error retrieving property");
                unknownPropertyException.printStackTrace(System.err);
            }
            catch (WrappedTargetException wrappedTargetException) {
                System.err.println("util.DBTools.DataSourceInfo: Error retrieving property");
                wrappedTargetException.printStackTrace(System.err);
            }
        }

        public void printInfo(PrintWriter printWriter) {
            int n;
            printWriter.println("Name = '" + this.Name + "'");
            printWriter.println("  URL = '" + this.URL + "'");
            printWriter.print("  Info = ");
            if (this.Info == null) {
                printWriter.println("null");
            } else {
                printWriter.print("{");
                for (n = 0; n < this.Info.length; ++n) {
                    printWriter.print(this.Info[n].Name + " = '" + this.Info[n].Value + "'");
                    if (n + 1 >= this.Info.length) continue;
                    printWriter.print("; ");
                }
                printWriter.println("}");
            }
            printWriter.println("  User = '" + this.User + "'");
            printWriter.println("  Password = '" + this.Password + "'");
            printWriter.println("  IsPasswordRequired = '" + this.IsPasswordRequired + "'");
            printWriter.println("  SuppressVersionColumns = '" + this.SuppressVersionColumns + "'");
            printWriter.println("  IsReadOnly = '" + this.IsReadOnly + "'");
            printWriter.print("  TableFilter = ");
            if (this.TableFilter == null) {
                printWriter.println("null");
            } else {
                printWriter.print("{");
                for (n = 0; n < this.TableFilter.length; ++n) {
                    printWriter.print("'" + this.TableFilter[n] + "'");
                    if (n + 1 >= this.TableFilter.length) continue;
                    printWriter.print("; ");
                }
                printWriter.println("}");
            }
            printWriter.print("  TableTypeFilter = ");
            if (this.TableTypeFilter == null) {
                printWriter.println("null");
            } else {
                printWriter.print("{");
                for (n = 0; n < this.TableTypeFilter.length; ++n) {
                    printWriter.print("'" + this.TableTypeFilter[n] + "'");
                    if (n + 1 >= this.TableTypeFilter.length) continue;
                    printWriter.print("; ");
                }
                printWriter.println("}");
            }
        }

        public Object getDataSourceService() {
            Object object = null;
            try {
                object = DBTools.this.xMSF.createInstance("com.sun.star.sdb.DataSource");
            }
            catch (com.sun.star.uno.Exception exception) {
                // empty catch block
            }
            if (object == null) {
                return null;
            }
            XPropertySet xPropertySet = (XPropertySet)UnoRuntime.queryInterface(class$com$sun$star$beans$XPropertySet == null ? (class$com$sun$star$beans$XPropertySet = DBTools.class$("com.sun.star.beans.XPropertySet")) : class$com$sun$star$beans$XPropertySet, object);
            try {
                if (this.Name != null) {
                    xPropertySet.setPropertyValue("Name", this.Name);
                }
                if (this.URL != null) {
                    xPropertySet.setPropertyValue("URL", this.URL);
                }
                if (this.Info != null) {
                    xPropertySet.setPropertyValue("Info", this.Info);
                }
                if (this.User != null) {
                    xPropertySet.setPropertyValue("User", this.User);
                }
                if (this.Password != null) {
                    xPropertySet.setPropertyValue("Password", this.Password);
                }
                if (this.IsPasswordRequired != null) {
                    xPropertySet.setPropertyValue("IsPasswordRequired", this.IsPasswordRequired);
                }
                if (this.SuppressVersionColumns != null) {
                    xPropertySet.setPropertyValue("SuppressVersionColumns", this.SuppressVersionColumns);
                }
                if (this.IsReadOnly != null) {
                    xPropertySet.setPropertyValue("IsReadOnly", this.IsReadOnly);
                }
                if (this.TableFilter != null) {
                    xPropertySet.setPropertyValue("TableFilter", this.TableFilter);
                }
                if (this.TableTypeFilter != null) {
                    xPropertySet.setPropertyValue("TableTypeFilter", this.TableTypeFilter);
                }
            }
            catch (UnknownPropertyException unknownPropertyException) {
                return null;
            }
            catch (PropertyVetoException propertyVetoException) {
                return null;
            }
            catch (WrappedTargetException wrappedTargetException) {
                return null;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return null;
            }
            return object;
        }
    }
}

