/*
 * Decompiled with CFR 0.152.
 */
package stats;

import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.DecimalFormat;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Iterator;
import share.DescEntry;
import share.LogWriter;
import share.Watcher;

public class FileLogWriter
extends PrintWriter
implements LogWriter {
    HashMap mFileWriters = null;
    boolean logging = false;
    DescEntry entry = null;
    Watcher ow = null;

    public FileLogWriter() {
        super(System.out);
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        DecimalFormat decimalFormat = new DecimalFormat("00");
        super.println("LOG> Log started " + decimalFormat.format(gregorianCalendar.get(5)) + "." + decimalFormat.format(gregorianCalendar.get(2)) + "." + decimalFormat.format(gregorianCalendar.get(1)) + " - " + decimalFormat.format(gregorianCalendar.get(11)) + ":" + decimalFormat.format(gregorianCalendar.get(12)) + ":" + decimalFormat.format(gregorianCalendar.get(13)));
        super.flush();
    }

    public boolean initialize(DescEntry descEntry, boolean bl) {
        this.logging = bl;
        this.entry = descEntry;
        return true;
    }

    public void addFileLog(String string) {
        try {
            if (this.mFileWriters == null) {
                this.mFileWriters = new HashMap();
            }
            this.mFileWriters.put(string, new FileWriter(string));
        }
        catch (IOException iOException) {
            iOException.printStackTrace(this);
        }
    }

    public void removeFileLog(String string) {
        if (string != null) {
            this.mFileWriters.remove(string);
        }
    }

    public void println(String string) {
        this.ow = (Watcher)this.entry.UserDefinedParams.get("Watcher");
        if (this.ow != null) {
            this.ow.ping();
        }
        if (this.logging) {
            super.println("LOG> " + string);
            super.flush();
            if (this.mFileWriters != null && this.mFileWriters.size() > 0) {
                try {
                    FileWriter fileWriter = null;
                    Iterator iterator = this.mFileWriters.values().iterator();
                    while (iterator.hasNext()) {
                        fileWriter = (FileWriter)iterator.next();
                        fileWriter.write("LOG> " + string + "\n");
                        fileWriter.flush();
                    }
                }
                catch (IOException iOException) {
                    iOException.printStackTrace(this);
                }
            }
        }
    }

    public boolean summary(DescEntry descEntry) {
        String string = "***** State for " + descEntry.longName + " ******";
        System.out.println(string);
        if (descEntry.hasErrorMsg) {
            System.out.println(descEntry.ErrorMsg);
            System.out.println("Whole " + descEntry.EntryType + ": " + descEntry.State);
        } else {
            System.out.println("Whole " + descEntry.EntryType + ": " + descEntry.State);
        }
        for (int i = 0; i < string.length(); ++i) {
            System.out.print("*");
        }
        System.out.println("");
        return true;
    }

    public Object getWatcher() {
        return this.ow;
    }

    public void setWatcher(Object object) {
        this.entry.UserDefinedParams.put("Watcher", (Watcher)object);
    }
}

