/*
 * Decompiled with CFR 0.152.
 */
package stats;

import java.util.Hashtable;
import share.DescEntry;
import share.LogWriter;
import stats.SQLExecution;

public abstract class DataBaseOutProducer
implements LogWriter {
    protected Hashtable mSqlInput = new Hashtable();
    protected Hashtable mSqlOutput = null;
    protected String[] mWriteableEntryTypes = null;
    protected SQLExecution mSqlExec;
    protected boolean m_bDebug = false;

    public DataBaseOutProducer(Hashtable hashtable) {
        this.mSqlInput.putAll(hashtable);
        Object v = hashtable.get("DebugIsActive");
        String string = null;
        string = v instanceof String ? (String)v : v.toString();
        if (string != null && (string.equalsIgnoreCase("true") || string.equalsIgnoreCase("yes"))) {
            this.m_bDebug = true;
        }
        this.setWriteableEntryTypes(new String[]{"method"});
    }

    public boolean initialize(DescEntry descEntry, boolean bl) {
        String string;
        if (descEntry.UserDefinedParams != null) {
            this.mSqlInput.putAll(descEntry.UserDefinedParams);
        }
        if ((string = (String)this.mSqlInput.get("JDBC")) == null) {
            string = "org.gjt.mm.mysql.Driver";
        }
        String string2 = (String)this.mSqlInput.get("DataBaseURL");
        String string3 = (String)this.mSqlInput.get("User");
        String string4 = (String)this.mSqlInput.get("Password");
        if (string3 == null) {
            string3 = (String)this.mSqlInput.get("OperatingSystem");
        }
        if (string4 == null) {
            string4 = string3;
        }
        this.mSqlExec = new SQLExecution(string, string2, string3, string4, this.m_bDebug);
        this.mSqlExec.openConnection();
        this.prepareDataBase(descEntry.Logger);
        return true;
    }

    public boolean summary(DescEntry descEntry) {
        this.mSqlExec.openConnection();
        this.findTypeInEntryTree(descEntry, descEntry.Logger);
        this.mSqlExec.closeConnection();
        return true;
    }

    protected boolean findTypeInEntryTree(DescEntry descEntry, LogWriter logWriter) {
        boolean bl = true;
        if (this.isWriteableEntryType(descEntry)) {
            bl &= this.insertEntry(descEntry, logWriter);
        }
        if (descEntry.SubEntryCount > 0) {
            for (int i = 0; i < descEntry.SubEntryCount; ++i) {
                bl &= this.findTypeInEntryTree(descEntry.SubEntries[i], logWriter);
            }
        }
        return bl;
    }

    protected boolean insertEntry(DescEntry descEntry, LogWriter logWriter) {
        Hashtable hashtable = new Hashtable();
        hashtable.putAll(this.mSqlInput);
        this.mSqlInput.put("EntryLongName", descEntry.longName);
        this.mSqlInput.put("EntryName", descEntry.entryName);
        this.mSqlInput.put("EntryState", descEntry.State);
        this.mSqlInput.put("EntryType", descEntry.EntryType);
        boolean bl = this.insertEntry(logWriter);
        this.mSqlInput = hashtable;
        return bl;
    }

    public void setWriteableEntryTypes(String[] stringArray) {
        this.mWriteableEntryTypes = stringArray;
    }

    protected boolean isWriteableEntryType(DescEntry descEntry) {
        boolean bl = false;
        for (int i = 0; i < this.mWriteableEntryTypes.length; ++i) {
            if (!descEntry.EntryType.equals(this.mWriteableEntryTypes[i])) continue;
            bl = true;
            break;
        }
        return bl;
    }

    protected boolean executeSQLCommand(String string, boolean bl) {
        return this.mSqlExec.executeSQLCommand(string, this.mSqlInput, this.mSqlOutput, bl);
    }

    protected boolean executeSQLCommand(String string) {
        return this.mSqlExec.executeSQLCommand(string, this.mSqlInput, this.mSqlOutput);
    }

    public void println(String string) {
    }

    protected abstract boolean prepareDataBase(LogWriter var1);

    protected abstract boolean insertEntry(LogWriter var1);
}

