/*
 * Decompiled with CFR 0.152.
 */
package convwatch;

import com.sun.star.lang.XMultiServiceFactory;
import convwatch.ConvWatchCancelException;
import convwatch.ConvWatchException;
import convwatch.DirectoryHelper;
import convwatch.EnhancedComplexTestCase;
import convwatch.FileHelper;
import convwatch.GraphicalTestArguments;
import convwatch.MSOfficePrint;
import convwatch.OfficePrint;
import helper.OfficeProvider;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.ArrayList;

public class DocumentConverter
extends EnhancedComplexTestCase {
    private String m_sInputPath = "";
    private String m_sReferencePath = "";
    private boolean m_bIncludeSubdirectories = true;

    public String getTestObjectName() {
        return "DocumentConverter runner";
    }

    public String[] getTestMethodNames() {
        return new String[]{"convert"};
    }

    public void before() {
    }

    public void after() {
    }

    void initMember() {
        String string = (String)param.get("DOC_COMPARATOR_INPUT_PATH");
        boolean bl = false;
        String string2 = "";
        if (string == null || string.length() == 0) {
            log.println("Please set input path (path to documents) DOC_COMPARATOR_INPUT_PATH=path.");
            bl = true;
        } else {
            log.println("found DOC_COMPARATOR_INPUT_PATH " + string);
            this.m_sInputPath = string;
        }
        String string3 = (String)param.get("DOC_COMPARATOR_REFERENCE_PATH");
        if (string3 == null || string3.length() == 0) {
            log.println("Please set output path (path to a directory, where the references should stay) DOC_COMPARATOR_REFERENCE_PATH=path.");
            bl = true;
        } else {
            log.println("found DOC_COMPARATOR_REFERENCE_PATH " + string3);
            this.m_sReferencePath = string3;
        }
        if (bl) {
            this.assure("Must quit, Parameter problems.", false);
        }
        if (this.m_sInputPath.startsWith("file:") || this.m_sReferencePath.startsWith("file:")) {
            this.assure("We can't handle file: URL right, use system path instead.", false);
        }
    }

    protected Object[] mustInstalledSoftware() {
        ArrayList arrayList = new ArrayList();
        return arrayList.toArray();
    }

    public void convert() {
        this.checkEnvironment(this.mustInstalledSoftware());
        GraphicalTestArguments graphicalTestArguments = this.getGraphicalTestArguments();
        if (graphicalTestArguments == null) {
            this.assure("Must quit", false);
        }
        this.initMember();
        File file = new File(this.m_sInputPath);
        if (file.isDirectory()) {
            String string = System.getProperty("file.separator");
            String string2 = file.getAbsolutePath();
            FileFilter fileFilter = graphicalTestArguments.getFileFilter();
            Object[] objectArray = DirectoryHelper.traverse(this.m_sInputPath, graphicalTestArguments.getFileFilter(), graphicalTestArguments.includeSubDirectories());
            for (int i = 0; i < objectArray.length; ++i) {
                String string3 = (String)objectArray[i];
                String string4 = this.m_sReferencePath + string + FileHelper.removeFirstDirectorysAndBasenameFrom(string3, this.m_sInputPath);
                log.println("- next file is: ------------------------------");
                log.println(string3);
                this.runGDC(string3, string4);
            }
        } else {
            this.runGDC(this.m_sInputPath, this.m_sReferencePath);
        }
    }

    void runGDC(String string, String string2) {
        Object object;
        GraphicalTestArguments graphicalTestArguments = this.getGraphicalTestArguments();
        OfficeProvider officeProvider = null;
        if (graphicalTestArguments.restartOffice()) {
            officeProvider = new OfficeProvider();
            object = (XMultiServiceFactory)officeProvider.getManager(param);
            param.put("ServiceFactory", object);
        }
        if (((GraphicalTestArguments)(object = this.getGraphicalTestArguments())).getOfficeProgram().toLowerCase().equals("msoffice")) {
            System.out.println("USE MSOFFICE AS EXPORT FORMAT.");
            MSOfficePrint mSOfficePrint = new MSOfficePrint();
            try {
                String string3 = FileHelper.getBasename(string);
                String string4 = System.getProperty("file.separator");
                FileHelper.makeDirectories("", string2);
                String string5 = string2;
                string5 = string5.endsWith(string4) ? string5 + string3 : string5 + string4 + string3;
                mSOfficePrint.storeToFileWithMSOffice((GraphicalTestArguments)object, string, string5);
            }
            catch (ConvWatchCancelException convWatchCancelException) {
                System.out.println(convWatchCancelException.getMessage());
            }
            catch (IOException iOException) {
                System.out.println(iOException.getMessage());
            }
        } else {
            try {
                OfficePrint.convertDocument(string, string2, (GraphicalTestArguments)object);
            }
            catch (ConvWatchCancelException convWatchCancelException) {
                this.assure(convWatchCancelException.getMessage(), false);
            }
            catch (ConvWatchException convWatchException) {
                this.assure(convWatchException.getMessage(), false);
            }
        }
        if (((GraphicalTestArguments)object).restartOffice()) {
            officeProvider.closeExistingOffice(param, true);
        }
    }
}

