/*************************************************************************
 *
 *  $RCSfile: protocol.hxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: hr $ $Date: 2003/03/27 11:28:08 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _PROTOCOL_HXX
#define _PROTOCOL_HXX

#ifndef _ERRCODE_HXX //autogen
#include <tools/errcode.hxx>
#endif
#ifndef _SOLAR_H
#include <tools/solar.h>
#endif
#ifndef _TOOLS_STRING_HXX
#include <tools/string.hxx>
#endif

/*************************************************************************
*************************************************************************/
class  SvEmbeddedObject;
class  SvInPlaceObject;
class  SvEmbeddedClient;
class  SvInPlaceClient;
class  SoDll;
class  ImplSvEditObjectProtocol;
class  String;

class SvEditObjectProtocol
{
friend class SoDll;
	ImplSvEditObjectProtocol * pImp;
	static void         Imp_DeleteDefault();
	BOOL                Release();
public:
	SvEditObjectProtocol();
	SvEditObjectProtocol( SvEmbeddedObject *, SvEmbeddedClient * );
	SvEditObjectProtocol( const SvEditObjectProtocol & );
	SvEditObjectProtocol & operator = ( const SvEditObjectProtocol & );
	~SvEditObjectProtocol();

	// Objekte
	SvEmbeddedObject * GetObj() const;
	SvInPlaceObject *  GetIPObj() const;
	SvEmbeddedClient * GetClient() const;
	SvInPlaceClient *  GetIPClient() const;

	// Zustandsabfragen
	BOOL IsConnect() const;
	BOOL IsOpen() const;
	BOOL IsEmbed() const;
	BOOL IsPlugIn() const;
	BOOL IsInPlaceActive() const;
	BOOL IsUIActive() const;
	BOOL IsTopWinActive() const;
	BOOL IsDocWinActive() const;
	BOOL IsInClosed() const;

	// Protokolle
	ErrCode EmbedProtocol();
	ErrCode	PlugInProtocol();
	ErrCode	IPProtocol();
	ErrCode UIProtocol();

	// Welche Protokolle werden unterstuetzt
	BOOL CanEmbedProtocol() const;
	BOOL CanPlugInProtocol() const;
	BOOL CanInPlaceProtocol() const;
	BOOL CanUIProtocol() const;

	// Protokoll zurueckfahren
	BOOL Reset();
	BOOL Reset2Connect();
	BOOL Reset2Open();
	BOOL Reset2Embed();
	BOOL Reset2PlugIn();
	BOOL Reset2InPlaceActive();
	BOOL Reset2UIActive();

	// Einzelschritte der Protokolle
	void Connected( BOOL bOpen );
	void Opened( BOOL bOpen );
	void Embedded( BOOL bEmbed );
	void PlugIn( BOOL bPlugIn );
	void InPlaceActivate( BOOL bActivate );
	void UIActivate( BOOL bActivate );
	void TopWinActivate( BOOL bActivate );
	void DocWinActivate( BOOL bActivate );
	void SetInClosed( BOOL bInClosed );
	void DocNameChanged( const String & rName );
};

#endif // _PROTOCOL_HXX
