/*************************************************************************
 *
 *  $RCSfile: lstner.hxx,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: hr $ $Date: 2000/09/18 16:58:52 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
#ifndef _SFXLSTNER_HXX
#define _SFXLSTNER_HXX

#ifndef _RTTI_HXX
#include <tools/rtti.hxx>
#endif
#include <svtools/svarray.hxx>

class SfxBroadcaster;
class SfxHint;

#ifndef _SFX_LSTNER_CXX
typedef SvPtrarr SfxBroadcasterArr_Impl;
#endif

#if SUPD<=310
#define SFX_NOTIFY( rBC, rBCT, rHint, rHintT ) \
		Notify( rBC, rBCT, rHint, rHintT )
#else
#define SFX_NOTIFY( rBC, rBCT, rHint, rHintT ) \
		Notify( rBC, rHint )
#endif

//-------------------------------------------------------------------------

class SfxListener
{
	SfxBroadcasterArr_Impl aBCs;

private:
	const SfxListener&	operator=(const SfxListener &); // n.i., ist verboten

public:
	TYPEINFO();

						SfxListener();
						SfxListener( const SfxListener &rCopy );
	virtual 			~SfxListener();

	BOOL				StartListening( SfxBroadcaster& rBroadcaster, BOOL bPreventDups = FALSE );
	BOOL				EndListening( SfxBroadcaster& rBroadcaster, BOOL bAllDups = FALSE );
	void				EndListening( USHORT nNo );
	void				EndListeningAll();
	BOOL				IsListening( SfxBroadcaster& rBroadcaster ) const;

	USHORT				GetBroadcasterCount() const
						{ return aBCs.Count(); }
	SfxBroadcaster* 	GetBroadcasterJOE( USHORT nNo ) const
						{ return (SfxBroadcaster*) aBCs.GetObject(nNo); }

	virtual void		Notify( SfxBroadcaster& rBC, const SfxHint& rHint );

#ifndef _NOTIFY_HXX
	void RemoveBroadcaster_Impl( SfxBroadcaster& rBC );
#endif
};

#endif

