package com.sun.star.registry;

public interface XRegistryKey extends com.sun.star.uno.XInterface
{
    // Attributes
    public String getKeyName();

    // Methods
    public boolean isReadOnly(  ) throws InvalidRegistryException;
    public boolean isValid(  );
    public RegistryKeyType getKeyType( /*IN*/String rKeyName ) throws InvalidRegistryException;
    public RegistryValueType getValueType(  ) throws InvalidRegistryException;
    public int getLongValue(  ) throws InvalidRegistryException, InvalidValueException;
    public void setLongValue( /*IN*/int value ) throws InvalidRegistryException;
    public int[] getLongListValue(  ) throws InvalidRegistryException, InvalidValueException;
    public void setLongListValue( /*IN*/int[] seqValue ) throws InvalidRegistryException;
    public String getAsciiValue(  ) throws InvalidRegistryException, InvalidValueException;
    public void setAsciiValue( /*IN*/String value ) throws InvalidRegistryException;
    public String[] getAsciiListValue(  ) throws InvalidRegistryException, InvalidValueException;
    public void setAsciiListValue( /*IN*/String[] seqValue ) throws InvalidRegistryException;
    public String getStringValue(  ) throws InvalidRegistryException, InvalidValueException;
    public void setStringValue( /*IN*/String value ) throws InvalidRegistryException;
    public String[] getStringListValue(  ) throws InvalidRegistryException, InvalidValueException;
    public void setStringListValue( /*IN*/String[] seqValue ) throws InvalidRegistryException;
    public byte[] getBinaryValue(  ) throws InvalidRegistryException, InvalidValueException;
    public void setBinaryValue( /*IN*/byte[] value ) throws InvalidRegistryException;
    public XRegistryKey openKey( /*IN*/String aKeyName ) throws InvalidRegistryException;
    public XRegistryKey createKey( /*IN*/String aKeyName ) throws InvalidRegistryException;
    public void closeKey(  ) throws InvalidRegistryException;
    public void deleteKey( /*IN*/String rKeyName ) throws InvalidRegistryException;
    public XRegistryKey[] openKeys(  ) throws InvalidRegistryException;
    public String[] getKeyNames(  ) throws InvalidRegistryException;
    public boolean createLink( /*IN*/String aLinkName, /*IN*/String aLinkTarget ) throws InvalidRegistryException;
    public void deleteLink( /*IN*/String rLinkName ) throws InvalidRegistryException;
    public String getLinkTarget( /*IN*/String rLinkName ) throws InvalidRegistryException;
    public String getResolvedName( /*IN*/String aKeyName ) throws InvalidRegistryException;

    // static Member
    public static final com.sun.star.lib.uno.typeinfo.TypeInfo UNOTYPEINFO[] = { 
        new com.sun.star.lib.uno.typeinfo.AttributeTypeInfo( "KeyName", 0, com.sun.star.lib.uno.typeinfo.TypeInfo.READONLY ),
        new com.sun.star.lib.uno.typeinfo.MethodTypeInfo( "isReadOnly", 1, 0 ),
        new com.sun.star.lib.uno.typeinfo.MethodTypeInfo( "isValid", 2, 0 ),
        new com.sun.star.lib.uno.typeinfo.MethodTypeInfo( "getKeyType", 3, 0 ),
        new com.sun.star.lib.uno.typeinfo.MethodTypeInfo( "getValueType", 4, 0 ),
        new com.sun.star.lib.uno.typeinfo.MethodTypeInfo( "getLongValue", 5, 0 ),
        new com.sun.star.lib.uno.typeinfo.MethodTypeInfo( "setLongValue", 6, 0 ),
        new com.sun.star.lib.uno.typeinfo.MethodTypeInfo( "getLongListValue", 7, 0 ),
        new com.sun.star.lib.uno.typeinfo.MethodTypeInfo( "setLongListValue", 8, 0 ),
        new com.sun.star.lib.uno.typeinfo.MethodTypeInfo( "getAsciiValue", 9, 0 ),
        new com.sun.star.lib.uno.typeinfo.MethodTypeInfo( "setAsciiValue", 10, 0 ),
        new com.sun.star.lib.uno.typeinfo.MethodTypeInfo( "getAsciiListValue", 11, 0 ),
        new com.sun.star.lib.uno.typeinfo.MethodTypeInfo( "setAsciiListValue", 12, 0 ),
        new com.sun.star.lib.uno.typeinfo.MethodTypeInfo( "getStringValue", 13, 0 ),
        new com.sun.star.lib.uno.typeinfo.MethodTypeInfo( "setStringValue", 14, 0 ),
        new com.sun.star.lib.uno.typeinfo.MethodTypeInfo( "getStringListValue", 15, 0 ),
        new com.sun.star.lib.uno.typeinfo.MethodTypeInfo( "setStringListValue", 16, 0 ),
        new com.sun.star.lib.uno.typeinfo.MethodTypeInfo( "getBinaryValue", 17, 0 ),
        new com.sun.star.lib.uno.typeinfo.MethodTypeInfo( "setBinaryValue", 18, 0 ),
        new com.sun.star.lib.uno.typeinfo.MethodTypeInfo( "openKey", 19, com.sun.star.lib.uno.typeinfo.TypeInfo.INTERFACE ),
        new com.sun.star.lib.uno.typeinfo.MethodTypeInfo( "createKey", 20, com.sun.star.lib.uno.typeinfo.TypeInfo.INTERFACE ),
        new com.sun.star.lib.uno.typeinfo.MethodTypeInfo( "closeKey", 21, 0 ),
        new com.sun.star.lib.uno.typeinfo.MethodTypeInfo( "deleteKey", 22, 0 ),
        new com.sun.star.lib.uno.typeinfo.MethodTypeInfo( "openKeys", 23, com.sun.star.lib.uno.typeinfo.TypeInfo.INTERFACE ),
        new com.sun.star.lib.uno.typeinfo.MethodTypeInfo( "getKeyNames", 24, 0 ),
        new com.sun.star.lib.uno.typeinfo.MethodTypeInfo( "createLink", 25, 0 ),
        new com.sun.star.lib.uno.typeinfo.MethodTypeInfo( "deleteLink", 26, 0 ),
        new com.sun.star.lib.uno.typeinfo.MethodTypeInfo( "getLinkTarget", 27, 0 ),
        new com.sun.star.lib.uno.typeinfo.MethodTypeInfo( "getResolvedName", 28, 0 )
     };
}

