/*************************************************************************
 *
 *  $RCSfile: IQueryInterface.java,v $
 *
 *  $Revision: 1.4 $
 *
 *  last change: $Author: jbu $ $Date: 2002/01/18 14:06:54 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

package com.sun.star.uno;


/**
 * This is the delegator interface for objects implementing
 * interfaces for an underlying object. Call are delegated
 * through the <code>UnoRuntime</code> to this interface.
 *
 * <p>
 * Implement this interface, in case you want to customize
 * the behaviour of queryInterface.
 * <p>
 * @version 	$Revision: 1.4 $ $ $Date: 2002/01/18 14:06:54 $
 * @see         com.sun.star.uno.UnoRuntime
 * @see         com.sun.star.uno.IQueryInterface
 * @see         com.sun.star.uno.IBridge
 * @since       UDK1.0
 */
public interface IQueryInterface {
	/**
	 * Returns an object implementing the desired interface.
	 *<p>
	 * @return     the desired interface if available, otherwise null.
	 * @param      type the type of the desired interface.
	 * @see        com.sun.star.uno.UnoRuntime
	 */
	Object queryInterface(Type type);

	/** 
	 * Tests if the given object is an interface of the same underlying object.
	 * <p>
	 * @return     true, if the underlying object is the same, otherwise false.
	 * @param      object an object representing an interface.
	 */
	boolean isSame(Object object);

	/**
	 * returns the object identifier (oid) of the underlying object.
	 * <p>
	 * @return    the oid of the underlying object.
	 */
	String getOid();
}

