/*************************************************************************
 *
 *  $RCSfile: TypeDescription.java,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: vg $ $Date: 2001/12/03 11:00:41 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
package com.sun.star.comp.typedescriptionmanager;

import com.sun.star.uno.*;
import com.sun.star.uno.RuntimeException;
import com.sun.star.lib.uno.typeinfo.TypeInfo;
import com.sun.star.lib.uno.typeinfo.AttributeTypeInfo;
import com.sun.star.lib.uno.typeinfo.MethodTypeInfo;
import com.sun.star.reflection.XTypeDescription;


//==================================================================================================
class TypeDescription implements XTypeDescription
{
	protected Class		_class = null; // optional if needed	
	protected TypeInfo[] _typeInfos = null;
	private String		_name;
	private TypeClass	_typeClass;
	
	//______________________________________________________________________________________________
	public TypeDescription( String name, TypeClass typeClass )
	{
		this._name		= name;
		this._typeClass = typeClass;
	}
	//______________________________________________________________________________________________
	public TypeDescription( Class c, TypeClass typeClass )
	{
		this._class		= c;
		this._name		= c.getName();
		this._typeClass = typeClass;
	}
	
	// XTypeDescription
	//______________________________________________________________________________________________
    public TypeClass getTypeClass()
		throws RuntimeException
	{
		return _typeClass;
	}
	//______________________________________________________________________________________________
    public String getName()
		throws RuntimeException
	{
		return _name;
	}
	
	//______________________________________________________________________________________________
	protected void initTypeInfos()
	{
		try
		{
			_typeInfos = (TypeInfo[])_class.getField( "UNOTYPEINFO" ).get( null );
		}
		catch (NoSuchFieldException exc)
		{
		}
		catch (java.lang.SecurityException exc)
		{
		}
		catch (IllegalAccessException exc)
		{
		}
		if (_typeInfos == null)
			_typeInfos = new TypeInfo[0];
	}
	//______________________________________________________________________________________________
	protected TypeInfo getTypeInfo( String name )
	{
		if (_typeInfos == null)
			initTypeInfos();
		for ( int i=0; i < _typeInfos.length; ++i )
		{
			if (_typeInfos[i].getName().equals( name ))
				return _typeInfos[i];
		}
		return null; 
	}
	//______________________________________________________________________________________________
	protected boolean isUnsigned( String name )
	{
		if (_typeInfos == null)
			initTypeInfos();
		for ( int i=0; i < _typeInfos.length; ++i )
		{
			if (_typeInfos[i].getName().equals( name ))
				return _typeInfos[i].isUnsigned();
		}
		return false; 
	}	
	//______________________________________________________________________________________________
	protected boolean isInterface( String name )
	{
		if (_typeInfos == null)
			initTypeInfos();
		for ( int i=0; i < _typeInfos.length; ++i )
		{
			if (_typeInfos[i].getName().equals( name ))
				return _typeInfos[i].isInterface();
		}
		return false; 
	}	
	//______________________________________________________________________________________________
	protected boolean isReadOnly( String name )
	{
		if (_typeInfos == null)
			initTypeInfos();
		for ( int i=0; i < _typeInfos.length; ++i )
		{
			if (_typeInfos[i].getName().equals( name ) &&
				_typeInfos[i] instanceof AttributeTypeInfo)
			{
				return ((AttributeTypeInfo)_typeInfos[i]).isReadOnly();
			}
		}
		return false; 
	}
//  	//______________________________________________________________________________________________
//  	protected boolean isRetrunUnsigned( String name )
//  	{
//  		return isUnsigned( name );
//  	}
	//______________________________________________________________________________________________
	protected boolean isOneway( String name )
	{
		if (_typeInfos == null)
			initTypeInfos();
		for ( int i=0; i < _typeInfos.length; ++i )
		{
			if (_typeInfos[i].getName().equals( name ) &&
				_typeInfos[i] instanceof MethodTypeInfo)
			{
				return ((MethodTypeInfo)_typeInfos[i]).isOneway();
			}
		}
		return false;
	}
	//______________________________________________________________________________________________
	protected boolean isConst( String name )
	{
		if (_typeInfos == null)
			initTypeInfos();
		for ( int i=0; i < _typeInfos.length; ++i )
		{
			if (_typeInfos[i].getName().equals( name ) &&
				_typeInfos[i] instanceof MethodTypeInfo)
			{
				return ((MethodTypeInfo)_typeInfos[i]).isConst();
			}
		}
		return false;
	}	
}

