/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xmlsearch.xml.qe;

import com.sun.xmlsearch.xml.ContextTables;
import com.sun.xmlsearch.xml.XmlIndex;
import com.sun.xmlsearch.xml.qe.ConceptData;
import com.sun.xmlsearch.xml.qe.HitStore;
import com.sun.xmlsearch.xml.qe.QueryHit;
import com.sun.xmlsearch.xml.qe.QueryHitData;
import com.sun.xmlsearch.xml.qe.RoleFiller;
import com.sun.xmlsearch.xml.qe.Search;
import java.io.PrintStream;

class Query {
    protected static double MissingTermPenalty = 10.0;
    protected final XmlIndex _env;
    protected final ContextTables _ctx;
    protected final HitStore _store;
    protected double _currentStandard;
    protected final int _nColumns;
    protected double[] _missingPenalty;
    protected double[] _upperboundTemplate;
    protected double[] _penalties;
    private final int _nHitsRequested;
    private double _missingTermsPenalty;
    protected boolean _vote = false;
    private boolean[] _ignoredElements;
    private RoleFiller _roleFillerList;

    public Query(XmlIndex xmlIndex, int n, int n2, double[] dArray) {
        this._env = xmlIndex;
        this._ctx = xmlIndex != null ? this._env.getContextInfo() : null;
        this._nColumns = n;
        this._nHitsRequested = n2;
        this._missingPenalty = new double[n];
        this._upperboundTemplate = new double[n];
        this._penalties = dArray;
        this._currentStandard = (double)(n - 1) * MissingTermPenalty + MissingTermPenalty - 1.0E-4;
        this._store = new HitStore(this._currentStandard, n2, n);
        for (int i = 0; i < this._nColumns; ++i) {
            this._missingPenalty[i] = dArray != null ? dArray[i] : MissingTermPenalty;
        }
        this.makePenaltiesTable();
    }

    public ConceptData makeConceptData(int n, int n2, int n3, double d) {
        return new ConceptData(n3, n2, d, n, this._nColumns, this._ctx);
    }

    public void addControlConceptData(Search search, int n) {
    }

    public boolean zoned() {
        return false;
    }

    public final void saveRoleFillers(RoleFiller roleFiller) {
        this._roleFillerList = roleFiller;
    }

    public final RoleFiller getRoleFillers() {
        return this._roleFillerList;
    }

    public final void missingTerms(int n) {
        this._missingTermsPenalty = MissingTermPenalty * (double)n;
    }

    public final double lookupPenalty(int n) {
        return this._penalties[n];
    }

    public final double getOutOufOrderPenalty() {
        return 0.25;
    }

    public final double getGapPenalty() {
        return 0.005;
    }

    public final int getNColumns() {
        return this._nColumns;
    }

    public final void setIgnoredElements(String[] stringArray) {
        if (this._ctx != null) {
            this._ignoredElements = this._ctx.getIgnoredElementsSet(stringArray);
        }
    }

    public final QueryHit maybeCreateQueryHit(double d, int n, int n2, int n3, int n4) {
        return this._store.goodEnough(d += this._missingTermsPenalty, n2, n3) && (this._ignoredElements == null || this._ctx.notIgnored(n4, this._ignoredElements)) ? this._store.createQueryHit(d, n, n2, n3) : null;
    }

    public final void resetForNextDocument() {
        this._currentStandard = this._store.getCurrentStandard();
        for (int i = 0; i < this._nColumns; ++i) {
            this._upperboundTemplate[i] = this._missingPenalty[i];
        }
        this._vote = false;
    }

    public final boolean vote() {
        double d = 0.0;
        for (int i = 0; i < this._nColumns; ++i) {
            d += this._upperboundTemplate[i];
        }
        this._vote = d <= this._currentStandard;
        return this._vote;
    }

    public final void updateEstimate(int n, double d) {
        if (d < this._upperboundTemplate[n]) {
            this._upperboundTemplate[n] = d;
        }
    }

    public final void printHits(PrintStream printStream, int n) throws Exception {
        if (n > 0) {
            QueryHit queryHit = this._store.firstBestQueryHit();
            while (queryHit != null) {
                printStream.println(this._env.hitToString(queryHit));
                queryHit = --n > 0 ? this._store.nextBestQueryHit() : null;
            }
            printStream.println("** hit **");
        }
    }

    public final String getHitsInXml(int n) throws Exception {
        StringBuffer stringBuffer = new StringBuffer(16384);
        stringBuffer.append("<QueryResults>");
        if (n > 0) {
            QueryHit queryHit = this._store.firstBestQueryHit();
            while (queryHit != null) {
                this._env.hitToXml(queryHit, stringBuffer);
                queryHit = --n > 0 ? this._store.nextBestQueryHit() : null;
            }
        }
        stringBuffer.append("</QueryResults>");
        System.out.println("|getHitsInXml|=" + stringBuffer.length());
        return stringBuffer.toString();
    }

    public final QueryHitData[] getHits(int n) throws Exception {
        QueryHit queryHit;
        if (n > 0 && (queryHit = this._store.firstBestQueryHit()) != null) {
            QueryHitData[] queryHitDataArray = new QueryHitData[n];
            int n2 = 0;
            do {
                queryHitDataArray[n2++] = this._env.hitToData(queryHit);
            } while ((queryHit = n2 < n ? this._store.nextBestQueryHit() : null) != null);
            return queryHitDataArray;
        }
        return null;
    }

    private final void makePenaltiesTable() {
        int n = 1 << this._nColumns;
        this._penalties = new double[n];
        for (int i = 0; i < n; ++i) {
            this._penalties[i] = this.computePenalty(i);
        }
    }

    private final double computePenalty(int n) {
        double d = 0.0;
        for (int i = 0; i < this._nColumns; ++i) {
            if ((n & 1 << i) != 0) continue;
            d += this._missingPenalty[i];
        }
        return d;
    }
}

