/*
 * Decompiled with CFR 0.152.
 */
package org.openide.util.datatransfer;

import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.Transferable;
import javax.swing.event.EventListenerList;
import org.openide.util.datatransfer.ClipboardEvent;
import org.openide.util.datatransfer.ClipboardListener;
import org.openide.util.datatransfer.ExTransferable;
import org.openide.util.datatransfer.MultiTransferObject;

public abstract class ExClipboard
extends Clipboard {
    private EventListenerList listeners = new EventListenerList();
    static /* synthetic */ Class class$org$openide$util$datatransfer$ClipboardListener;

    public ExClipboard(String string) {
        super(string);
    }

    public final void addClipboardListener(ClipboardListener clipboardListener) {
        this.listeners.add(class$org$openide$util$datatransfer$ClipboardListener == null ? (class$org$openide$util$datatransfer$ClipboardListener = ExClipboard.class$("org.openide.util.datatransfer.ClipboardListener")) : class$org$openide$util$datatransfer$ClipboardListener, clipboardListener);
    }

    public final void removeClipboardListener(ClipboardListener clipboardListener) {
        this.listeners.remove(class$org$openide$util$datatransfer$ClipboardListener == null ? (class$org$openide$util$datatransfer$ClipboardListener = ExClipboard.class$("org.openide.util.datatransfer.ClipboardListener")) : class$org$openide$util$datatransfer$ClipboardListener, clipboardListener);
    }

    protected final void fireClipboardChange() {
        Object[] objectArray = this.listeners.getListenerList();
        ClipboardEvent clipboardEvent = null;
        int n = objectArray.length - 2;
        while (n >= 0) {
            ClipboardListener clipboardListener = (ClipboardListener)objectArray[n + 1];
            if (clipboardEvent == null) {
                clipboardEvent = new ClipboardEvent(this);
            }
            clipboardListener.clipboardChanged(clipboardEvent);
            n -= 2;
        }
    }

    protected abstract Convertor[] getConvertors();

    public Transferable convert(Transferable transferable) {
        Convertor[] convertorArray = this.getConvertors();
        int n = 0;
        while (n < convertorArray.length) {
            transferable = convertorArray[n].convert(transferable);
            ++n;
        }
        return transferable;
    }

    public static void transferableAccepted(Transferable transferable, int n) {
        if (transferable instanceof ExTransferable) {
            ((ExTransferable)transferable).fireAccepted(n);
        } else if (transferable.isDataFlavorSupported(ExTransferable.multiFlavor)) {
            try {
                MultiTransferObject multiTransferObject = (MultiTransferObject)transferable.getTransferData(ExTransferable.multiFlavor);
                int n2 = multiTransferObject.getCount();
                int n3 = 0;
                while (n3 < n2) {
                    ExClipboard.transferableAccepted(multiTransferObject.getTransferableAt(n3), n);
                    ++n3;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void transferableRejected(Transferable transferable) {
        if (transferable instanceof ExTransferable) {
            ((ExTransferable)transferable).fireRejected();
        } else if (transferable.isDataFlavorSupported(ExTransferable.multiFlavor)) {
            try {
                MultiTransferObject multiTransferObject = (MultiTransferObject)transferable.getTransferData(ExTransferable.multiFlavor);
                int n = multiTransferObject.getCount();
                int n2 = 0;
                while (n2 < n) {
                    ExClipboard.transferableRejected(multiTransferObject.getTransferableAt(n2));
                    ++n2;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void transferableOwnershipLost(Transferable transferable) {
        if (transferable instanceof ExTransferable) {
            ((ExTransferable)transferable).fireOwnershipLost();
        } else if (transferable.isDataFlavorSupported(ExTransferable.multiFlavor)) {
            try {
                MultiTransferObject multiTransferObject = (MultiTransferObject)transferable.getTransferData(ExTransferable.multiFlavor);
                int n = multiTransferObject.getCount();
                int n2 = 0;
                while (n2 < n) {
                    ExClipboard.transferableOwnershipLost(multiTransferObject.getTransferableAt(n2));
                    ++n2;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static interface Convertor {
        public Transferable convert(Transferable var1);
    }
}

