/*
 * Decompiled with CFR 0.152.
 */
package org.openide.loaders;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.beans.IntrospectionException;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.io.File;
import java.io.Serializable;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListDataEvent;
import javax.swing.event.TreeSelectionEvent;
import org.openide.ErrorManager;
import org.openide.TopManager;
import org.openide.WizardDescriptor;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.ExplorerPanel;
import org.openide.explorer.view.BeanTreeView;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystem;
import org.openide.loaders.DataFilter;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.TemplateWizard;
import org.openide.loaders.TemplateWizard2;
import org.openide.nodes.BeanNode;
import org.openide.nodes.Children;
import org.openide.nodes.FilterNode;
import org.openide.nodes.Node;
import org.openide.nodes.NodeMemberEvent;
import org.openide.nodes.NodeNotFoundException;
import org.openide.nodes.NodeOp;
import org.openide.nodes.NodeReorderEvent;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.openide.util.enum.SequenceEnumeration;
import org.openide.util.enum.SingletonEnumeration;

final class TemplateWizard2
extends JPanel
implements DocumentListener,
WizardDescriptor.FinishPanel,
DataFilter,
PropertyChangeListener,
VetoableChangeListener {
    private static MessageFormat defaultPackageName;
    private ChangeListener listener;
    private Reference system = new WeakReference<Object>(null);
    private boolean systemSelected;
    private Node rootNode;
    private String extension;
    private JPanel namePanel;
    private JLabel jLabel1;
    private JTextField className;
    private ExplorerPanel packagesPanel;
    private JPanel packageNamePanel;
    private JLabel jLabel2;
    private JTextField packageName;
    private JLabel jLabel3;
    private JTextField directoryName;
    private BeanTreeView beanTreeView;
    private JLabel descriptionLabel;
    static /* synthetic */ Class class$org$openide$loaders$TemplateWizard2;
    static /* synthetic */ Class class$org$openide$loaders$DataFolder;

    public TemplateWizard2() {
        this.initComponents();
        this.setName(DataObject.getString("LAB_TargetLocationPanelName"));
        this.rootNode = this.createPackagesNode();
        this.packagesPanel.getExplorerManager().setRootContext(this.rootNode);
        this.packagesPanel.getExplorerManager().addPropertyChangeListener(this);
        this.packagesPanel.getExplorerManager().addVetoableChangeListener(this);
        this.packageName.getDocument().addDocumentListener(this);
        this.packageName.unregisterKeyboardAction(KeyStroke.getKeyStroke(10, 0));
        this.className.getDocument().addDocumentListener(this);
        this.className.unregisterKeyboardAction(KeyStroke.getKeyStroke(10, 0));
        ResourceBundle resourceBundle = NbBundle.getBundle(class$org$openide$loaders$TemplateWizard2 == null ? (class$org$openide$loaders$TemplateWizard2 = TemplateWizard2.class$("org.openide.loaders.TemplateWizard2")) : class$org$openide$loaders$TemplateWizard2);
        this.jLabel1.setDisplayedMnemonic(resourceBundle.getString("CTL_TemplateClassName_Mnemonic").charAt(0));
        this.jLabel2.setDisplayedMnemonic(resourceBundle.getString("CTL_TemplatePackageName_Mnemonic").charAt(0));
        this.jLabel3.setDisplayedMnemonic(resourceBundle.getString("CTL_TemplateDirectoryName_Mnemonic").charAt(0));
        this.descriptionLabel.setText(resourceBundle.getString("LAB_TargetLocationDescription"));
        this.descriptionLabel.setDisplayedMnemonic(resourceBundle.getString("LAB_TargetLocationDescription_Mnemonic").charAt(0));
        this.className.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("ACSD_TemplateClassName"));
        this.packageName.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("ACSD_TemplatePackageName"));
        this.directoryName.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("ACSD_TemplateDirectoryName"));
        this.beanTreeView.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("ACSD_TargetLocationDescription"));
        this.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("ACSD_TemplateWizard2"));
        this.putClientProperty("WizardPanel_contentData", new String[]{this.getName()});
        this.putClientProperty("WizardPanel_contentSelectedIndex", new Integer(0));
    }

    public Dimension getPreferredSize() {
        return TemplateWizard.PREF_DIM;
    }

    public void requestFocus() {
        this.className.requestFocus();
        this.className.selectAll();
    }

    private Node createPackagesNode() {
        Node node = TopManager.getDefault().getPlaces().nodes().repository(this);
        return new FilterNode(node, new ExCh(node));
    }

    private void initComponents() {
        this.namePanel = new JPanel();
        this.jLabel1 = new JLabel();
        this.className = new JTextField();
        this.packagesPanel = new ExplorerPanel();
        this.packageNamePanel = new JPanel();
        this.jLabel2 = new JLabel();
        this.packageName = new JTextField();
        this.jLabel3 = new JLabel();
        this.directoryName = new JTextField();
        this.beanTreeView = new BeanTreeView();
        this.descriptionLabel = new JLabel();
        this.setLayout(new BorderLayout(0, 11));
        this.setPreferredSize(new Dimension(0, 0));
        this.namePanel.setLayout(new BorderLayout(12, 0));
        this.jLabel1.setText(ResourceBundle.getBundle("org/openide/loaders/Bundle").getString("CTL_TemplateClassName"));
        this.jLabel1.setLabelFor(this.className);
        this.namePanel.add((Component)this.jLabel1, "West");
        this.className.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent focusEvent) {
                TemplateWizard2.this.classNameFocusGained(focusEvent);
            }
        });
        this.namePanel.add((Component)this.className, "Center");
        this.add((Component)this.namePanel, "North");
        this.packagesPanel.setLayout(new BorderLayout(0, 5));
        this.packageNamePanel.setLayout(new GridBagLayout());
        this.jLabel2.setText(ResourceBundle.getBundle("org/openide/loaders/Bundle").getString("CTL_TemplatePackageName"));
        this.jLabel2.setLabelFor(this.packageName);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(6, 0, 5, 0);
        gridBagConstraints.anchor = 17;
        this.packageNamePanel.add((Component)this.jLabel2, gridBagConstraints);
        this.packageName.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent focusEvent) {
                TemplateWizard2.this.packageNameFocusGained(focusEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(6, 8, 5, 0);
        gridBagConstraints.weightx = 1.0;
        this.packageNamePanel.add((Component)this.packageName, gridBagConstraints);
        this.jLabel3.setText(ResourceBundle.getBundle("org/openide/loaders/Bundle").getString("CTL_TemplateDirectoryName"));
        this.jLabel3.setLabelFor(this.directoryName);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        this.packageNamePanel.add((Component)this.jLabel3, gridBagConstraints);
        this.directoryName.setEditable(false);
        this.directoryName.setText("jTextField1");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 8, 0, 0);
        this.packageNamePanel.add((Component)this.directoryName, gridBagConstraints);
        this.packagesPanel.add((Component)this.packageNamePanel, "South");
        this.beanTreeView.setPopupAllowed(false);
        this.packagesPanel.add((Component)this.beanTreeView, "Center");
        this.descriptionLabel.setLabelFor(this.beanTreeView);
        this.packagesPanel.add((Component)this.descriptionLabel, "North");
        this.add((Component)this.packagesPanel, "Center");
    }

    private void packageNameFocusGained(FocusEvent focusEvent) {
        this.packageName.selectAll();
    }

    private void packageModelChanged(ListDataEvent listDataEvent) {
    }

    private void classNameFocusGained(FocusEvent focusEvent) {
        if (Utilities.getOperatingSystem() == 8 | Utilities.getOperatingSystem() == 256) {
            return;
        }
        this.className.selectAll();
    }

    private void templatesTreeValueChanged(TreeSelectionEvent treeSelectionEvent) {
    }

    public boolean acceptDataObject(DataObject dataObject) {
        Node.Cookie cookie = dataObject.getCookie(class$org$openide$loaders$DataFolder == null ? (class$org$openide$loaders$DataFolder = TemplateWizard2.class$("org.openide.loaders.DataFolder")) : class$org$openide$loaders$DataFolder);
        if (cookie == null) {
            return false;
        }
        try {
            FileSystem fileSystem = dataObject.getPrimaryFile().getFileSystem();
            if (!fileSystem.isHidden() || this.system.get() == fileSystem) {
                return !fileSystem.isReadOnly();
            }
            return false;
        }
        catch (FileStateInvalidException fileStateInvalidException) {
            return false;
        }
    }

    public void vetoableChange(PropertyChangeEvent propertyChangeEvent) throws PropertyVetoException {
        Node[] nodeArray;
        if ("selectedNodes".equals(propertyChangeEvent.getPropertyName()) && (nodeArray = (Node[])propertyChangeEvent.getNewValue()).length > 1) {
            throw new PropertyVetoException("Only single selection allowed", propertyChangeEvent);
        }
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if ("selectedNodes".equals(propertyChangeEvent.getPropertyName())) {
            DataFolder dataFolder;
            Node[] nodeArray = this.packagesPanel.getExplorerManager().getSelectedNodes();
            if (nodeArray.length == 1 && (dataFolder = (DataFolder)nodeArray[0].getCookie(class$org$openide$loaders$DataFolder == null ? (class$org$openide$loaders$DataFolder = TemplateWizard2.class$("org.openide.loaders.DataFolder")) : class$org$openide$loaders$DataFolder)) != null) {
                try {
                    FileObject fileObject = dataFolder.getPrimaryFile();
                    FileSystem fileSystem = fileObject.getFileSystem();
                    this.system = new WeakReference<FileSystem>(fileSystem);
                    this.systemSelected = true;
                    String string = fileObject.getPackageNameExt('.', '.');
                    this.packageName.getDocument().removeDocumentListener(this);
                    this.packageName.setText(string);
                    this.updateDirectory();
                    this.packageName.getDocument().addDocumentListener(this);
                    this.fireStateChanged();
                    return;
                }
                catch (FileStateInvalidException fileStateInvalidException) {
                    this.system = new WeakReference<Object>(null);
                    this.systemSelected = false;
                }
            }
            this.systemSelected = false;
            this.setTargetFolder((DataFolder)null);
        }
    }

    private void fireStateChanged() {
        if (this.listener != null) {
            this.listener.stateChanged(new ChangeEvent(this));
        }
    }

    public void changedUpdate(DocumentEvent documentEvent) {
        if (documentEvent.getDocument() == this.packageName.getDocument()) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    String string = TemplateWizard2.this.packageName.getText();
                    if (string != null) {
                        TemplateWizard2.this.setTargetFolder(string);
                        TemplateWizard2.this.updateDirectory();
                    }
                }
            });
            return;
        }
        if (documentEvent.getDocument() == this.className.getDocument()) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    if (TemplateWizard2.this.className.getText().equals("")) {
                        TemplateWizard2.this.setClassName("");
                    }
                    TemplateWizard2.this.fireStateChanged();
                }
            });
        }
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        if (documentEvent.getDocument() == this.packageName.getDocument()) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    if (TemplateWizard2.this.packageName.getText().length() == 0) {
                        FileSystem fileSystem = (FileSystem)TemplateWizard2.this.system.get();
                        if (fileSystem != null) {
                            DataFolder dataFolder = DataFolder.findFolder(fileSystem.getRoot());
                            TemplateWizard2.this.setTargetFolder(dataFolder);
                            TemplateWizard2.this.packageName.selectAll();
                        }
                        TemplateWizard2.this.updateDirectory();
                    } else {
                        TemplateWizard2.this.updateDirectory();
                        TemplateWizard2.this.fireStateChanged();
                    }
                }
            });
        }
        if (documentEvent.getDocument() == this.className.getDocument()) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    if (TemplateWizard2.this.className.getText().equals("")) {
                        TemplateWizard2.this.setClassName("");
                    }
                    TemplateWizard2.this.fireStateChanged();
                }
            });
        }
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        this.changedUpdate(documentEvent);
    }

    public Component getComponent() {
        return this;
    }

    public HelpCtx getHelp() {
        return new HelpCtx(class$org$openide$loaders$TemplateWizard2 == null ? (class$org$openide$loaders$TemplateWizard2 = TemplateWizard2.class$("org.openide.loaders.TemplateWizard2")) : class$org$openide$loaders$TemplateWizard2);
    }

    public void readSettings(Object object) {
        FileObject fileObject;
        TemplateWizard templateWizard = (TemplateWizard)object;
        DataObject dataObject = templateWizard.getTemplate();
        if (dataObject != null) {
            this.extension = dataObject.getPrimaryFile().getExt();
        }
        this.setClassName(templateWizard.getClassName());
        String string = templateWizard.getPackageName();
        FileSystem fileSystem = templateWizard.getSystem();
        this.system = new WeakReference<FileSystem>(fileSystem);
        this.requestFocus();
        if (fileSystem != null && string != null && (fileObject = fileSystem.find(string, null, null)) != null) {
            this.systemSelected = this.setTargetFolder(DataFolder.findFolder(fileObject));
            return;
        }
        this.systemSelected = this.setTargetFolder(string);
    }

    public void storeSettings(Object object) {
        TemplateWizard templateWizard = (TemplateWizard)object;
        FileSystem fileSystem = (FileSystem)this.system.get();
        String string = this.packageName.getText();
        if (string.equals(TemplateWizard2.defaultPackageName(fileSystem))) {
            string = "";
        }
        templateWizard.setNameSystem(string, fileSystem);
        string = this.className.getText();
        if (string.equals(TemplateWizard2.defaultClassName())) {
            string = null;
        }
        templateWizard.setTargetName(string);
    }

    public boolean isValid() {
        Object object;
        String string = this.packageName.getText();
        if (string.length() == 0 && ((Node[])(object = this.packagesPanel.getExplorerManager().getSelectedNodes())).length == 1 && object[0] == this.rootNode) {
            return false;
        }
        object = (FileSystem)this.system.get();
        if (object != null) {
            FileObject fileObject = ((FileSystem)object).find(string, this.className.getText(), this.extension);
            if (fileObject != null) {
                return false;
            }
            if (string.equals(TemplateWizard2.defaultPackageName((FileSystem)object)) && (fileObject = ((FileSystem)object).find("", this.className.getText(), this.extension)) != null) {
                return false;
            }
            if (((FileSystem)object).isReadOnly()) {
                return false;
            }
        }
        return true;
    }

    public void addChangeListener(ChangeListener changeListener) {
        if (this.listener != null) {
            throw new IllegalStateException();
        }
        this.listener = changeListener;
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.listener = null;
    }

    private static String computeSuggestion(Node node, String string, Node[] nodeArray) {
        Node[] nodeArray2 = node.getChildren().getNodes();
        String string2 = null;
        int n = 0;
        while (n < nodeArray2.length) {
            String string3 = nodeArray2[n].getName();
            if (string3.startsWith(string)) {
                if (string2 == null) {
                    string2 = string3;
                    if (nodeArray != null) {
                        nodeArray[0] = nodeArray2[n];
                    }
                } else {
                    int n2 = string.length();
                    int n3 = Math.min(string3.length(), string2.length());
                    while (n2 < n3 && string2.charAt(n2) == string3.charAt(n2)) {
                        ++n2;
                    }
                    string2 = string2.substring(0, n2);
                }
            }
            ++n;
        }
        if (string2 == null || string2.length() == string.length()) {
            return null;
        }
        return string2.substring(string.length());
    }

    private boolean setTargetFolder(DataFolder dataFolder) {
        boolean bl;
        Node node;
        String string;
        Serializable serializable;
        if (dataFolder != null) {
            serializable = dataFolder.getPrimaryFile();
            string = ((FileObject)serializable).getPackageNameExt('.', '.');
            StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
            try {
                FileSystem fileSystem = ((FileObject)serializable).getFileSystem();
                if (((FileObject)serializable).isRoot()) {
                    string = TemplateWizard2.defaultPackageName(fileSystem);
                }
                this.system = new WeakReference<FileSystem>(fileSystem);
                SequenceEnumeration sequenceEnumeration = new SequenceEnumeration(new SingletonEnumeration(fileSystem.getSystemName()), stringTokenizer);
                node = NodeOp.findPath(this.rootNode, sequenceEnumeration);
                bl = true;
            }
            catch (FileStateInvalidException fileStateInvalidException) {
                node = this.rootNode;
                string = "";
                bl = false;
            }
            catch (NodeNotFoundException nodeNotFoundException) {
                node = nodeNotFoundException.getClosestNode();
                DataFolder dataFolder2 = (DataFolder)node.getCookie(class$org$openide$loaders$DataFolder == null ? (class$org$openide$loaders$DataFolder = TemplateWizard2.class$("org.openide.loaders.DataFolder")) : class$org$openide$loaders$DataFolder);
                string = dataFolder2 != null ? dataFolder2.getPrimaryFile().getPackageNameExt('.', '.') : "";
                bl = false;
            }
        } else {
            node = this.rootNode;
            string = null;
            bl = true;
        }
        serializable = this.packagesPanel.getExplorerManager();
        ((ExplorerManager)serializable).removePropertyChangeListener(this);
        this.packageName.getDocument().removeDocumentListener(this);
        try {
            ((ExplorerManager)serializable).setSelectedNodes(new Node[]{node});
        }
        catch (PropertyVetoException propertyVetoException) {
            throw new InternalError();
        }
        this.packageName.setText(string);
        this.updateDirectory();
        this.packageName.getDocument().addDocumentListener(this);
        ((ExplorerManager)serializable).addPropertyChangeListener(this);
        this.fireStateChanged();
        return bl;
    }

    private boolean setTargetFolder(String string) {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Node[] nodeArray;
        Node node = null;
        NodeNotFoundException nodeNotFoundException = null;
        HashSet<Node> hashSet = new HashSet<Node>(Arrays.asList(this.packagesPanel.getExplorerManager().getSelectedNodes()));
        FileSystem fileSystem = (FileSystem)this.system.get();
        Node node2 = null;
        if (this.systemSelected && fileSystem != null) {
            node2 = NodeOp.findChild(this.rootNode, fileSystem.getSystemName());
        }
        if (node2 != null) {
            Node[] nodeArray2 = new Node[1];
            nodeArray = nodeArray2;
            nodeArray2[0] = node2;
        } else {
            nodeArray = this.rootNode.getChildren().getNodes();
        }
        Node[] nodeArray3 = nodeArray;
        int n = 0;
        while (n < nodeArray3.length) {
            object4 = nodeArray3[n];
            object3 = new StringTokenizer(string, ".");
            try {
                node = NodeOp.findPath((Node)object4, (Enumeration)object3);
                break;
            }
            catch (NodeNotFoundException nodeNotFoundException2) {
                if (!((StringTokenizer)object3).hasMoreElements()) {
                    object2 = TemplateWizard2.computeSuggestion(nodeNotFoundException2.getClosestNode(), nodeNotFoundException2.getMissingChildName(), null);
                    if (nodeNotFoundException == null || hashSet.contains(object4) && object2 != null) {
                        nodeNotFoundException = nodeNotFoundException2;
                    }
                }
                ++n;
            }
        }
        if (node != null) {
            nodeNotFoundException = null;
        } else {
            if (nodeNotFoundException == null) {
                return false;
            }
            node = nodeNotFoundException.getClosestNode();
        }
        object4 = this.packagesPanel.getExplorerManager();
        ((ExplorerManager)object4).removePropertyChangeListener(this);
        if (nodeNotFoundException != null) {
            object3 = new Node[1];
            object = TemplateWizard2.computeSuggestion(nodeNotFoundException.getClosestNode(), nodeNotFoundException.getMissingChildName(), (Node[])object3);
            if (object != null) {
                this.packageName.getDocument().removeDocumentListener(this);
                this.packageName.setText(string + (String)object);
                this.updateDirectory();
                object2 = this.packageName.getCaret();
                object2.setDot(string.length() + ((String)object).length());
                object2.moveDot(string.length());
                this.packageName.getDocument().addDocumentListener(this);
            }
            if (object3[0] != null) {
                node = object3[0];
            }
        }
        try {
            ((ExplorerManager)object4).setSelectedNodes(new Node[]{node});
            this.beanTreeView.expandNode(node);
        }
        catch (PropertyVetoException propertyVetoException) {
            throw new InternalError();
        }
        object3 = (DataFolder)node.getCookie(class$org$openide$loaders$DataFolder == null ? (class$org$openide$loaders$DataFolder = TemplateWizard2.class$("org.openide.loaders.DataFolder")) : class$org$openide$loaders$DataFolder);
        if (object3 != null) {
            try {
                object = ((DataObject)object3).getPrimaryFile().getFileSystem();
                this.system = new WeakReference<Object>(object);
            }
            catch (FileStateInvalidException fileStateInvalidException) {
                // empty catch block
            }
        }
        ((ExplorerManager)object4).addPropertyChangeListener(this);
        this.fireStateChanged();
        return nodeNotFoundException == null;
    }

    private void setClassName(String string) {
        String string2 = string;
        if (string == null || string.length() == 0) {
            string2 = TemplateWizard2.defaultClassName();
        }
        this.className.getDocument().removeDocumentListener(this);
        this.className.setText(string2);
        this.className.getDocument().addDocumentListener(this);
        if (string == null || string.length() == 0) {
            this.className.selectAll();
        }
    }

    private static String defaultPackageName(FileSystem fileSystem) {
        if (defaultPackageName == null) {
            defaultPackageName = new MessageFormat(DataObject.getString("FMT_TemplateDefaultPackageName"));
        }
        String string = fileSystem == null ? "" : fileSystem.getDisplayName();
        return defaultPackageName.format(new Object[]{string});
    }

    private static String defaultClassName() {
        return DataObject.getString("FMT_TemplateDefaultClassName");
    }

    private void updateDirectory() {
        String string;
        StringBuffer stringBuffer = new StringBuffer();
        FileSystem fileSystem = (FileSystem)this.system.get();
        if (fileSystem != null) {
            stringBuffer.append(fileSystem.getDisplayName());
        }
        if ((string = this.packageName.getText()).equals(TemplateWizard2.defaultPackageName(fileSystem))) {
            string = "";
        }
        if (string.length() > 0) {
            stringBuffer.append(File.separatorChar);
            stringBuffer.append(string.replace('.', File.separatorChar));
        }
        this.directoryName.setText(stringBuffer.toString());
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final class ExCh
    extends FilterNode.Children {
        public ExCh(Node node) {
            super(node);
        }

        protected void addNotify() {
            this.updateKeys();
        }

        protected void filterChildrenRemoved(NodeMemberEvent nodeMemberEvent) {
            this.updateKeys();
        }

        protected void filterChildrenReordered(NodeReorderEvent nodeReorderEvent) {
            this.updateKeys();
        }

        protected Node[] createNodes(Object object) {
            if (object == this) {
                FileSystem fileSystem = (FileSystem)TemplateWizard2.this.system.get();
                if (fileSystem != null && fileSystem.isHidden()) {
                    try {
                        DataFolder dataFolder = DataFolder.findFolder(fileSystem.getRoot());
                        Children children = dataFolder.createNodeChildren(TemplateWizard2.this);
                        class NoSynchBeanNode
                        extends BeanNode {
                            private final /* synthetic */ ExCh this$1;

                            public NoSynchBeanNode(ExCh exCh, Object object, Children children) throws IntrospectionException {
                                super(object, children);
                                this.this$1 = exCh;
                                this.setSynchronizeName(false);
                            }
                        }
                        NoSynchBeanNode noSynchBeanNode = new NoSynchBeanNode(this, fileSystem, children);
                        ((Node)noSynchBeanNode).setName(fileSystem.getSystemName());
                        noSynchBeanNode.setDisplayName(fileSystem.getDisplayName());
                        return new Node[]{noSynchBeanNode};
                    }
                    catch (IntrospectionException introspectionException) {
                        ErrorManager.getDefault().notify(introspectionException);
                    }
                }
                return new Node[0];
            }
            return super.createNodes(object);
        }

        protected void filterChildrenAdded(NodeMemberEvent nodeMemberEvent) {
            this.updateKeys();
        }

        private void updateKeys() {
            Node[] nodeArray = this.original.getChildren().getNodes();
            ArrayList<Object> arrayList = new ArrayList<Object>(nodeArray.length + 1);
            arrayList.add(this);
            int n = 0;
            while (n < nodeArray.length) {
                arrayList.add(nodeArray[n].cloneNode());
                ++n;
            }
            this.setKeys(arrayList);
        }
    }
}

