/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.bdb.bind.serial;

import com.sleepycat.bdb.bind.DataBuffer;
import com.sleepycat.bdb.bind.DataFormat;
import com.sleepycat.bdb.bind.KeyExtractor;
import com.sleepycat.bdb.bind.serial.SerialFormat;
import java.io.IOException;

public abstract class SerialSerialKeyExtractor
implements KeyExtractor {
    protected SerialFormat primaryKeyFormat;
    protected SerialFormat valueFormat;
    protected SerialFormat indexKeyFormat;

    public SerialSerialKeyExtractor(SerialFormat primaryKeyFormat, SerialFormat valueFormat, SerialFormat indexKeyFormat) {
        this.primaryKeyFormat = primaryKeyFormat;
        this.valueFormat = valueFormat;
        this.indexKeyFormat = indexKeyFormat;
    }

    public DataFormat getPrimaryKeyFormat() {
        return this.primaryKeyFormat;
    }

    public DataFormat getValueFormat() {
        return this.valueFormat;
    }

    public DataFormat getIndexKeyFormat() {
        return this.indexKeyFormat;
    }

    public void extractIndexKey(DataBuffer primaryKeyData, DataBuffer valueData, DataBuffer indexKeyData) throws IOException {
        Object valueInput;
        Object primaryKeyInput = this.primaryKeyFormat != null ? this.primaryKeyFormat.dataToObject(primaryKeyData) : null;
        Object indexKey = this.extractIndexKey(primaryKeyInput, valueInput = this.valueFormat != null ? this.valueFormat.dataToObject(valueData) : null);
        if (indexKey != null) {
            this.indexKeyFormat.objectToData(indexKey, indexKeyData);
        } else {
            indexKeyData.setData(null, 0, 0);
        }
    }

    public void clearIndexKey(DataBuffer valueData) throws IOException {
        Object value = this.valueFormat.dataToObject(valueData);
        if ((value = this.clearIndexKey(value)) != null) {
            this.valueFormat.objectToData(value, valueData);
        }
    }

    public abstract Object extractIndexKey(Object var1, Object var2) throws IOException;

    public abstract Object clearIndexKey(Object var1) throws IOException;
}

