/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.bdb;

import com.sleepycat.bdb.CurrentTransaction;
import com.sleepycat.bdb.TransactionWorker;
import com.sleepycat.bdb.util.ExceptionUnwrapper;
import com.sleepycat.db.DbDeadlockException;
import com.sleepycat.db.DbEnv;
import com.sleepycat.db.DbException;
import com.sleepycat.db.DbTxn;

public class TransactionRunner {
    private static final int DEFAULT_MAX_RETRIES = 10;
    private DbEnv env;
    private CurrentTransaction currentTxn;
    private int maxRetries;
    private boolean dirtyRead;
    private boolean noWait;

    public TransactionRunner(DbEnv env) {
        this(env, 10);
    }

    public TransactionRunner(DbEnv env, int maxRetries) {
        this.env = env;
        this.currentTxn = CurrentTransaction.getInstance(env);
        this.maxRetries = maxRetries;
    }

    public int getMaxRetries() {
        return this.maxRetries;
    }

    public void setMaxRetries(int maxRetries) {
        this.maxRetries = maxRetries;
    }

    public boolean getDirtyRead() {
        return this.dirtyRead;
    }

    public void setDirtyRead(boolean dirtyRead) {
        this.dirtyRead = dirtyRead;
    }

    public boolean getNoWait() {
        return this.noWait;
    }

    public void setNoWait(boolean noWait) {
        this.noWait = noWait;
    }

    public void run(TransactionWorker worker) throws DbException, Exception {
        if (this.currentTxn != null) {
            boolean dr = this.dirtyRead;
            boolean nw = this.noWait;
            int i = 0;
            while (true) {
                DbTxn txn = null;
                try {
                    txn = this.currentTxn.beginTxn(dr, nw);
                    worker.doWork();
                    if (txn != null && txn == this.currentTxn.getTxn()) {
                        this.currentTxn.commitTxn();
                    }
                    return;
                }
                catch (Exception e) {
                    e = ExceptionUnwrapper.unwrap(e);
                    if (txn != null && txn == this.currentTxn.getTxn()) {
                        try {
                            this.currentTxn.abortTxn();
                        }
                        catch (Exception e2) {
                            System.err.println(e2.toString());
                            throw e;
                        }
                    }
                    if (i >= this.maxRetries || !(e instanceof DbDeadlockException)) {
                        throw e;
                    }
                    ++i;
                    continue;
                }
                break;
            }
        }
        try {
            worker.doWork();
        }
        catch (Exception e) {
            throw ExceptionUnwrapper.unwrap(e);
        }
    }
}

