/*
 * Decompiled with CFR 0.152.
 */
package org.openide.execution;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import org.openide.ServiceType;
import org.openide.TopManager;

final class ExecutorType {
    ExecutorType() {
    }

    static final class Handle
    implements Serializable {
        static final long serialVersionUID = 7233109534462148872L;
        private String name;
        private String className;

        Handle() {
        }

        private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
            this.name = (String)objectInputStream.readObject();
            this.className = (String)objectInputStream.readObject();
        }

        private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
            objectOutputStream.writeObject(this.name);
            objectOutputStream.writeObject(this.className);
        }

        private Object readResolve() {
            ServiceType serviceType = null;
            TopManager topManager = TopManager.getDefault();
            ServiceType.Registry registry = topManager.getServices();
            serviceType = registry.find(this.name);
            if (serviceType == null) {
                try {
                    serviceType = registry.find(Class.forName(this.className, true, topManager.systemClassLoader()));
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
            }
            return serviceType == null ? null : new ServiceType.Handle(serviceType);
        }
    }
}

