/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.uno;

import com.sun.star.lib.uno.typedesc.TypeDescription;
import com.sun.star.lib.util.WeakTable;
import com.sun.star.uno.Any;
import com.sun.star.uno.BridgeTurner;
import com.sun.star.uno.IBridge;
import com.sun.star.uno.IEnvironment;
import com.sun.star.uno.IMapping;
import com.sun.star.uno.IQueryInterface;
import com.sun.star.uno.MappingWrapper;
import com.sun.star.uno.Type;
import com.sun.star.uno.TypeClass;
import com.sun.star.uno.XCurrentContext;
import java.lang.reflect.Constructor;
import java.util.Enumeration;
import java.util.Hashtable;

public class UnoRuntime {
    public static final boolean DEBUG = false;
    protected static WeakTable __environments = new WeakTable();
    protected static WeakTable __bridges = new WeakTable();
    private static int unique;
    private static long time;
    private static short count;
    private static int hostUnique;
    private static long lastTime;
    private static short lastCount;
    private static Object mutex;
    private static long ONE_SECOND;
    private static Hashtable m_currentContexts;
    static String s_uid_part;
    static /* synthetic */ Class class$com$sun$star$uno$IEnvironment;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$com$sun$star$uno$IBridge;

    static int getEnvironmentCount() {
        return __environments.size();
    }

    static int getBridgeCount() {
        return __bridges.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getUniqueKey() {
        Object object = mutex;
        synchronized (object) {
            if (lastCount == Short.MAX_VALUE) {
                boolean bl = false;
                while (!bl) {
                    time = new Long(System.currentTimeMillis());
                    if (time < lastTime + ONE_SECOND) {
                        try {
                            Thread.currentThread();
                            Thread.sleep(ONE_SECOND);
                        }
                        catch (InterruptedException interruptedException) {}
                        continue;
                    }
                    lastTime = time;
                    lastCount = Short.MIN_VALUE;
                    bl = true;
                }
            } else {
                time = lastTime;
            }
            unique = hostUnique;
            short s = lastCount;
            lastCount = (short)(s + 1);
            count = s;
        }
        return Integer.toString(unique, 16) + ":" + Long.toString(time, 16) + ":" + Integer.toString(count, 16);
    }

    public static synchronized String generateOid(Object object) {
        String string = null;
        if ((object = WeakTable.__getObject(object)) instanceof IQueryInterface) {
            string = ((IQueryInterface)object).getOid();
        }
        if (string == null) {
            string = object.hashCode() + s_uid_part;
        }
        return string;
    }

    public static XCurrentContext getCurrentContext() {
        return (XCurrentContext)m_currentContexts.get(Thread.currentThread());
    }

    public static void setCurrentContext(XCurrentContext xCurrentContext) {
        if (xCurrentContext == null) {
            m_currentContexts.remove(Thread.currentThread());
        } else {
            m_currentContexts.put(Thread.currentThread(), xCurrentContext);
        }
    }

    public static Object queryInterface(Type type, Object object) {
        Any any;
        if ((object = WeakTable.__getObject(object)) instanceof Any && (any = (Any)object).getType().getTypeClass() == TypeClass.INTERFACE) {
            object = any.getObject();
        }
        if (object instanceof IQueryInterface && (object = ((IQueryInterface)object).queryInterface(type)) instanceof Any && ((Any)object).getType().getTypeDescription().getTypeClass() != TypeClass.INTERFACE) {
            object = null;
        }
        try {
            if (!TypeDescription.getTypeDescription((Type)type).getZClass().isInstance(object)) {
                object = null;
            }
        }
        catch (ClassNotFoundException classNotFoundException) {}
        return object;
    }

    public static Object queryInterface(Class clazz, Object object) {
        return UnoRuntime.queryInterface(new Type(clazz), object);
    }

    public static boolean areSame(Object object, Object object2) {
        object = WeakTable.__getObject(object);
        object2 = WeakTable.__getObject(object2);
        boolean bl = false;
        if (object == object2) {
            bl = true;
        } else if (object instanceof IQueryInterface) {
            bl = ((IQueryInterface)object).isSame(object2);
        } else if (object2 instanceof IQueryInterface) {
            bl = ((IQueryInterface)object2).isSame(object);
        }
        return bl;
    }

    public static synchronized IEnvironment getEnvironment(String string, Object object) throws Exception {
        IEnvironment iEnvironment = (IEnvironment)__environments.get(string + object, class$com$sun$star$uno$IEnvironment == null ? (class$com$sun$star$uno$IEnvironment = UnoRuntime.class$("com.sun.star.uno.IEnvironment")) : class$com$sun$star$uno$IEnvironment);
        if (iEnvironment == null) {
            String string2 = "com.sun.star.lib.uno.environments." + string + "." + string + "_environment";
            Class<?> clazz = Class.forName(string2);
            Constructor<?> constructor = clazz.getConstructor(class$java$lang$Object == null ? (class$java$lang$Object = UnoRuntime.class$("java.lang.Object")) : class$java$lang$Object);
            iEnvironment = (IEnvironment)constructor.newInstance(object);
            iEnvironment = (IEnvironment)__environments.put(string + object, iEnvironment, class$com$sun$star$uno$IEnvironment == null ? (class$com$sun$star$uno$IEnvironment = UnoRuntime.class$("com.sun.star.uno.IEnvironment")) : class$com$sun$star$uno$IEnvironment);
        }
        return iEnvironment;
    }

    public static synchronized IBridge getBridge(IEnvironment iEnvironment, IEnvironment iEnvironment2, Object[] objectArray) throws Exception {
        String string = iEnvironment.getName() + "_" + iEnvironment2.getName();
        String string2 = iEnvironment.getName() + iEnvironment.getContext() + "_" + iEnvironment2.getName() + iEnvironment2.getContext();
        IBridge iBridge = (IBridge)__bridges.get(string2, class$com$sun$star$uno$IBridge == null ? (class$com$sun$star$uno$IBridge = UnoRuntime.class$("com.sun.star.uno.IBridge")) : class$com$sun$star$uno$IBridge);
        if (iBridge == null) {
            Class<?> clazz = null;
            String string3 = string + "_bridge";
            try {
                clazz = Class.forName(string3);
            }
            catch (ClassNotFoundException classNotFoundException) {
                string3 = "com.sun.star.lib.uno.bridges." + string + "." + string3;
                clazz = Class.forName(string3);
            }
            Class[] classArray = new Class[]{class$com$sun$star$uno$IEnvironment == null ? (class$com$sun$star$uno$IEnvironment = UnoRuntime.class$("com.sun.star.uno.IEnvironment")) : class$com$sun$star$uno$IEnvironment, class$com$sun$star$uno$IEnvironment == null ? (class$com$sun$star$uno$IEnvironment = UnoRuntime.class$("com.sun.star.uno.IEnvironment")) : class$com$sun$star$uno$IEnvironment, objectArray.getClass()};
            Constructor<?> constructor = clazz.getConstructor(classArray);
            Object[] objectArray2 = new Object[]{iEnvironment, iEnvironment2, objectArray};
            iBridge = (IBridge)constructor.newInstance(objectArray2);
            iBridge = (IBridge)__bridges.put(string2, iBridge, class$com$sun$star$uno$IBridge == null ? (class$com$sun$star$uno$IBridge = UnoRuntime.class$("com.sun.star.uno.IBridge")) : class$com$sun$star$uno$IBridge);
        }
        return iBridge;
    }

    public static IBridge getBridgeByName(String string, Object object, String string2, Object object2, Object[] objectArray) throws Exception {
        return UnoRuntime.getBridge(UnoRuntime.getEnvironment(string, object), UnoRuntime.getEnvironment(string2, object2), objectArray);
    }

    public static IBridge[] getBridges() {
        IBridge[] iBridgeArray = new IBridge[__bridges.size()];
        Enumeration enumeration = __bridges.keys();
        int n = 0;
        while (n < iBridgeArray.length) {
            iBridgeArray[n] = (IBridge)__bridges.get((String)enumeration.nextElement(), class$com$sun$star$uno$IBridge == null ? UnoRuntime.class$("com.sun.star.uno.IBridge") : class$com$sun$star$uno$IBridge);
            ++n;
        }
        return iBridgeArray;
    }

    public static IMapping getMapping(IEnvironment iEnvironment, IEnvironment iEnvironment2) throws Exception {
        IBridge iBridge = null;
        try {
            iBridge = UnoRuntime.getBridge(iEnvironment, iEnvironment2, null);
        }
        catch (ClassNotFoundException classNotFoundException) {
            iBridge = new BridgeTurner(UnoRuntime.getBridge(iEnvironment2, iEnvironment, null));
        }
        return new MappingWrapper(iBridge);
    }

    public static IMapping getMappingByName(String string, String string2) throws Exception {
        return UnoRuntime.getMapping(UnoRuntime.getEnvironment(string, null), UnoRuntime.getEnvironment(string2, null));
    }

    public static boolean reset() {
        boolean bl;
        if (!__bridges.isEmpty()) {
            System.err.println("\tdisposing bridges:");
            __bridges.reset();
        }
        System.err.println();
        if (!__environments.isEmpty()) {
            System.err.println("\tdisposing environments:");
            __environments.reset();
        }
        boolean bl2 = bl = __environments.isEmpty() && __bridges.isEmpty();
        if (!bl) {
            System.err.println();
            System.err.println("\tenvironments destroyed - passed? " + __environments.isEmpty());
            System.err.println("\bridges destroyed - passed? " + __bridges.isEmpty());
        }
        return bl;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        hostUnique = new Object().hashCode();
        lastTime = System.currentTimeMillis();
        lastCount = Short.MIN_VALUE;
        mutex = new Object();
        ONE_SECOND = 1000L;
        m_currentContexts = new Hashtable();
        s_uid_part = null;
        s_uid_part = ";java[];" + UnoRuntime.getUniqueKey();
    }
}

