/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xmlsearch.xml.qe;

import com.sun.xmlsearch.xml.qe.ConceptData;
import com.sun.xmlsearch.xml.qe.NextDocGenerator;

final class NextDocGeneratorHeap {
    private static final int InitSize = 1024;
    private int _heapSize = 0;
    private int _size = 1024;
    private NextDocGenerator[] _heap = new NextDocGenerator[1024];
    private int _free = 0;
    private boolean _nonEmpty = false;

    NextDocGeneratorHeap() {
    }

    public boolean isNonEmpty() {
        return this._nonEmpty;
    }

    public void addGenerator(NextDocGenerator nextDocGenerator) {
        if (this._free == this._size) {
            NextDocGenerator[] nextDocGeneratorArray = new NextDocGenerator[this._size *= 2];
            System.arraycopy(this._heap, 0, nextDocGeneratorArray, 0, this._free);
            this._heap = nextDocGeneratorArray;
        }
        this._heap[this._free++] = nextDocGenerator;
    }

    public void start() {
        this._heapSize = this._free;
        if (this._heapSize > 0) {
            int n = this._heapSize / 2;
            while (n >= 0) {
                this.heapify(n);
                --n;
            }
            this._nonEmpty = true;
        } else {
            this._nonEmpty = false;
        }
    }

    public void step() throws Exception {
        if (this._heap[0].next() != -1) {
            this.heapify(0);
        } else if (this._heapSize > 1) {
            this._heap[0] = this._heap[--this._heapSize];
            this.heapify(0);
        } else {
            this._nonEmpty = false;
        }
    }

    public int getDocument() {
        return this._heap[0].getDocument();
    }

    public int getConcept() {
        return this._heap[0].getConcept();
    }

    public ConceptData getTerms() {
        return this._heap[0].getTerms();
    }

    public int getQueryMask() {
        return this._heap[0].getQueryMask();
    }

    public void reset() {
        this._nonEmpty = false;
        this._free = 0;
    }

    public boolean atDocument(int n) {
        return this._nonEmpty && this._heap[0].getDocument() == n;
    }

    private void heapify(int n) {
        while (true) {
            int n2;
            int n3;
            int n4;
            int n5 = n4 = (n3 = (n2 = n + 1 << 1) - 1) < this._heapSize && this._heap[n3].smallerThan(this._heap[n]) ? n3 : n;
            if (n2 < this._heapSize && this._heap[n2].smallerThan(this._heap[n4])) {
                n4 = n2;
            }
            if (n4 == n) break;
            NextDocGenerator nextDocGenerator = this._heap[n4];
            this._heap[n4] = this._heap[n];
            this._heap[n] = nextDocGenerator;
            n = n4;
        }
    }
}

