/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xmlsearch.xml.qe;

import com.sun.xmlsearch.xml.ContextTables;
import com.sun.xmlsearch.xml.qe.Query;
import com.sun.xmlsearch.xml.qe.RoleFiller;

class ConceptData {
    protected final byte _queryNo;
    protected final byte _nColumns;
    protected final byte _role;
    protected final int _concept;
    protected final int _proximity;
    protected final double _penalty;
    protected final ContextTables _ctx;
    protected ConceptData _next;
    protected static final int ProxPerTerm = 10;

    protected ConceptData() {
        this._queryNo = 0;
        this._nColumns = 0;
        this._concept = 0;
        this._proximity = 0;
        this._role = 0;
        this._penalty = 0.0;
        this._ctx = null;
        this._next = null;
    }

    public ConceptData(int n, int n2, double d, int n3, int n4, ContextTables contextTables) {
        this._queryNo = (byte)n3;
        this._nColumns = (byte)n4;
        this._concept = n;
        this._proximity = n4 * 10;
        this._role = (byte)n2;
        this._penalty = d;
        this._ctx = contextTables;
        this._next = null;
    }

    public final int getConcept() {
        return this._concept;
    }

    public final double getPenalty() {
        return this._penalty;
    }

    public final byte getRole() {
        return this._role;
    }

    public final byte getQuery() {
        return this._queryNo;
    }

    public final byte getNColumns() {
        return this._nColumns;
    }

    public final double getScore() {
        return this._penalty;
    }

    public final ConceptData getNext() {
        return this._next;
    }

    public final int getQueryMask() {
        return (this._next != null ? this._next.getQueryMask() : 0) | 1 << this._queryNo;
    }

    public final void setNext(ConceptData conceptData) {
        this._next = conceptData;
    }

    public final boolean cEquals(ConceptData conceptData) {
        return this._concept == conceptData._concept;
    }

    public final boolean crEquals(ConceptData conceptData) {
        return this._concept == conceptData._concept && this._role == conceptData._role;
    }

    public final boolean crqEquals(ConceptData conceptData) {
        return this._concept == conceptData._concept && this._role == conceptData._role && this._queryNo == conceptData._queryNo;
    }

    public final void addLast(ConceptData conceptData) {
        if (this._next != null) {
            this._next.addLast(conceptData);
        } else {
            this._next = conceptData;
        }
    }

    public final boolean compareWith(ConceptData conceptData) {
        return this._concept < conceptData._concept || this.cEquals(conceptData) && this._role < conceptData._role || this.crEquals(conceptData) && this._penalty < conceptData._penalty;
    }

    public final void runBy(Query[] queryArray) {
        ConceptData conceptData = this;
        do {
            queryArray[conceptData._queryNo].updateEstimate(conceptData._role, conceptData._penalty);
        } while ((conceptData = conceptData._next) != null);
    }

    public void generateFillers(RoleFiller[] roleFillerArray, int n) {
        if (roleFillerArray[this._queryNo] != RoleFiller.STOP) {
            new RoleFiller(this._nColumns, this, this._role, n, this._ctx.wordContextLin(n), n + this._proximity).use(roleFillerArray, this._queryNo);
        }
        if (this._next != null) {
            this._next.generateFillers(roleFillerArray, n);
        }
    }
}

