/*************************************************************************
 *
 *  $RCSfile: CDRInputStream.java,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: hr $ $Date: 2000/09/18 15:27:53 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

package com.sun.star.lib.uno.protocols.iiop;


import java.io.IOException;
import java.io.EOFException;


public class CDRInputStream {
	public static final boolean DEBUG = false;

    protected boolean littleEndian;
    protected int index = 0;
    protected int size;
    protected byte[] buf;

    public CDRInputStream(byte[] data, int size, boolean littleEndian) {
		this.littleEndian = littleEndian;
		this.size = size;
		buf = data;
    }

	public boolean isLittleEndian() {
		return littleEndian;
	}

    private final void alignAndCheck(int align, int n) throws java.io.IOException {
		int cnt;

		cnt = ((index - 1) + align) & (~(align - 1));
		if (cnt + n <= size) {
			index = cnt;
			return;
		}

		throw new java.io.EOFException();
    }


    //
    // Marshal primitives.
    //
    public final boolean read_boolean() throws java.io.IOException
    {
		boolean result;

		result = (read_octet() != 0)? true: false;
		return result;
    }

    public final char read_ascii() throws java.io.IOException
    {
        alignAndCheck(1, 1);

        char x = (char)buf[index++];
        return x;
    }

    public final char read_unicode() throws java.io.IOException
    {
		return (char)read_short();
    }

    public final byte read_octet() throws java.io.IOException
    {
		if(DEBUG) System.err.print("#### CDRInputStream.read_octet:" + index + " x:");

		alignAndCheck(1, 1);

		byte val = buf[index++];

		if(DEBUG) System.err.println(val);

		return val;
    }

    public final short read_short() throws java.io.IOException
    {
		int b1, b2;

		alignAndCheck(2, 2);

		if (littleEndian) {
			b2 = (buf[index++] << 0) & 0x000000FF;
			b1 = (buf[index++] << 8) & 0x0000FF00;
		} else {
			b1 = (buf[index++] << 8) & 0x0000FF00;
			b2 = (buf[index++] << 0) & 0x000000FF;
		}

		return (short)(b1 | b2);
    }

    public final int read_long() throws java.io.IOException
    {
		int b1, b2, b3, b4;

		alignAndCheck(4, 4);

		if(DEBUG) System.err.print("#### CDRInputStream.read_long:" + index + " x:");

		if (littleEndian) {
			b4 = (buf[index++] << 0)  & 0x000000FF;
			b3 = (buf[index++] << 8)  & 0x0000FF00;
			b2 = (buf[index++] << 16) & 0x00FF0000;
			b1 = (buf[index++] << 24) & 0xFF000000;
		} else {
			b1 = (buf[index++] << 24) & 0xFF000000;
			b2 = (buf[index++] << 16) & 0x00FF0000;
			b3 = (buf[index++] << 8)  & 0x0000FF00;
			b4 = (buf[index++] << 0)  & 0x000000FF;
		}

		if(DEBUG) System.err.println((int)(b1 | b2 | b3 | b4));

		return (b1 | b2 | b3 | b4);
    }

    public final long read_longlong() throws java.io.IOException
    {
		long i1, i2;

		alignAndCheck(8, 8);

		if (littleEndian) {
			i2 = read_long() & 0xFFFFFFFFL;
			i1 = (long)read_long() << 32;
		} else {
			i1 = (long)read_long() << 32;
			i2 = read_long() & 0xFFFFFFFFL;
		}

		return (i1 | i2);
    }

    public final float read_float() throws java.io.IOException
    {
		return Float.intBitsToFloat(read_long());
    }

    public final double read_double() throws java.io.IOException
    {
		return Double.longBitsToDouble(read_longlong());
    }


    public final String read_asciistring() throws java.io.IOException {
		char[] b;
		String result;
		int len;

		len = read_long();

		if (len == 0)
			return "";

		b = new char[len -1];
		int i = len -1;
		while( 0 != i-- )
			b[i] = (char)(buf[index +i] & 0xFF);
		index += len;

		result = new String (b);

		if(DEBUG) System.err.println("CDRInputStream.read_asciistring:" + index + " " + len + " >" + result + "<");

		return result;
    }

    public final String read_unicodestring() throws java.io.IOException
    {
		if(DEBUG) System.err.print("#### CDRInputStream.read_unicodestring:" + index + " x:");
		
		int len;

		len = read_long();

		if (len == 0)
			return "";

        char [] szString = new char [len -1];
        int i = 0;
		if (littleEndian) 
		{
            while( --len != 0 )
            {
    			szString[i++] = (char)((buf[index++] & 0x000000FF)
                			    | ((buf[index++] << 8) & 0x0000FF00));
    		}
    	}
    	else 
    	{
            while( --len != 0 )
            {
    			szString[i++] = (char)(((buf[index++] << 8) & 0x0000FF00)
                			    | (buf[index++] & 0x000000FF) );
    		}
    	}
    	//0 char is always appended
    	index += 2;
    	String string = new String( szString );

		if(DEBUG) System.err.println(string);

		return string;
    }

    public final byte[] read_octet_array() throws java.io.IOException
    {
		if(DEBUG) System.err.println("#### CDRInputStream.read_octet_array:" + index);

        int nLen = read_long();
        byte[] b = new byte[ nLen ];
	    System.arraycopy(buf, index, b, 0, nLen);
	    index += nLen;
	    return b;
    }

    public final boolean[] read_boolean_array() throws java.io.IOException {
        int nLen = read_long();
        boolean[] value = new boolean[nLen];
		for(int i=0; i < nLen; i++) {
			value[i] = read_boolean();
		}
	    return value;
    }

    public final char[] read_unicode_array() throws java.io.IOException {
        int nLen = read_long();
        char[] value = new char[nLen];
		for(int i=0; i < nLen; i++) {
			value[i] = read_unicode();
		}
	    return value;
    }

    public final short[] read_short_array() throws java.io.IOException {
        int nLen = read_long();
        short[] value = new short[nLen];
		for(int i=0; i < nLen; i++) {
			value[i] = read_short();
		}
	    return value;
    }

    public final int[] read_long_array() throws java.io.IOException {
        int nLen = read_long();
        int[] value = new int[nLen];
		for(int i=0; i < nLen; i++) {
			value[i] = read_long();
		}
	    return value;
    }

    public final long[] read_longlong_array() throws java.io.IOException {
        int nLen = read_long();
        long[] value = new long[nLen];
		for(int i=0; i < nLen; i++) {
			value[i] = read_longlong();
		}
	    return value;
    }

    public final float[] read_float_array() throws java.io.IOException {
        int nLen = read_long();
        float[] value = new float[nLen];
		for(int i=0; i < nLen; i++) {
			value[i] = read_float();
		}
	    return value;
    }

    public final double[] read_double_array() throws java.io.IOException {
        int nLen = read_long();
        double[] value = new double[nLen];
		for(int i=0; i < nLen; i++) {
			value[i] = read_double();
		}
 	    return value;
   }

    //--------------------------------------------------------------------//
    // CDRInputStream state management.
    //

    public final void rewind() {
	index = 0;
    }

    /**
     * Are we at the end of the input stream?
     */
    public final boolean isAtEnd() {
	return index == size;
    }
}

