/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.beans;

import com.sun.star.beans.ContainerFactory;
import com.sun.star.beans.LocalOfficeWindow;
import com.sun.star.beans.NativeService;
import com.sun.star.beans.OfficeConnection;
import com.sun.star.beans.OfficeWindow;
import com.sun.star.beans.XPropertySet;
import com.sun.star.bridge.XUnoUrlResolver;
import com.sun.star.comp.helper.Bootstrap;
import com.sun.star.connection.ConnectionSetupException;
import com.sun.star.connection.NoConnectException;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.lang.XEventListener;
import com.sun.star.lib.uno.helper.UnoUrl;
import com.sun.star.lib.util.NativeLibraryLoader;
import com.sun.star.uno.RuntimeException;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XComponentContext;
import java.awt.Container;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;

public class LocalOfficeConnection
implements OfficeConnection {
    public static final String OFFICE_APP_NAME = "soffice";
    public static final String OFFICE_LIB_NAME = "officebean";
    public static final String OFFICE_ID_SUFFIX = "_Office";
    private Process mProcess;
    private ContainerFactory mContainerFactory;
    private XComponentContext mContext;
    private String mURL;
    private String mProgramPath;
    private String mConnType;
    private String mPipe;
    private String mPort;
    private String mProtocol;
    private String mInitialObject;
    private List mComponents = new Vector();
    static /* synthetic */ Class class$com$sun$star$bridge$XUnoUrlResolver;
    static /* synthetic */ Class class$com$sun$star$beans$XPropertySet;
    static /* synthetic */ Class class$com$sun$star$uno$XComponentContext;

    public LocalOfficeConnection() {
        String string;
        try {
            string = System.getProperty("user.name") + OFFICE_ID_SUFFIX;
            this.setUnoUrl("uno:pipe,name=" + string + ";urp;StarOffice.ServiceManager");
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        string = this.getProgramPath() + File.separator + System.mapLibraryName(OFFICE_LIB_NAME);
        System.load(string);
    }

    public void setUnoUrl(String string) throws MalformedURLException {
        this.mURL = null;
        String string2 = "uno:localoffice";
        if (string.startsWith(string2)) {
            this.parseUnoUrlWithOfficePath(string, string2);
        } else {
            try {
                UnoUrl unoUrl = UnoUrl.parseUnoUrl((String)string);
                this.mProgramPath = null;
                this.mConnType = unoUrl.getConnection();
                this.mPipe = (String)unoUrl.getConnectionParameters().get("pipe");
                this.mPort = (String)unoUrl.getConnectionParameters().get("port");
                this.mProtocol = unoUrl.getProtocol();
                this.mInitialObject = unoUrl.getRootOid();
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new MalformedURLException("Invalid UNO connection URL.");
            }
        }
        this.mURL = string;
    }

    public void setContainerFactory(ContainerFactory containerFactory) {
        this.mContainerFactory = containerFactory;
    }

    public XComponentContext getComponentContext() {
        if (this.mContext == null) {
            this.mContext = this.connect();
        }
        return this.mContext;
    }

    public OfficeWindow createOfficeWindow(Container container) {
        return new LocalOfficeWindow(this);
    }

    public void dispose() {
        Iterator iterator = this.mComponents.iterator();
        while (iterator.hasNext()) {
            try {
                ((XEventListener)iterator.next()).disposing(null);
            }
            catch (java.lang.RuntimeException runtimeException) {
                // empty catch block
            }
        }
        this.mComponents.clear();
        this.mContainerFactory = null;
        this.mContext = null;
    }

    public void addEventListener(XEventListener xEventListener) {
        this.mComponents.add(xEventListener);
    }

    public void removeEventListener(XEventListener xEventListener) {
        this.mComponents.remove(xEventListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private XComponentContext connect() {
        try {
            block14: {
                var1_1 = Bootstrap.createInitialComponentContext(null);
                var2_3 = var1_1.getServiceManager();
                var3_5 = var2_3.createInstanceWithContext("com.sun.star.bridge.UnoUrlResolver", var1_1);
                var4_7 = (XUnoUrlResolver)UnoRuntime.queryInterface((Class)(LocalOfficeConnection.class$com$sun$star$bridge$XUnoUrlResolver == null ? (LocalOfficeConnection.class$com$sun$star$bridge$XUnoUrlResolver = LocalOfficeConnection.class$("com.sun.star.bridge.XUnoUrlResolver")) : LocalOfficeConnection.class$com$sun$star$bridge$XUnoUrlResolver), (Object)var3_5);
                var5_9 = null;
                try {
                    try {
                        var5_9 = var4_7.resolve(this.mURL);
                    }
                    catch (NoConnectException var6_14) {
                        var7_16 = new OfficeService();
                        var7_16.startupService();
                        var8_17 = System.currentTimeMillis() + (long)(1000 * var7_16.getStartupTime());
                        ** while (var5_9 == null)
                    }
                    var12_11 = null;
                    break block14;
lbl-1000:
                    // 1 sources

                    {
                        try {
                            Thread.currentThread();
                            Thread.sleep(500L);
                            var5_9 = var4_7.resolve(this.mURL);
                            continue;
                        }
                        catch (NoConnectException var10_19) {
                            if (System.currentTimeMillis() <= var8_17) continue;
                            throw var10_19;
                        }
                    }
                }
                catch (Throwable var11_20) {
                    var12_13 = null;
                    throw var11_20;
                }
lbl31:
                // 1 sources

                var12_12 = null;
                {
                }
            }
            if (null != var5_9) {
                var6_15 = (XPropertySet)UnoRuntime.queryInterface((Class)(LocalOfficeConnection.class$com$sun$star$beans$XPropertySet == null ? (LocalOfficeConnection.class$com$sun$star$beans$XPropertySet = LocalOfficeConnection.class$("com.sun.star.beans.XPropertySet")) : LocalOfficeConnection.class$com$sun$star$beans$XPropertySet), (Object)var5_9);
                var7_16 = var6_15.getPropertyValue("DefaultContext");
                var8_18 = (XComponentContext)UnoRuntime.queryInterface((Class)(LocalOfficeConnection.class$com$sun$star$uno$XComponentContext == null ? (LocalOfficeConnection.class$com$sun$star$uno$XComponentContext = LocalOfficeConnection.class$("com.sun.star.uno.XComponentContext")) : LocalOfficeConnection.class$com$sun$star$uno$XComponentContext), (Object)var7_16);
                return var8_18;
            }
        }
        catch (NoConnectException var1_2) {
            System.out.println("Couldn't connect to remote server");
            System.out.println(var1_2.getMessage());
        }
        catch (ConnectionSetupException var2_4) {
            System.out.println("Couldn't access necessary local resource to establish the interprocess connection");
            System.out.println(var2_4.getMessage());
        }
        catch (IllegalArgumentException var3_6) {
            System.out.println("uno-url is syntactical illegal ( " + this.mURL + " )");
            System.out.println(var3_6.getMessage());
        }
        catch (RuntimeException var4_8) {
            System.out.println("--- RuntimeException:");
            System.out.println(var4_8.getMessage());
            var4_8.printStackTrace();
            System.out.println("--- end.");
            throw var4_8;
        }
        catch (Exception var5_10) {
            System.out.println("java.lang.Exception: ");
            System.out.println(var5_10);
            var5_10.printStackTrace();
            System.out.println("--- end.");
            throw new RuntimeException(var5_10.toString());
        }
        return null;
    }

    private String getProgramPath() {
        if (this.mProgramPath == null) {
            File file;
            String string = OFFICE_APP_NAME;
            String string2 = System.getProperty("os.name");
            if (string2.startsWith("Windows")) {
                string = "soffice.exe";
            }
            if ((file = NativeLibraryLoader.getResource((ClassLoader)this.getClass().getClassLoader(), (String)string)) != null) {
                this.mProgramPath = file.getParent();
            }
            if (this.mProgramPath == null) {
                this.mProgramPath = "";
            }
        }
        return this.mProgramPath;
    }

    private void parseUnoUrlWithOfficePath(String string, String string2) throws MalformedURLException {
        int n = string.indexOf(";urp;StarOffice.NamingService");
        if (n < 0) {
            throw new MalformedURLException("Invalid UNO connection URL.");
        }
        String string3 = string.substring(string2.length(), n + 1);
        String string4 = null;
        String string5 = null;
        String string6 = null;
        int n2 = 0;
        StringBuffer stringBuffer = new StringBuffer();
        n = 0;
        while (n < string3.length()) {
            char c = string3.charAt(n);
            block0 : switch (n2) {
                case 0: {
                    switch (c) {
                        case ',': {
                            stringBuffer.delete(0, stringBuffer.length());
                            n2 = 1;
                            break block0;
                        }
                        case ';': {
                            n2 = 7;
                            break block0;
                        }
                    }
                    stringBuffer.delete(0, stringBuffer.length());
                    stringBuffer.append(c);
                    n2 = 1;
                    break;
                }
                case 1: {
                    switch (c) {
                        case ' ': 
                        case '=': {
                            string4 = stringBuffer.toString();
                            n2 = c == ' ' ? 2 : 3;
                            break block0;
                        }
                        case ',': 
                        case ';': {
                            n2 = -6;
                            break block0;
                        }
                    }
                    stringBuffer.append(c);
                    break;
                }
                case 2: {
                    switch (c) {
                        case '=': {
                            n2 = 3;
                            break block0;
                        }
                        case ' ': {
                            break block0;
                        }
                    }
                    n2 = -1;
                    break;
                }
                case 3: {
                    switch (c) {
                        case ' ': {
                            break block0;
                        }
                    }
                    stringBuffer.delete(0, stringBuffer.length());
                    stringBuffer.append(c);
                    n2 = 4;
                    break;
                }
                case 4: {
                    switch (c) {
                        case ' ': 
                        case ',': 
                        case ';': {
                            --n;
                            n2 = 5;
                            if (string4.equals("path")) {
                                if (string5 == null) {
                                    string5 = stringBuffer.toString();
                                } else {
                                    n2 = -3;
                                }
                            } else if (string4.equals("pipe")) {
                                if (string6 == null) {
                                    string6 = stringBuffer.toString();
                                } else {
                                    n2 = -4;
                                }
                            } else {
                                n2 = -2;
                            }
                            stringBuffer.delete(0, stringBuffer.length());
                            break block0;
                        }
                    }
                    stringBuffer.append(c);
                    break;
                }
                case 5: {
                    switch (c) {
                        case ' ': {
                            break block0;
                        }
                        case ',': {
                            n2 = 6;
                            break block0;
                        }
                        case ';': {
                            n2 = 7;
                            break block0;
                        }
                    }
                    n2 = -5;
                    break;
                }
                case 6: {
                    switch (c) {
                        case ' ': {
                            break block0;
                        }
                    }
                    stringBuffer.delete(0, stringBuffer.length());
                    stringBuffer.append(c);
                    n2 = 1;
                    break;
                }
                default: {
                    throw new MalformedURLException("Invalid UNO connection URL.");
                }
            }
            ++n;
        }
        if (n2 != 7) {
            throw new MalformedURLException("Invalid UNO connection URL.");
        }
        if (string5 != null) {
            this.mProgramPath = string5;
        }
        if (string6 != null) {
            this.mPipe = string6;
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class OfficeService
    implements NativeService {
        private OfficeService() {
        }

        public String getIdentifier() {
            return LocalOfficeConnection.this.mPipe == null ? System.getProperty("user.name") + LocalOfficeConnection.OFFICE_ID_SUFFIX : LocalOfficeConnection.this.mPipe;
        }

        public void startupService() throws IOException {
            String[] stringArray = new String[4];
            stringArray[0] = new File(LocalOfficeConnection.this.getProgramPath(), LocalOfficeConnection.OFFICE_APP_NAME).getPath();
            stringArray[1] = "-nologo";
            stringArray[2] = "-nodefault";
            if (LocalOfficeConnection.this.mConnType.equals("pipe")) {
                stringArray[3] = "-accept=pipe,name=" + this.getIdentifier() + ";" + LocalOfficeConnection.this.mProtocol + ";" + LocalOfficeConnection.this.mInitialObject;
            } else if (LocalOfficeConnection.this.mConnType.equals("socket")) {
                stringArray[3] = "-accept=socket,port=" + LocalOfficeConnection.this.mPort + ";urp";
            } else {
                throw new IOException("not connection specified");
            }
            LocalOfficeConnection.this.mProcess = Runtime.getRuntime().exec(stringArray);
            if (LocalOfficeConnection.this.mProcess == null) {
                throw new java.lang.RuntimeException("cannot start soffice: " + stringArray);
            }
        }

        public int getStartupTime() {
            return 60;
        }
    }
}

