/*
 * Decompiled with CFR 0.152.
 */
package org.openide.text;

import java.awt.Color;
import java.awt.Font;
import java.awt.font.TextAttribute;
import java.io.Serializable;
import java.text.AttributedCharacterIterator;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class AttributedCharacters {
    protected char[] chars = new char[10];
    protected Font[] fonts = new Font[10];
    protected Color[] colors = new Color[10];
    protected int[] runStart = new int[10];
    protected int[] runLimit = new int[10];
    protected int current = -1;

    public void append(char c, Font font, Color color) {
        if (font == null) {
            return;
        }
        if (++this.current == this.chars.length) {
            char[] cArray = new char[2 * this.chars.length];
            Font[] fontArray = new Font[2 * this.chars.length];
            Color[] colorArray = new Color[2 * this.chars.length];
            int[] nArray = new int[2 * this.chars.length];
            int[] nArray2 = new int[2 * this.chars.length];
            System.arraycopy(this.chars, 0, cArray, 0, this.chars.length);
            System.arraycopy(this.fonts, 0, fontArray, 0, this.chars.length);
            System.arraycopy(this.colors, 0, colorArray, 0, this.chars.length);
            System.arraycopy(this.runStart, 0, nArray, 0, this.chars.length);
            System.arraycopy(this.runLimit, 0, nArray2, 0, this.chars.length);
            this.chars = cArray;
            this.fonts = fontArray;
            this.colors = colorArray;
            this.runStart = nArray;
            this.runLimit = nArray2;
        }
        this.chars[this.current] = c;
        this.fonts[this.current] = font;
        this.colors[this.current] = color;
        if (this.current != 0) {
            int n = this.current - 1;
            if (this.fonts[n].equals(font) && this.colors[n].equals(color)) {
                this.runStart[this.current] = this.runStart[n];
                this.runLimit[this.runStart[this.current]] = this.current;
            } else {
                this.runLimit[this.current] = this.current;
                this.runStart[this.current] = this.current;
            }
        }
    }

    public void append(char[] cArray, Font font, Color color) {
        int n;
        if (cArray == null || cArray.length == 0 || font == null || color == null) {
            return;
        }
        if (++this.current + cArray.length >= this.chars.length) {
            n = Math.max(this.current + cArray.length, 2 * this.chars.length);
            char[] cArray2 = new char[n];
            Font[] fontArray = new Font[n];
            Color[] colorArray = new Color[n];
            int[] nArray = new int[n];
            int[] nArray2 = new int[n];
            System.arraycopy(this.chars, 0, cArray2, 0, this.chars.length);
            System.arraycopy(this.fonts, 0, fontArray, 0, this.fonts.length);
            System.arraycopy(this.colors, 0, colorArray, 0, this.chars.length);
            System.arraycopy(this.runStart, 0, nArray, 0, this.chars.length);
            System.arraycopy(this.runLimit, 0, nArray2, 0, this.chars.length);
            this.chars = cArray2;
            this.fonts = fontArray;
            this.colors = colorArray;
            this.runStart = nArray;
            this.runLimit = nArray2;
        }
        System.arraycopy(cArray, 0, this.chars, this.current, cArray.length);
        n = 0;
        while (n < cArray.length) {
            this.fonts[n + this.current] = font;
            this.colors[n + this.current] = color;
            ++n;
        }
        int n2 = this.current - 1;
        int n3 = this.current + cArray.length - 1;
        if (n2 < 0) {
            this.runLimit[0] = n3;
        } else {
            int n4;
            if (this.fonts[n2].equals(font) && this.colors[n2].equals(color)) {
                n4 = this.runStart[n3] = this.runStart[n2];
                this.runLimit[this.runStart[n3]] = n3;
            } else {
                this.runLimit[this.current] = n3;
                this.runStart[this.current] = this.current;
                this.runStart[n3] = this.current;
                n4 = this.current;
            }
            int n5 = this.current + 1;
            while (n5 < n3) {
                this.runStart[n5] = n4;
                ++n5;
            }
        }
        this.current = n3;
    }

    public AttributedCharacterIterator iterator() {
        int n = this.current + 1;
        char[] cArray = new char[n];
        Font[] fontArray = new Font[n];
        Color[] colorArray = new Color[n];
        int[] nArray = new int[n];
        int[] nArray2 = new int[n];
        System.arraycopy(this.runStart, 0, nArray, 0, n);
        System.arraycopy(this.runLimit, 0, nArray2, 0, n);
        System.arraycopy(this.chars, 0, cArray, 0, n);
        System.arraycopy(this.fonts, 0, fontArray, 0, n);
        System.arraycopy(this.colors, 0, colorArray, 0, n);
        AttributedCharacterIteratorImpl attributedCharacterIteratorImpl = new AttributedCharacterIteratorImpl(cArray, fontArray, colorArray, nArray, nArray2);
        return attributedCharacterIteratorImpl;
    }

    public static class AttributedCharacterIteratorImpl
    implements AttributedCharacterIterator {
        protected int current;
        protected char[] chars;
        protected Font[] fonts;
        protected Color[] colors;
        protected int[] runStart;
        protected int[] runLimit;
        protected Set singleton;

        public AttributedCharacterIteratorImpl(char[] cArray, Font[] fontArray, Color[] colorArray, int[] nArray, int[] nArray2) {
            this.chars = cArray;
            this.fonts = fontArray;
            this.colors = colorArray;
            this.runStart = nArray;
            this.runLimit = nArray2;
        }

        public Object clone() {
            try {
                return super.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                return null;
            }
        }

        public char current() {
            if (this.current >= this.chars.length) {
                return '\uffff';
            }
            return this.chars[this.current];
        }

        public char first() {
            this.current = 0;
            if (this.current >= this.chars.length) {
                return '\uffff';
            }
            return this.chars[this.current];
        }

        public int getBeginIndex() {
            return 0;
        }

        public int getEndIndex() {
            return this.chars.length;
        }

        public int getIndex() {
            return this.current;
        }

        public char last() {
            int n = this.getEndIndex();
            if (n == 0) {
                return '\uffff';
            }
            this.current = n - 1;
            return this.chars[this.current];
        }

        public char next() {
            if (this.current >= this.getEndIndex() - 1) {
                return '\uffff';
            }
            return this.chars[++this.current];
        }

        public char previous() {
            if (this.current == 0) {
                return '\uffff';
            }
            return this.chars[--this.current];
        }

        public char setIndex(int n) {
            if (n < 0) {
                throw new IllegalArgumentException();
            }
            if (n == this.getEndIndex()) {
                this.current = this.getEndIndex();
                return '\uffff';
            }
            this.current = n;
            return this.chars[this.current];
        }

        public Set getAllAttributeKeys() {
            if (this.singleton == null) {
                HashSet<TextAttribute> hashSet = new HashSet<TextAttribute>(4);
                hashSet.add(TextAttribute.FONT);
                hashSet.add(TextAttribute.FOREGROUND);
                this.singleton = Collections.unmodifiableSet(hashSet);
            }
            return this.singleton;
        }

        public Object getAttribute(AttributedCharacterIterator.Attribute attribute) {
            if (attribute == TextAttribute.FONT) {
                return this.fonts[this.getIndex()];
            }
            if (attribute == TextAttribute.FOREGROUND) {
                return this.colors[this.getIndex()];
            }
            return null;
        }

        public Map getAttributes() {
            HashMap<TextAttribute, Serializable> hashMap = new HashMap<TextAttribute, Serializable>(1);
            hashMap.put(TextAttribute.FONT, this.fonts[this.getIndex()]);
            hashMap.put(TextAttribute.FOREGROUND, this.colors[this.getIndex()]);
            return hashMap;
        }

        public int getRunLimit() {
            return this.runLimit[this.runStart[this.getIndex()]] + 1;
        }

        public int getRunLimit(AttributedCharacterIterator.Attribute attribute) {
            if (attribute != TextAttribute.FONT && attribute != TextAttribute.FOREGROUND) {
                return this.getEndIndex();
            }
            return this.getRunLimit();
        }

        public int getRunLimit(Set set) {
            if (set.contains(TextAttribute.FONT) || set.contains(TextAttribute.FOREGROUND)) {
                return this.getRunLimit();
            }
            return this.getEndIndex();
        }

        public int getRunStart() {
            return this.runStart[this.getIndex()];
        }

        public int getRunStart(AttributedCharacterIterator.Attribute attribute) {
            if (attribute != TextAttribute.FONT && attribute != TextAttribute.FOREGROUND) {
                return 0;
            }
            return this.getRunStart();
        }

        public int getRunStart(Set set) {
            if (set.contains(TextAttribute.FONT) || set.contains(TextAttribute.FOREGROUND)) {
                return this.getRunStart();
            }
            return 0;
        }
    }
}

