/*
 * Decompiled with CFR 0.152.
 */
package org.openide.execution;

import java.io.FilePermission;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import java.net.UnknownServiceException;
import java.security.Permission;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.Repository;
import org.openide.util.Lookup;

public final class NbfsURLConnection
extends URLConnection {
    public static final String PROTOCOL = "nbfs";
    private static final char SEPARATOR = '/';
    private URLConnection del;
    static /* synthetic */ Class class$org$openide$filesystems$Repository;

    public NbfsURLConnection(URL uRL) {
        super(uRL);
    }

    public static URL encodeFileObject(FileObject fileObject) throws FileStateInvalidException {
        return fileObject.getURL();
    }

    public static FileObject decodeURL(URL uRL) {
        int n;
        if (!uRL.getProtocol().equals(PROTOCOL)) {
            return null;
        }
        String string = uRL.getFile();
        if (string.startsWith("/")) {
            string = string.substring(1);
        }
        if ((n = string.indexOf(47)) == -1) {
            return null;
        }
        String string2 = NbfsURLConnection.decodeFileSystemName(string.substring(0, n));
        if ((string = NbfsURLConnection.normalizePath(string.substring(n))) == null) {
            return null;
        }
        Repository repository = (Repository)Lookup.getDefault().lookup(class$org$openide$filesystems$Repository == null ? (class$org$openide$filesystems$Repository = NbfsURLConnection.class$("org.openide.filesystems.Repository")) : class$org$openide$filesystems$Repository);
        if (repository == null) {
            return null;
        }
        FileSystem fileSystem = repository.findFileSystem(string2);
        return fileSystem == null ? null : fileSystem.findResource(string);
    }

    private static String normalizePath(String string) {
        CharSequence charSequence;
        if (string == null) {
            return null;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, "/");
        LinkedList<CharSequence> linkedList = new LinkedList<CharSequence>();
        while (stringTokenizer.hasMoreTokens()) {
            charSequence = stringTokenizer.nextToken();
            if (".".equals(charSequence)) continue;
            if ("..".equals(charSequence)) {
                try {
                    linkedList.removeLast();
                    continue;
                }
                catch (NoSuchElementException noSuchElementException) {
                    return null;
                }
            }
            linkedList.add(charSequence);
        }
        charSequence = new StringBuffer(string.length());
        Iterator iterator = linkedList.iterator();
        while (iterator.hasNext()) {
            ((StringBuffer)charSequence).append('/');
            ((StringBuffer)charSequence).append(iterator.next());
        }
        return ((StringBuffer)charSequence).toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connect() throws IOException {
        if (this.del != null) {
            return;
        }
        NbfsURLConnection nbfsURLConnection = this;
        synchronized (nbfsURLConnection) {
            if (this.del != null) {
                return;
            }
            FileObject fileObject = NbfsURLConnection.decodeURL(this.url);
            if (fileObject == null) {
                throw new IOException("Cannot find: " + this.url);
            }
            this.del = fileObject.getURL().openConnection();
        }
    }

    public InputStream getInputStream() throws IOException, UnknownServiceException {
        this.connect();
        return this.del.getInputStream();
    }

    public OutputStream getOutputStream() throws IOException, UnknownServiceException {
        this.connect();
        return this.del.getOutputStream();
    }

    public int getContentLength() {
        try {
            this.connect();
            return this.del.getContentLength();
        }
        catch (IOException iOException) {
            return 0;
        }
    }

    public String getHeaderField(String string) {
        try {
            this.connect();
            return this.del.getHeaderField(string);
        }
        catch (IOException iOException) {
            return super.getHeaderField(string);
        }
    }

    private static String decodeFileSystemName(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        int n2 = string.length();
        while (n < n2) {
            char c;
            if ((c = string.charAt(n++)) == 'Q' && n < n2) {
                switch (string.charAt(n++)) {
                    case 'B': {
                        stringBuffer.append('/');
                        break;
                    }
                    case 'C': {
                        stringBuffer.append(':');
                        break;
                    }
                    case 'D': {
                        stringBuffer.append('\\');
                        break;
                    }
                    case 'E': {
                        stringBuffer.append('#');
                        break;
                    }
                    default: {
                        stringBuffer.append('Q');
                        break;
                    }
                }
                continue;
            }
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }

    public Permission getPermission() throws IOException {
        if (this.del != null) {
            return this.del.getPermission();
        }
        return new FilePermission("<<ALL FILES>>", "read");
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

