/*
 * Decompiled with CFR 0.152.
 */
package stardiv.controller;

import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Panel;
import java.awt.TextArea;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import stardiv.controller.Console;
import stardiv.controller.PropertyEditor;
import stardiv.controller.ThreadDialog;

class DebugDialog
extends Dialog {
    private TextArea aTextArea;
    private Frame pFrame;
    private PropertyEditor propertyEditor;
    private ThreadDialog threadDialog;
    private boolean instractionTracing = false;
    private boolean methodTracing = false;

    public DebugDialog(Frame frame) {
        this(frame, "Java Console");
    }

    public DebugDialog(Frame frame, String string) {
        super(frame, string);
        this.pFrame = frame;
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                Console.showConsole(false);
            }
        });
        this.aTextArea = new TextArea();
        this.aTextArea.setEditable(false);
        Button button = new Button("Clear");
        Button button2 = new Button("Close");
        Button button3 = new Button("Perform GC");
        Button button4 = new Button("Show Memory");
        Button button5 = new Button("Property Editor");
        Button button6 = new Button("Threads");
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                String string = actionEvent.getActionCommand();
                if (string.equals("Clear")) {
                    DebugDialog.this.clear();
                } else if (string.equals("Close")) {
                    Console.showConsole(false);
                } else if (string.equals("Perform GC")) {
                    Runtime runtime = Runtime.getRuntime();
                    long l = runtime.freeMemory();
                    System.out.println();
                    System.out.println("performing garbage collection ...");
                    System.gc();
                    long l2 = runtime.freeMemory();
                    long l3 = (l2 - l) / 1024L;
                    System.out.println("... " + l3 + " KByte freed");
                } else if (string.equals("Show Memory")) {
                    Runtime runtime = Runtime.getRuntime();
                    System.out.println();
                    System.out.println(runtime.totalMemory() / 1024L + " kBytes total amount of memory in the Java Virtual Machine");
                    System.out.println(runtime.freeMemory() / 1024L + " kBytes amount of free memory in the system");
                } else if (string.equals("Property Editor")) {
                    if (DebugDialog.this.propertyEditor == null) {
                        Frame frame = new Frame();
                        DebugDialog.this.propertyEditor = new PropertyEditor(frame);
                    }
                    if (!DebugDialog.this.propertyEditor.isVisible()) {
                        DebugDialog.this.propertyEditor.setVisible(true);
                    } else {
                        DebugDialog.this.propertyEditor.toFront();
                    }
                } else if (string.equals("Threads")) {
                    if (DebugDialog.this.threadDialog == null) {
                        Frame frame = new Frame();
                        DebugDialog.this.threadDialog = new ThreadDialog(frame);
                    }
                    if (!DebugDialog.this.threadDialog.isVisible()) {
                        DebugDialog.this.threadDialog.setVisible(true);
                    } else {
                        DebugDialog.this.threadDialog.toFront();
                    }
                } else {
                    System.err.println("unknown command : " + string);
                }
            }
        };
        button.addActionListener(actionListener);
        button2.addActionListener(actionListener);
        button3.addActionListener(actionListener);
        button4.addActionListener(actionListener);
        button5.addActionListener(actionListener);
        button6.addActionListener(actionListener);
        Panel panel = new Panel();
        panel.setLayout(new GridLayout(2, 0));
        panel.add(button3);
        panel.add(button4);
        panel.add(button5);
        panel.add(button6);
        panel.add(button);
        panel.add(button2);
        this.setLayout(new BorderLayout());
        this.add("Center", this.aTextArea);
        this.add("South", panel);
        this.pack();
    }

    public void clear() {
        this.aTextArea.setText("");
        Console.aOutput = "";
    }

    public void append(String string) {
        if (this.isVisible()) {
            this.aTextArea.append(string);
        }
    }

    public void setText(String string) {
        if (this.isVisible()) {
            this.aTextArea.setText(string);
            this.aTextArea.select(string.length(), string.length());
        }
    }
}

