/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.lib.uno.protocols.urp;

import com.sun.star.lib.uno.environments.remote.IMarshal;
import com.sun.star.lib.uno.environments.remote.IMessage;
import com.sun.star.lib.uno.environments.remote.IUnmarshal;
import com.sun.star.lib.uno.environments.remote.Protocol;
import com.sun.star.lib.uno.environments.remote.ThreadId;
import com.sun.star.lib.uno.protocols.urp.Marshal;
import com.sun.star.lib.uno.protocols.urp.Unmarshal;
import com.sun.star.lib.uno.typedesc.TypeDescription;
import com.sun.star.uno.IBridge;
import com.sun.star.uno.IMethodDescription;
import com.sun.star.uno.ITypeDescription;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Array;

public class urp
extends Protocol {
    public static final boolean DEBUG = false;
    private static final ITypeDescription[] __emptyITypeDescArray = new ITypeDescription[0];
    private static final short __cache_size = 256;
    protected IBridge _iBridge;
    private String _in_oid;
    private ITypeDescription _in_interface;
    private ThreadId _in_threadId;
    private String _out_oid;
    private ITypeDescription _out_interface;
    private ThreadId _out_threadId;
    private int _message_count;
    private boolean _ignore_cache;
    private Marshal _marshal;
    private Unmarshal _unmarshal;
    private String[] _operationContainer = new String[1];
    private Object[][] _paramsContainer = new Object[1][];
    private boolean[] _synchronContainer = new boolean[1];
    private boolean[] _mustReplyContainer = new boolean[1];
    private boolean[] _exceptionContainer = new boolean[1];
    private static final byte BIG_HEADER = -128;
    private static final byte REQUEST = 64;
    private static final byte NEWTYPE = 32;
    private static final byte NEWOID = 16;
    private static final byte NEWTID = 8;
    private static final byte LONGMETHODID = 4;
    private static final byte IGNORECACHE = 2;
    private static final byte MOREFLAGS = 1;
    private static final byte MUSTREPLY = -128;
    private static final byte SYNCHRONOUSE = 64;
    private static final byte DIR_MID = 64;
    private static final byte EXCEPTION = 32;

    public urp(IBridge iBridge) {
        this._iBridge = iBridge;
        this._marshal = new Marshal(iBridge, 256);
        this._unmarshal = new Unmarshal(iBridge, 256);
    }

    public String getName() {
        return "urp";
    }

    private Object readReply(byte by, boolean[] blArray) {
        if ((by & 8) != 0) {
            this._in_threadId = this._unmarshal.readThreadId();
        }
        Object[] objectArray = (Object[])this.removePendingRequest(this._in_threadId);
        Object[] objectArray2 = (Object[])objectArray[0];
        ITypeDescription[] iTypeDescriptionArray = (ITypeDescription[])objectArray[1];
        ITypeDescription iTypeDescription = (ITypeDescription)objectArray[2];
        boolean bl = blArray[0] = (by & 0x20) != 0;
        if (blArray[0]) {
            iTypeDescriptionArray = __emptyITypeDescArray;
            iTypeDescription = TypeDescription.__any_TypeDescription;
        }
        Object object = null;
        if (iTypeDescription != null) {
            object = this._unmarshal.readObject(iTypeDescription);
        }
        int n = 0;
        while (n < iTypeDescriptionArray.length) {
            if (iTypeDescriptionArray[n] != null) {
                Array.set(objectArray2[n], 0, this._unmarshal.readObject(iTypeDescriptionArray[n].getComponentType()));
            }
            ++n;
        }
        return object;
    }

    private Object[] readParams(IMethodDescription iMethodDescription) {
        ITypeDescription[] iTypeDescriptionArray = iMethodDescription.getInSignature();
        ITypeDescription[] iTypeDescriptionArray2 = iMethodDescription.getOutSignature();
        Object[] objectArray = new Object[iTypeDescriptionArray.length];
        int n = 0;
        while (n < objectArray.length) {
            if (iTypeDescriptionArray[n] != null) {
                if (iTypeDescriptionArray2[n] != null) {
                    Object object = Array.newInstance(iTypeDescriptionArray2[n].getComponentType().getZClass(), 1);
                    Array.set(object, 0, this._unmarshal.readObject(iTypeDescriptionArray2[n].getComponentType()));
                    objectArray[n] = object;
                } else {
                    objectArray[n] = this._unmarshal.readObject(iTypeDescriptionArray[n]);
                }
            } else {
                objectArray[n] = Array.newInstance(iTypeDescriptionArray2[n].getComponentType().getZClass(), 1);
            }
            ++n;
        }
        return objectArray;
    }

    private void readShortRequest(byte by, String[] stringArray, Object[][] objectArray, boolean[] blArray) {
        ++this._requestsRecieved;
        int n = 0;
        n = (by & 0x40) != 0 ? ((by & 0x3F) << 8 | this._unmarshal.readbyte()) & 0x3FFF : by & 0x3F;
        IMethodDescription iMethodDescription = this._in_interface.getMethodDescription(n);
        stringArray[0] = iMethodDescription.getName();
        blArray[0] = !iMethodDescription.isOneway();
        objectArray[0] = this.readParams(iMethodDescription);
        if (blArray[0]) {
            this.putPendingReply(this._in_threadId, new Object[]{objectArray[0], iMethodDescription.getOutSignature(), iMethodDescription.getReturnSignature()});
        }
    }

    private void readLongRequest(byte by, String[] stringArray, Object[][] objectArray, boolean[] blArray, boolean[] blArray2) {
        short s;
        ++this._requestsRecieved;
        if ((by & 1) != 0) {
            s = this._unmarshal.readbyte();
            blArray2[0] = (s & 0xFFFFFF80) != 0;
            blArray[0] = (s & 0x40) != 0;
        }
        s = 0;
        s = (by & 4) != 0 ? this._unmarshal.readshort() : (short)this._unmarshal.readbyte();
        if ((by & 0x20) != 0) {
            this._in_interface = this._unmarshal.readTypeDescription();
        }
        IMethodDescription iMethodDescription = this._in_interface.getMethodDescription((int)s);
        if ((by & 1) == 0) {
            boolean bl = blArray[0] = !iMethodDescription.isOneway();
        }
        if ((by & 0x10) != 0) {
            this._in_oid = this._unmarshal.readOid();
        }
        if ((by & 8) != 0) {
            this._in_threadId = this._unmarshal.readThreadId();
        }
        this._ignore_cache = (by & 2) != 0;
        stringArray[0] = iMethodDescription.getName();
        objectArray[0] = this.readParams(iMethodDescription);
        if (blArray[0]) {
            this.putPendingReply(this._in_threadId, new Object[]{objectArray[0], iMethodDescription.getOutSignature(), iMethodDescription.getReturnSignature()});
        }
    }

    private Object readMessage(String[] stringArray, Object[] objectArray, boolean[] blArray, boolean[] blArray2, boolean[] blArray3) {
        byte by = this._unmarshal.readbyte();
        Object object = null;
        if ((by & 0xFFFFFF80) != 0) {
            if ((by & 0x40) != 0) {
                this.readLongRequest(by, stringArray, (Object[][])objectArray, blArray, blArray2);
            } else {
                object = this.readReply(by, blArray3);
            }
        } else {
            this.readShortRequest(by, stringArray, (Object[][])objectArray, blArray);
        }
        if (blArray[0]) {
            blArray2[0] = true;
        }
        return object;
    }

    public void writeRequest(String string, ITypeDescription iTypeDescription, String string2, ThreadId threadId, Object[] objectArray, Boolean[] booleanArray, Boolean[] booleanArray2) {
        ++this._requestsSend;
        ++this._message_count;
        IMethodDescription iMethodDescription = iTypeDescription.getMethodDescription(string2);
        byte by = 0;
        boolean bl = false;
        if (this._out_oid == null || !string.equals(this._out_oid)) {
            by = (byte)(by | 0x10);
            this._out_oid = string;
            bl = true;
        } else {
            string = null;
        }
        if (this._out_interface == null || !this._out_interface.equals(iTypeDescription)) {
            by = (byte)(by | 0x20);
            this._out_interface = iTypeDescription;
            bl = true;
        } else {
            iTypeDescription = null;
        }
        if (this._out_threadId == null || !this._out_threadId.equals(threadId)) {
            by = (byte)(by | 8);
            this._out_threadId = threadId;
            bl = true;
        } else {
            threadId = null;
        }
        boolean bl2 = false;
        if (booleanArray[0] != null) {
            if (iMethodDescription.isOneway() == booleanArray[0].booleanValue()) {
                bl = true;
                bl2 = true;
            }
        } else {
            booleanArray[0] = new Boolean(!iMethodDescription.isOneway());
        }
        if (booleanArray2[0] != null && booleanArray2[0] != booleanArray[0]) {
            bl = true;
            bl2 = true;
        } else {
            booleanArray2[0] = booleanArray[0];
        }
        if (bl) {
            by = (byte)(by | 0xFFFFFF80);
            by = (byte)(by | 0x40);
            by = (byte)(by | (bl2 ? 1 : 0));
            if (iMethodDescription.getIndex() > 255) {
                by = (byte)(by | 4);
            }
            this._marshal.writebyte(by);
            if (bl2) {
                byte by2 = 0;
                by2 = (byte)(by2 | (booleanArray[0] != false ? 64 : 0));
                by2 = (byte)(by2 | (booleanArray2[0] != false ? -128 : 0));
                this._marshal.writebyte(by2);
            }
            if (iMethodDescription.getIndex() > 255) {
                this._marshal.writeshort((short)iMethodDescription.getIndex());
            } else {
                this._marshal.writebyte((byte)iMethodDescription.getIndex());
            }
            if (iTypeDescription != null) {
                this._marshal.writeTypeDescrption(iTypeDescription);
            }
            if (string != null) {
                this._marshal.writeOid(this._out_oid);
            }
            if (threadId != null) {
                this._marshal.writeThreadId(threadId);
            }
        } else if (iMethodDescription.getIndex() <= 47) {
            this._marshal.writebyte((byte)iMethodDescription.getIndex());
        } else {
            by = (byte)(by | 0x40);
            by = (byte)(by | iMethodDescription.getIndex() >> 8);
            this._marshal.writebyte(by);
            this._marshal.writebyte((byte)(iMethodDescription.getIndex() & 0xFF));
        }
        ITypeDescription[] iTypeDescriptionArray = iMethodDescription.getInSignature();
        ITypeDescription[] iTypeDescriptionArray2 = iMethodDescription.getOutSignature();
        int n = 0;
        while (n < iTypeDescriptionArray.length) {
            if (iTypeDescriptionArray[n] != null) {
                if (iTypeDescriptionArray2[n] != null) {
                    this._marshal.writeObject(iTypeDescriptionArray2[n].getComponentType(), ((Object[])objectArray[n])[0]);
                } else {
                    this._marshal.writeObject(iTypeDescriptionArray[n], objectArray[n]);
                }
            }
            ++n;
        }
        if (booleanArray[0].booleanValue()) {
            this.putPendingRequest(this._out_threadId, new Object[]{objectArray, iTypeDescriptionArray2, iMethodDescription.getReturnSignature()});
        }
    }

    public void writeReply(boolean bl, ThreadId threadId, Object object) {
        ++this._message_count;
        Object[] objectArray = (Object[])this.removePendingReply(threadId);
        Object[] objectArray2 = (Object[])objectArray[0];
        ITypeDescription[] iTypeDescriptionArray = (ITypeDescription[])objectArray[1];
        ITypeDescription iTypeDescription = (ITypeDescription)objectArray[2];
        byte by = -128;
        if (bl) {
            by = (byte)(by | 0x20);
            iTypeDescriptionArray = __emptyITypeDescArray;
            iTypeDescription = TypeDescription.__any_TypeDescription;
        }
        if (this._out_threadId == null || !this._out_threadId.equals(threadId)) {
            by = (byte)(by | 8);
            this._out_threadId = threadId;
        } else {
            threadId = null;
        }
        this._marshal.writebyte(by);
        if (threadId != null) {
            this._marshal.writeThreadId(threadId);
        }
        this._marshal.writeObject(iTypeDescription, object);
        int n = 0;
        while (n < iTypeDescriptionArray.length) {
            if (iTypeDescriptionArray[n] != null) {
                this._marshal.writeObject(iTypeDescriptionArray[n].getComponentType(), Array.get(objectArray2[n], 0));
            }
            ++n;
        }
    }

    private byte[] readBlock(DataInput dataInput) throws IOException {
        int n = dataInput.readInt();
        int n2 = dataInput.readInt();
        byte[] byArray = new byte[n];
        dataInput.readFully(byArray);
        return byArray;
    }

    private void writeBlock(DataOutput dataOutput, byte[] byArray, int n) throws IOException {
        if (n != 1) {
            System.err.println("##### " + this.getClass().getName() + ".writeBlock: size:" + byArray.length + " message_count:" + n);
        }
        dataOutput.writeInt(byArray.length);
        dataOutput.writeInt(n);
        dataOutput.write(byArray);
    }

    public IMessage readMessage(InputStream inputStream) throws IOException {
        Message message = null;
        DataInputStream dataInputStream = new DataInputStream(inputStream);
        while (message == null) {
            Object object;
            if (this._unmarshal.bytesLeft() <= 0) {
                object = this.readBlock(dataInputStream);
                this._unmarshal.reset((byte[])object);
            }
            if (this._unmarshal.bytesLeft() == 0) {
                throw new IOException("connection close message received");
            }
            object = this.readMessage(this._operationContainer, (Object[])this._paramsContainer, this._synchronContainer, this._mustReplyContainer, this._exceptionContainer);
            message = this._operationContainer[0] == null ? new Message(null, object, null, null, this._in_threadId, false, false, this._exceptionContainer[0], this._paramsContainer[0]) : new Message(this._in_oid, null, this._in_interface, this._operationContainer[0], this._in_threadId, this._synchronContainer[0], this._mustReplyContainer[0], false, this._paramsContainer[0]);
            this._operationContainer[0] = null;
            this._paramsContainer[0] = null;
            this._synchronContainer[0] = false;
            this._exceptionContainer[0] = false;
            this._mustReplyContainer[0] = false;
        }
        return message;
    }

    public void flush(DataOutput dataOutput) throws IOException {
        if (this._message_count > 0) {
            this.writeBlock(dataOutput, this._marshal.reset(), this._message_count);
            this._message_count = 0;
        }
    }

    public IMarshal createMarshal() {
        return new Marshal(this._iBridge, 256);
    }

    public IUnmarshal createUnmarshal(byte[] byArray) {
        Unmarshal unmarshal = new Unmarshal(this._iBridge, 256);
        unmarshal.reset(byArray);
        return unmarshal;
    }

    static class Message
    implements IMessage {
        String _oid;
        Object _result;
        ITypeDescription _iTypeDescription;
        String _operation;
        ThreadId _threadId;
        boolean _synchron;
        boolean _mustReply;
        boolean _exception;
        Object[] _params;

        Message(String string, Object object, ITypeDescription iTypeDescription, String string2, ThreadId threadId, boolean bl, boolean bl2, boolean bl3, Object[] objectArray) {
            this._oid = string;
            this._result = object;
            this._iTypeDescription = iTypeDescription;
            this._operation = string2;
            this._threadId = threadId;
            this._synchron = bl;
            this._mustReply = bl2;
            this._exception = bl3;
            this._params = objectArray;
        }

        public String getOperation() {
            return this._operation;
        }

        public ThreadId getThreadId() {
            return this._threadId;
        }

        public ITypeDescription getInterface() {
            return this._iTypeDescription;
        }

        public boolean isSynchron() {
            return this._synchron;
        }

        public boolean mustReply() {
            return this._mustReply;
        }

        public boolean isException() {
            return this._exception;
        }

        public String getOid() {
            return this._oid;
        }

        public Object getData(Object[][] objectArray) {
            objectArray[0] = this._params;
            return this._result;
        }
    }
}

