/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xmlsearch.qe;

import com.sun.xmlsearch.qe.Rule;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;

public abstract class LiteMorph {
    protected static Vector variants;
    protected static Hashtable rulesTable;
    protected static Hashtable blockedVariants;
    protected static Hashtable exceptions;
    private transient Thread lockedThread = null;
    private transient Thread currThread;
    private static final boolean debugFlag = false;

    public LiteMorph() {
        this.initialize();
    }

    public static LiteMorph getMorph() {
        return null;
    }

    protected abstract void initialize();

    protected void initialize(String[] stringArray) {
        if (exceptions == null || stringArray == null) {
            return;
        }
        int n = 0;
        while (n < stringArray.length) {
            StringTokenizer stringTokenizer = new StringTokenizer(stringArray[n], " ");
            while (stringTokenizer.hasMoreTokens()) {
                String string = stringTokenizer.nextToken();
                String string2 = (String)exceptions.get(string);
                if (string2 == null) {
                    exceptions.put(string, stringArray[n]);
                    continue;
                }
                exceptions.put(string, string2 + " " + stringArray[n]);
            }
            ++n;
        }
    }

    public String[] variantsOf(String string) {
        this.threadLock();
        variants = new Vector();
        blockedVariants = new Hashtable();
        blockedVariants.put(string, string);
        this.morphWord(string, 0);
        blockedVariants = null;
        Object[] objectArray = new String[variants.size()];
        variants.copyInto(objectArray);
        variants = null;
        this.threadUnlock();
        return objectArray;
    }

    protected void morphWord(String string, int n) {
        LiteMorph.debug(" analyzing: " + string + " at depth " + n);
        if (n > 2) {
            return;
        }
        String string2 = (String)exceptions.get(string);
        if (string2 == null) {
            string2 = "";
        }
        if (string2.length() > 0) {
            StringTokenizer stringTokenizer = new StringTokenizer(string2, " ");
            while (stringTokenizer.hasMoreTokens()) {
                this.addVariant(stringTokenizer.nextToken());
            }
            LiteMorph.debug("   " + string + ": found match in exceptions -- " + string2 + ", at depth " + n);
            return;
        }
        if (string.indexOf("-") >= 0) {
            return;
        }
        Rule[] ruleArray = null;
        int n2 = 0;
        Enumeration enumeration = rulesTable.keys();
        while (enumeration.hasMoreElements()) {
            String string3 = (String)enumeration.nextElement();
            if (!string.endsWith(string3) || string3.equals("default")) continue;
            ruleArray = (Rule[])rulesTable.get(string3);
            n2 = string3.length();
            break;
        }
        if (ruleArray == null) {
            ruleArray = (Rule[])rulesTable.get("default");
            n2 = 0;
        }
        int n3 = 0;
        while (n3 < ruleArray.length) {
            LiteMorph.debug("  " + string + ": trying rule: " + ruleArray[n3] + ", at depth " + n);
            String[] stringArray = ruleArray[n3].match(string, n, n2);
            if (stringArray.length > 0) {
                LiteMorph.debug("  " + string + ": found match for: " + ruleArray[n3] + ", at depth " + n);
                this.addVariant(string);
                int n4 = 0;
                while (n4 < stringArray.length) {
                    this.addVariant(stringArray[n4]);
                    ++n4;
                }
                break;
            }
            ++n3;
        }
    }

    private void addVariant(String string) {
        if (blockedVariants.get(string) == null) {
            variants.addElement(string);
            blockedVariants.put(string, string);
        }
    }

    protected static Rule r(String string, String string2, LiteMorph liteMorph) {
        return new Rule(string, string2, liteMorph);
    }

    public final synchronized void threadLock() {
        try {
            while (this.currThread != null) {
                this.wait();
            }
            this.currThread = Thread.currentThread();
        }
        catch (InterruptedException interruptedException) {}
    }

    public final synchronized void threadUnlock() {
        this.currThread = null;
        this.notify();
    }

    private static void debug(String string) {
    }
}

