/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xmlsearch.db;

import com.sun.xmlsearch.db.Block;
import com.sun.xmlsearch.db.BlockFactory;
import com.sun.xmlsearch.db.BlockManagerParameters;
import com.sun.xmlsearch.db.BlockProcessor;
import java.io.IOException;
import java.io.RandomAccessFile;

final class BlockManager {
    private static final int INCR = 64;
    private final RandomAccessFile _file;
    private final long _blockSize;
    private final boolean _update;
    private final BlockFactory _blockFactory;
    private final Block _dummy;
    private final int _nBlocksLimit = 64;
    private int _blockTableSize;
    private BlockDescriptor[] _blockTab;
    private int _nBlocks = 0;
    private int _oldest = 0;
    private int _newest = 0;
    private boolean debug = false;

    public BlockManager(BlockManagerParameters blockManagerParameters, boolean bl, BlockFactory blockFactory) throws IOException {
        this._blockFactory = blockFactory;
        this._update = bl;
        this._blockSize = blockManagerParameters.getBlockSize();
        this._file = new RandomAccessFile(blockManagerParameters.getFile(), bl ? "rw" : "r");
        this._dummy = blockFactory.makeBlock();
        if (this._file.length() == 0L && bl) {
            this._dummy.setBlockNumber(0);
            this.writeBlock(this._dummy);
        }
        this._blockTableSize = (int)(this._file.length() / this._blockSize);
        this._blockTab = new BlockDescriptor[this._blockTableSize];
        this.mapBlock(0, new BlockDescriptor(), blockFactory.makeBlock());
    }

    public void lockBlock(int n) {
        this._blockTab[n]._lock = true;
    }

    public void unlockBlock(int n) {
        this._blockTab[n]._lock = false;
    }

    public void setModified(int n) {
        this._blockTab[n]._modf = true;
    }

    public void close() throws IOException {
        if (this._update) {
            int n = 0;
            while (n < this._blockTableSize) {
                if (this._blockTab[n] != null && this._blockTab[n]._modf) {
                    this.writeBlock(this._blockTab[n]._block);
                }
                ++n;
            }
        }
        this._file.close();
    }

    public Block accessBlock(int n) throws Exception {
        if (this._blockTab[n] != null) {
            this.moveToFront(n);
        } else if (this._nBlocks < 64) {
            this.mapBlock(n, new BlockDescriptor(), this._blockFactory.makeBlock());
        } else {
            this.remapSomeBlock(n);
        }
        return this._blockTab[n]._block;
    }

    public Block getNewBlock() throws Exception {
        Object object;
        int n = (int)(this._file.length() / this._blockSize);
        if (n > this._blockTableSize - 1) {
            object = new BlockDescriptor[this._blockTableSize + 64];
            System.arraycopy(this._blockTab, 0, object, 0, this._blockTableSize);
            this._blockTab = object;
            this._blockTableSize += 64;
        }
        if (this._nBlocks < 64) {
            object = this._blockFactory.makeBlock();
            ((Block)object).setBlockNumber(n);
            this.writeBlock((Block)object);
            this.addDescriptor((Block)object, n, new BlockDescriptor());
        } else {
            this._dummy.setBlockNumber(n);
            this.writeBlock(this._dummy);
            this.remapSomeBlock(n);
        }
        return this._blockTab[n]._block;
    }

    private void mapBlock(int n, BlockDescriptor blockDescriptor, Block block) throws IOException {
        this._file.seek(this._blockSize * (long)n);
        Block.readIn(this._file, block);
        this.addDescriptor(block, n, blockDescriptor);
    }

    private void addDescriptor(Block block, int n, BlockDescriptor blockDescriptor) {
        this._blockTab[n] = blockDescriptor;
        blockDescriptor._block = block;
        blockDescriptor._prev = this._newest;
        this._blockTab[this._newest]._next = n;
        this._newest = n;
        ++this._nBlocks;
    }

    private void remapSomeBlock(int n) throws Exception {
        int n2 = this._oldest;
        while (this._blockTab[n2]._lock && n2 != this._newest) {
            n2 = this._blockTab[n2]._next;
        }
        if (this._blockTab[n2]._lock) {
            throw new Exception("everything locked");
        }
        if (this._blockTab[n2]._modf) {
            this.writeBlock(this._blockTab[n2]._block);
        }
        --this._nBlocks;
        Block block = this._blockTab[n2]._block;
        if (n2 == this._oldest) {
            this._oldest = this._blockTab[n2]._next;
        } else if (n2 == this._newest) {
            this._newest = this._blockTab[n2]._prev;
        } else {
            this._blockTab[this._blockTab[n2]._next]._prev = this._blockTab[n2]._prev;
            this._blockTab[this._blockTab[n2]._prev]._next = this._blockTab[n2]._next;
        }
        this._blockTab[n2].reset();
        this.mapBlock(n, this._blockTab[n2], block);
        this._blockTab[n2] = null;
    }

    private void moveToFront(int n) {
        if (n == this._oldest) {
            this._oldest = this._blockTab[n]._next;
            this._blockTab[n]._prev = this._newest;
            this._blockTab[this._newest]._next = n;
            this._newest = n;
        } else if (n != this._newest) {
            this._blockTab[this._blockTab[n]._next]._prev = this._blockTab[n]._prev;
            this._blockTab[this._blockTab[n]._prev]._next = this._blockTab[n]._next;
            this._blockTab[n]._prev = this._newest;
            this._blockTab[this._newest]._next = n;
            this._newest = n;
        }
    }

    public void writeBlock(Block block) throws IOException {
        this._file.seek(this._blockSize * (long)block._number);
        block.writeOut(this._file);
    }

    public void mapBlocks(BlockProcessor blockProcessor) throws IOException {
        long l = this._file.length() / this._blockSize;
        Block block = this._blockFactory.makeBlock();
        this._file.seek(0L);
        int n = 0;
        while ((long)n < l) {
            blockProcessor.process(Block.readIn(this._file, block));
            ++n;
        }
    }

    private void debug(String string) {
        if (this.debug) {
            System.err.println("Block Manager: " + string);
        }
    }

    private final class BlockDescriptor {
        public Block _block = null;
        public boolean _lock = false;
        public boolean _modf = false;
        public int _prev = 0;
        public int _next = 0;

        private BlockDescriptor() {
        }

        public void reset() {
            this._modf = false;
            this._lock = false;
            this._block = null;
        }
    }
}

