/*
 * Decompiled with CFR 0.152.
 */
package jp.co.kayo.io;

import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import java.util.Vector;
import jp.co.kayo.action.Action;
import jp.co.kayo.action.ActionFactory;
import jp.co.kayo.io.GameStartRecord;
import jp.co.kayo.io.PString;
import jp.co.kayo.io.PlayerRecord;
import jp.co.kayo.io.ReplayBuffer;

public class ReplayRecord {
    public static final int MAX_MAP = 200;
    public static final int gameflag_hideterrain = 1;
    public static final int gameflag_fullshare = 2;
    public static final int gameflag_speedfast = 4;
    public static final int gameflag_mapexplored = 8;
    public static final int gameflag_alwaysvisible = 16;
    public static final int gameflag_defaultvisible = 32;
    public static final int gameflag_fullobserver = 64;
    public static final int gameflag_observerondefeat = 128;
    public static final int gameflag_teamtogether = 256;
    public static final int gameflag_fixedteams = 512;
    public static final int gameflag_randomhero = 1024;
    public static final int gameflag_randomraces = 2048;
    public static final int gameflag_referee = 4096;
    public static final int gameflag_fixedally = 8192;
    public static final int gameflag_fixedplayerprop = 16384;
    public static final int gameflag_fixracetorandom = 32768;
    public long totaltime = 0L;
    private GameStartRecord m_gamestartrecord;
    private Map m_playermap = new TreeMap();
    private String m_creator;
    private String m_gamename;
    private String m_mapname;
    private Vector m_actoins = new Vector();
    private Vector m_chats = new Vector();
    private int m_gameflag;
    private int m_gametype;
    private int m_player_slots;
    private int m_privateFlag;

    public ReplayRecord(ReplayBuffer buf) {
        this.readPlayerRecord(buf);
        this.readGameName(buf);
        this.readMapSettings(buf);
        buf.skip(11);
        this.readMapAndCreatorName(buf);
        buf.skip(2);
        this.readPlayerCount(buf);
        this.readGameType(buf);
        this.readPlayerList(buf);
        this.m_gamestartrecord = new GameStartRecord(this, buf);
        boolean loop = true;
        while (loop) {
            byte cmd = buf.get();
            switch (cmd) {
                case 23: {
                    Action action = ActionFactory.get(151);
                    action.parse(buf);
                    action.setTime(this.totaltime);
                    this.m_actoins.add(action);
                    PlayerRecord rec = (PlayerRecord)this.m_playermap.get(new Integer(action.getId()));
                    if (rec == null) break;
                    rec.addAction(action);
                    break;
                }
                case 26: {
                    int action = buf.getInt();
                    break;
                }
                case 27: {
                    int action = buf.getInt();
                    break;
                }
                case 28: {
                    int action = buf.getInt();
                    break;
                }
                case 30: 
                case 31: {
                    short n = buf.getShort();
                    byte[] actiondata = buf.get(new byte[n]);
                    ReplayBuffer actionfile = new ReplayBuffer(ByteBuffer.wrap(actiondata, 0, actiondata.length));
                    this.readActionData(n, actionfile);
                    break;
                }
                case 32: {
                    Action action = ActionFactory.get(160);
                    action.parse(buf);
                    action.setTime(this.totaltime);
                    this.m_actoins.add(action);
                    this.m_chats.add(action);
                    PlayerRecord rec = (PlayerRecord)this.m_playermap.get(new Integer(action.getId()));
                    if (rec == null) break;
                    rec.addAction(action);
                    break;
                }
                case 34: {
                    byte b = buf.get();
                    int rec = buf.getInt();
                    break;
                }
                case 35: {
                    int a = buf.getInt();
                    byte b = buf.get();
                    int c = buf.getInt();
                    byte by = buf.get();
                    break;
                }
                case 47: {
                    int mode = buf.getInt();
                    int n = buf.getInt();
                    break;
                }
                case 0: {
                    loop = false;
                }
            }
        }
    }

    public Vector getActoins() {
        return this.m_actoins;
    }

    public Vector getChats() {
        return this.m_chats;
    }

    public String getCreator() {
        return this.m_creator;
    }

    public int getGameflag() {
        return this.m_gameflag;
    }

    public String getGamename() {
        return this.m_gamename;
    }

    public GameStartRecord getGamestartrecord() {
        return this.m_gamestartrecord;
    }

    public int getGametype() {
        return this.m_gametype;
    }

    public String getMapname() {
        return this.m_mapname;
    }

    public String getMapImage() {
        int i;
        String filename = this.m_mapname;
        if (filename != null && (i = filename.lastIndexOf(92)) > 0 && i < filename.length() - 1) {
            if ((i = (filename = filename.substring(i + 1)).lastIndexOf(41)) > 0 && i < filename.length() - 1) {
                filename = filename.substring(i + 1);
            }
            if ((i = filename.lastIndexOf(46)) > 0 && i < filename.length() - 1) {
                String imgname = String.valueOf(filename.substring(0, i)) + ".jpg";
                return imgname;
            }
        }
        return "notfound";
    }

    public PlayerRecord getPlayer(int id) {
        return (PlayerRecord)this.m_playermap.get(new Integer(id));
    }

    public int getPlayer_slots() {
        return this.m_player_slots;
    }

    public Map getPlayermap() {
        return this.m_playermap;
    }

    public long getTotaltime() {
        return this.totaltime;
    }

    public String getType() {
        StringBuffer ret = new StringBuffer();
        HashMap<Integer, Integer> map = new HashMap<Integer, Integer>();
        Iterator ite = this.m_playermap.values().iterator();
        while (ite.hasNext()) {
            PlayerRecord player = (PlayerRecord)ite.next();
            int team = player.getTeam();
            if (!player.getController().equals("Player") && !player.getController().equals("Computer")) continue;
            Integer count = (Integer)map.get(new Integer(team));
            count = count == null ? new Integer(1) : new Integer(count + 1);
            map.put(new Integer(team), count);
        }
        ite = map.values().iterator();
        while (ite.hasNext()) {
            Integer count = (Integer)ite.next();
            ret.append(count.toString());
            if (!ite.hasNext()) continue;
            ret.append("v");
        }
        return ret.toString();
    }

    void readActionData(int n, ReplayBuffer buf) {
        short time = buf.getShort();
        this.totaltime += (long)time;
        Iterator ite = this.m_playermap.values().iterator();
        while (ite.hasNext()) {
            PlayerRecord player = (PlayerRecord)ite.next();
            player.setGametime(this.totaltime);
        }
        if (n > 2) {
            short actionblocklength;
            int bsize = n;
            do {
                byte playerid = buf.get();
                actionblocklength = buf.getShort();
                PlayerRecord rec = (PlayerRecord)this.m_playermap.get(new Integer(playerid));
                if (actionblocklength <= 0) continue;
                byte actionid = buf.get();
                byte[] actionbuf = new byte[actionblocklength - 1];
                buf.get(actionbuf);
                ReplayBuffer acbuf = new ReplayBuffer(ByteBuffer.wrap(actionbuf, 0, actionbuf.length));
                Action action = ActionFactory.get(actionid);
                if (action != null) {
                    action.setTime(this.totaltime);
                    action.setId(playerid);
                    this.m_actoins.add(action);
                    action.parse(acbuf);
                    if (rec == null) continue;
                    rec.addAction(action);
                    continue;
                }
                System.out.println(String.valueOf(Integer.toHexString(actionid).toUpperCase()) + " uknown");
            } while ((bsize -= actionblocklength + 4) > 3);
        }
    }

    void readGameType(ReplayBuffer buf) {
        this.m_gametype = buf.get();
        this.m_privateFlag = buf.get();
        buf.skip(2);
        buf.skip(4);
    }

    void readMapAndCreatorName(ReplayBuffer buf) {
        byte[] tmp_buf = new byte[200];
        int first = 0;
        if (buf == null) {
            return;
        }
        tmp_buf[199] = 0;
        int trans_bit = 255;
        int i = 0;
        int j = 0;
        while (j < 199) {
            byte b = buf.get();
            if (i % 8 == 1) {
                trans_bit = b;
            } else {
                tmp_buf[j] = b;
                int bit = (i + 8 - 1) % 8;
                if ((1 << bit & trans_bit) == 0) {
                    int n = j;
                    tmp_buf[n] = (byte)(tmp_buf[n] - 1);
                }
                if (tmp_buf[j] == 0) {
                    if (first != 0) break;
                    first = j;
                }
                ++j;
            }
            ++i;
        }
        this.m_mapname = new String(tmp_buf, 0, first);
        this.m_creator = new PString(tmp_buf, first + 1, j).toString();
    }

    void readPlayerCount(ReplayBuffer buf) {
        this.m_player_slots = buf.getInt();
    }

    void readPlayerList(ReplayBuffer buf) {
        int i = 1;
        while (i < this.m_player_slots) {
            try {
                PlayerRecord player = new PlayerRecord(i + 1, buf);
                this.m_playermap.put(new Integer(player.getId()), player);
            }
            catch (Exception exception) {
                // empty catch block
            }
            ++i;
        }
    }

    private void readGameName(ReplayBuffer buf) {
        this.m_gamename = new String(buf.readToken());
    }

    private void readMapSettings(ReplayBuffer buf) {
        this.m_gameflag = 0;
        byte flg = buf.get();
        if ((flg & 4) != 0) {
            this.m_gameflag &= 1;
        }
        if ((flg & 0x10) != 0) {
            this.m_gameflag &= 2;
        }
        buf.skip();
        if ((flg & 2) != 0) {
            this.m_gameflag &= 4;
        }
        buf.skip();
        if ((flg & 2) != 0) {
            this.m_gameflag &= 8;
        }
        if ((flg & 4) != 0) {
            this.m_gameflag &= 0x10;
        }
        if ((flg & 8) != 0) {
            this.m_gameflag &= 0x20;
        }
        if ((flg & 0x10) != 0) {
            this.m_gameflag &= 0x40;
        }
        if ((flg & 0x20) != 0) {
            this.m_gameflag &= 0x80;
        }
        if ((flg & 0x40) != 0) {
            this.m_gameflag &= 0x100;
        }
        buf.skip();
        if ((flg & 2) != 0) {
            this.m_gameflag &= 0x200;
        }
        buf.skip();
        if ((flg & 2) != 0) {
            this.m_gameflag &= 0x400;
        }
        if ((flg & 4) != 0) {
            this.m_gameflag &= 0x800;
        }
        if ((flg & 0x40) != 0) {
            this.m_gameflag &= 0x1000;
        }
    }

    private void readPlayerRecord(ReplayBuffer buf) {
        try {
            PlayerRecord player = new PlayerRecord(buf);
            this.m_playermap.put(new Integer(player.getId()), player);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

