/*
 * Decompiled with CFR 0.152.
 */
package jp.co.kayo.action;

import jp.co.kayo.action.Action;
import jp.co.kayo.action.ItemCode;
import jp.co.kayo.io.ReplayBuffer;

public class UnitBuildingAbility
extends Action {
    int m_abilityflags;
    Param m_param;

    public UnitBuildingAbility(int actionid) {
        super(actionid);
    }

    public void parse(ReplayBuffer buf) {
        this.m_abilityflags = buf.get();
        this.m_param = null;
        switch (this.getActionid()) {
            case 16: {
                this.m_param = new Param10();
                break;
            }
            case 17: {
                this.m_param = new Param11();
                break;
            }
            case 18: {
                this.m_param = new Param12();
                break;
            }
            case 20: {
                this.m_param = new Param14();
            }
        }
        if (this.m_param != null) {
            this.m_param.parse(buf);
        }
    }

    public String toXML() {
        StringBuffer buf = new StringBuffer();
        buf.append("<AbilityFlags");
        buf.append(" flags='" + Long.toHexString(this.m_abilityflags) + "' ");
        if ((this.m_abilityflags & 1) != 0) {
            buf.append(" shift='1' ");
        }
        if ((this.m_abilityflags & 4) != 0) {
            buf.append(" areatarget='1' ");
        }
        if ((this.m_abilityflags & 8) != 0) {
            buf.append(" group='1' ");
        }
        switch (this.m_abilityflags) {
            case 64: {
                buf.append(" analysis='useitem/upgrade' ");
                break;
            }
            case 66: 
            case 70: {
                buf.append(" analysis='train/summon/research' ");
                break;
            }
            case 68: {
                buf.append(" analysis='useability/summon' ");
            }
        }
        buf.append("/>");
        if (this.m_param != null) {
            buf.append(this.m_param.toXML());
        }
        return buf.toString();
    }

    public int getType() {
        return 8;
    }

    public boolean availableAPM() {
        return true;
    }

    public int getAbilityflags() {
        return this.m_abilityflags;
    }

    public Param getParam() {
        return this.m_param;
    }

    public static interface Param {
        public void parse(ReplayBuffer var1);

        public String toXML();
    }

    public static class Param10
    implements Param {
        int m_itemid;

        public void parse(ReplayBuffer buf) {
            this.m_itemid = buf.getInt();
            int tmp1 = buf.getInt();
            int tmp2 = buf.getInt();
            this.m_itemid = this.m_itemid >> 8 | (tmp1 & 0xFF) << 24;
        }

        public String toXML() {
            StringBuffer buf = new StringBuffer();
            buf.append("<ItemID>");
            buf.append(ItemCode.ID2Str(this.m_itemid));
            buf.append("</ItemID>");
            return buf.toString();
        }

        public int getItemid() {
            return this.m_itemid;
        }

        public char[] getChar() {
            char[] b = new char[]{(char)((this.m_itemid & 0xFF000000) >> 24), (char)((this.m_itemid & 0xFF0000) >> 16), (char)((this.m_itemid & 0xFF00) >> 8), (char)((this.m_itemid & 0xFF) >> 0)};
            return b;
        }
    }

    public static class Param11
    extends Param10 {
        int X;
        int Y;

        public void parse(ReplayBuffer buf) {
            super.parse(buf);
            this.X = buf.getInt();
            this.Y = buf.getInt();
        }

        public String toXML() {
            StringBuffer buf = new StringBuffer(super.toXML());
            buf.append("<TargetLocation");
            buf.append(" X='").append((float)this.X).append("' ");
            buf.append(" Y='").append((float)this.Y).append("' ");
            buf.append("/>");
            return buf.toString();
        }
    }

    public static class Param12
    extends Param11 {
        int ID1;
        int ID2;

        public void parse(ReplayBuffer buf) {
            super.parse(buf);
            this.ID1 = buf.getInt();
            this.ID2 = buf.getInt();
        }

        public String toXML() {
            StringBuffer buf = new StringBuffer(super.toXML());
            if (this.ID1 == this.ID2 && this.ID1 == -1) {
                buf.append("<RallyOnGround />");
            }
            return buf.toString();
        }
    }

    public static class Param14
    implements Param {
        int ItemIDA;
        int AX;
        int AY;
        int ItemIDB;
        int BX;
        int BY;

        public void parse(ReplayBuffer buf) {
            this.ItemIDA = buf.getInt();
            int tmp1 = buf.getInt();
            int tmp2 = buf.getInt();
            this.ItemIDA = this.ItemIDA >> 8 | (tmp1 & 0xFF) << 24;
            this.AX = buf.getInt();
            this.AY = buf.getInt();
            this.ItemIDB = buf.getInt();
            tmp1 = buf.getInt();
            tmp2 = buf.getInt();
            this.ItemIDB = this.ItemIDB >> 8 | (tmp1 & 0xFF) << 24;
            buf.skip();
            this.BX = buf.getInt();
            this.BY = buf.getInt();
        }

        public String toXML() {
            StringBuffer buf = new StringBuffer();
            buf.append("<ItemIDA>");
            buf.append(ItemCode.ID2Str(this.ItemIDA));
            buf.append("</ItemIDA>");
            buf.append("<TargetLocationA");
            buf.append(" X='").append((float)this.AX).append("' ");
            buf.append(" Y='").append((float)this.AY).append("' ");
            buf.append("/>");
            buf.append("<ItemIDB>");
            buf.append(ItemCode.ID2Str(this.ItemIDB));
            buf.append("</ItemIDB>");
            buf.append("<TargetLocationB");
            buf.append(" X='").append((float)this.BX).append("' ");
            buf.append(" Y='").append((float)this.BY).append("' ");
            buf.append("/>");
            return buf.toString();
        }
    }
}

