/*
 * Decompiled with CFR 0.152.
 */
package jp.co.kayo.action;

import jp.co.kayo.action.Action;
import jp.co.kayo.action.AssignGroupHotkey;
import jp.co.kayo.action.CancelHeroRevival;
import jp.co.kayo.action.ChangeAllyOptions;
import jp.co.kayo.action.ChangeSelection;
import jp.co.kayo.action.Chat;
import jp.co.kayo.action.ContinueGame;
import jp.co.kayo.action.DecreaseGameSpeed;
import jp.co.kayo.action.ESC;
import jp.co.kayo.action.EnterSelectBuilding;
import jp.co.kayo.action.EnterSelectHero;
import jp.co.kayo.action.GiveIitemToUnit;
import jp.co.kayo.action.IncreaseGameSpeed;
import jp.co.kayo.action.LeaveGame;
import jp.co.kayo.action.MapChatCommand;
import jp.co.kayo.action.MinimapSignal;
import jp.co.kayo.action.Pause;
import jp.co.kayo.action.RemoveUnit;
import jp.co.kayo.action.Resume;
import jp.co.kayo.action.SaveGame;
import jp.co.kayo.action.ScenarioTrigger;
import jp.co.kayo.action.SelectGroundItem;
import jp.co.kayo.action.SelectGroupHotkey;
import jp.co.kayo.action.SelectSubgroup;
import jp.co.kayo.action.SetGameSpeed;
import jp.co.kayo.action.SinglePlayerCheats;
import jp.co.kayo.action.TransferResources;
import jp.co.kayo.action.UnitBuildingAbility;
import jp.co.kayo.action.Unknown;
import jp.co.kayo.action.UpdateSubgroup;

public class ActionFactory {
    private static ActionFactory _factory = null;

    private static ActionFactory instance() {
        if (_factory == null) {
            _factory = new ActionFactory();
        }
        return _factory;
    }

    public static Action get(int actionid) {
        switch (actionid) {
            case 1: {
                return new Pause(actionid);
            }
            case 2: {
                return new Resume(actionid);
            }
            case 3: {
                return new SetGameSpeed(actionid);
            }
            case 4: {
                return new IncreaseGameSpeed(actionid);
            }
            case 5: {
                return new DecreaseGameSpeed(actionid);
            }
            case 6: 
            case 7: {
                return new SaveGame(actionid);
            }
            case 16: 
            case 17: 
            case 18: 
            case 20: {
                return new UnitBuildingAbility(actionid);
            }
            case 19: {
                return new GiveIitemToUnit(actionid);
            }
            case 22: {
                return new ChangeSelection(actionid);
            }
            case 23: {
                return new AssignGroupHotkey(actionid);
            }
            case 24: {
                return new SelectGroupHotkey(actionid);
            }
            case 25: {
                return new SelectSubgroup(actionid);
            }
            case 26: {
                return new UpdateSubgroup(actionid);
            }
            case 28: {
                return new SelectGroundItem(actionid);
            }
            case 29: {
                return new CancelHeroRevival(actionid);
            }
            case 30: {
                return new RemoveUnit(actionid);
            }
            case 32: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: {
                return new SinglePlayerCheats(actionid);
            }
            case 80: {
                return new ChangeAllyOptions(actionid);
            }
            case 81: {
                return new TransferResources(actionid);
            }
            case 96: {
                return new MapChatCommand(actionid);
            }
            case 97: {
                return new ESC(actionid);
            }
            case 98: {
                return new ScenarioTrigger(actionid);
            }
            case 102: {
                return new EnterSelectHero(actionid);
            }
            case 103: {
                return new EnterSelectBuilding(actionid);
            }
            case 104: {
                return new MinimapSignal(actionid);
            }
            case 105: 
            case 106: {
                return new ContinueGame(actionid);
            }
            case 27: 
            case 33: 
            case 117: {
                return new Unknown(actionid);
            }
            case 151: {
                return new LeaveGame(actionid & 0xFFFFFF7F);
            }
            case 160: {
                return new Chat(actionid & 0xFFFFFF7F);
            }
        }
        return null;
    }
}

