/***************************************************************************
                          wtimedialog.cpp  -  description
                             -------------------
    begin                : 2004ǯ  5  4  16:36:12 JST
    copyright            : (C) 2003 by Tomoaki Murakami
    email                : solarisphere@yahoo.co.jp
 ***************************************************************************/

/***************************************************************************
 *   Copyright (C) 2004 by Tomoaki Murakami                                *
 *   solarisphrere@yahoo.co.jp                                             *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include <qlayout.h>
#include <qlabel.h>
#include <qpushbutton.h>
#include <klocale.h>
#include "wtimedialog.h"

/////////////////////////////////////////////////////////////////////////////

WTimeDialog::WTimeDialog(QWidget* WidgetParent, const char* cName)
  : KDialogBase(KDialogBase::Plain,
                "Set Time",
                Ok | Cancel,
                Ok,
                WidgetParent,
                cName)
{
  QFrame *FramePage = plainPage();
  FramePage->setMaximumHeight(80);
  FramePage->setMinimumHeight(80);
  FramePage->setMinimumWidth(240);

  QVBoxLayout* VLayout = new QVBoxLayout(FramePage);

  QHBoxLayout* HLayout = new QHBoxLayout(FramePage);

  QLabel* LabelMMSS = new QLabel("MM:SS ", FramePage);
  HLayout->addWidget(LabelMMSS);

  TimeEdit = new QTimeEdit(FramePage);
  HLayout->addWidget(TimeEdit);

  QLabel* LabelAnd = new QLabel(" and ", FramePage);
  HLayout->addWidget(LabelAnd);

  IntSpinMilliSec = new KIntSpinBox(0, 999, 1, 0, 10, FramePage);
  HLayout->addWidget(IntSpinMilliSec);

  QLabel* LabelMilliSec = new QLabel(" milliseconds ", FramePage);
  HLayout->addWidget(LabelMilliSec);

  VLayout->addLayout(HLayout);

  QHBoxLayout* HLayoutReset = new QHBoxLayout(FramePage);
  QPushButton* Button = new QPushButton("&Reset to zero", FramePage);
  HLayoutReset->addStretch();
  HLayoutReset->addWidget(Button);
  connect(Button, SIGNAL(clicked()), this, SLOT(slotReset()));

  VLayout->addLayout(HLayoutReset);
}

/////////////////////////////////////////////////////////////////////////////

WTimeDialog::~WTimeDialog()
{
}

/////////////////////////////////////////////////////////////////////////////

void
WTimeDialog::setDisplay(uint disp)
{
  TimeEdit->setDisplay(disp ^ MilliSecs);
  if ( disp & MilliSecs ) {
    IntSpinMilliSec->show();
  } else {
    IntSpinMilliSec->hide();
  }
}

/////////////////////////////////////////////////////////////////////////////

QTime 
WTimeDialog::time() const
{
  QTime timeReturn = TimeEdit->time();
  if ( IntSpinMilliSec->isShown() ) {
    return timeReturn.addMSecs(IntSpinMilliSec->value());
  } else {
    return timeReturn;
  }
}

/////////////////////////////////////////////////////////////////////////////

void
WTimeDialog::setTime(const QTime& time)
{
  TimeEdit->setTime(time);
  IntSpinMilliSec->setValue(time.msec());
}

/////////////////////////////////////////////////////////////////////////////

void 
WTimeDialog::slotReset()
{
  TimeEdit->setTime(QTime());
  IntSpinMilliSec->setValue(0);
}

/////////////////////////////////////////////////////////////////////////////

#include "wtimedialog.moc"
