/***************************************************************************/
/*! \file   wfilechooser.h
    \brief  饹WFileChooserΥإåե롣
    \author Tomoaki Murakami
    \date   2004ǯ  5  4  16:52:12 JST
*/
/***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef WFILECHOOSER_H
#define WFILECHOOSER_H

#include <qhbox.h>
#include <qlabel.h>
#include <klineedit.h>
#include <kpushbutton.h>

/*-------------------------------------------------------------------------*/
/*! \class  WFileChooser
    \brief  ե򥦥åȡ
    饤󥨥ǥåȤľܥե̾Ϥ뤫ޤϻȥܥ
    åƥե򤹤롣
*/
/*-------------------------------------------------------------------------*/
class WFileChooser : public QHBox
{
  Q_OBJECT
public:
  //! \brief 󥹥ȥ饯
  //! \param strCaption åȤΥץ
  //! \param strDialogCaption Υץ
  //! \param WidgetParent ƥåȤؤΥݥ󥿡
  //! \param cName åȤ̾Ρ
  WFileChooser(const QString& strCaption, 
               const QString& strDialogCaption, 
               QWidget* WidgetParent=0, 
               const char* cName=0);
  //! \brief ǥȥ饯
  ~WFileChooser();

  //! \brief åȤ˻ꤵƤե̾롣
  QString fileName() const;
  //! \brief åȤ˥ե̾ꤹ롣
  //! \param strNewFileName ꤷե̾Ρ
  void    setFileName(const QString& strNewFileName);
  //! \brief ǥե򻲾Ȥݤ˻ѤǥեȤ
  //! ѥꤹ롣
  //! \param strSearchDir ꤷѥ
  void    setSearchDir(const QString& strSearchDir);
  //! \brief ǥե򻲾Ȥݤ˥եåˤä
  //! ե륿󥰤Ԥ硢ե륿ꤹ롣
  //! \param strSearchFileType ե륿ꤹ롣
  //! () "*.wav *.mp3|Sound files\n*|All files"
  void    setFileType(const QString& strSearchFileType);
  //! \brief ǥ쥯ȥӤꤹ롣
  //! \param bDir ǥ쥯ȥӤλtrueեӤλfalse
  void    setUsageForDir(bool bDir);

private:
  //! ǥ쥯ȥѤ
  bool        bIsForDir;
  //! Υǥեȥѥ
  QString     strStartDir;
  //! Υե륿
  QString     strFileType;
  //! åȤΥץ
  QLabel      *LabelCaption;
  //! Υץ
  QString     strBrowserCaption;
  //! ե̾ľϤ뤿Υ饤󥨥ǥåȡ
  KLineEdit   *LineEditFileName;
  //! ѥץåܥ
  KPushButton *PushButtonBrowse;

private slots:
  //! \brief Ȥ׵ᤵ줿Υåȡ
  void slotBrowse();

signals:
  //! \brief ե̾ΤѹΥ٥ȡ
  void fileNameChanged(const QString&);
};

#endif
