/***************************************************************************
                          wfilechooser.cpp  -  description
                             -------------------
    begin                : 2004ǯ  5  4  16:54:12 JST
    copyright            : (C) 2004 by Tomoaki Murakami
    email                : solarisphere@yahoo.co.jp
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <klocale.h>
#include <kmessagebox.h>
#include <kfiledialog.h>
#include <kdirselectdialog.h>
#include "wfilechooser.h"

/////////////////////////////////////////////////////////////////////////////

WFileChooser::WFileChooser(
  const QString& strCaption, 
  const QString& strDialogCaption, 
  QWidget *WidgetParent, 
  const char *cName)
  : QHBox(WidgetParent, cName)
{
  strStartDir = QString::null;
  bIsForDir = false;

  strBrowserCaption = strDialogCaption;

  LabelCaption = new QLabel(strCaption, this);
  LineEditFileName = new KLineEdit(this);
  LineEditFileName->setMinimumWidth(60);
  connect(LineEditFileName, SIGNAL(textChanged(const QString&)),
          this, SIGNAL(fileNameChanged(const QString&)));

  PushButtonBrowse = new KPushButton(i18n("&Refer..."), this);
  connect(PushButtonBrowse, SIGNAL(clicked()), this, SLOT(slotBrowse()));

  setMinimumHeight(LineEditFileName->height());
  setMaximumHeight(LineEditFileName->height());
}

/////////////////////////////////////////////////////////////////////////////

WFileChooser::~WFileChooser()
{
}

/////////////////////////////////////////////////////////////////////////////

QString
WFileChooser::fileName() const
{
  return LineEditFileName->text();
}

/////////////////////////////////////////////////////////////////////////////

void
WFileChooser::setFileName(const QString& strNewFileName)
{
  LineEditFileName->setText(strNewFileName);
}

/////////////////////////////////////////////////////////////////////////////

void
WFileChooser::setSearchDir(const QString& strSearchDir)
{
  strStartDir = strSearchDir;
}

/////////////////////////////////////////////////////////////////////////////

void
WFileChooser::setFileType(const QString& strSearchFileType)
{
  strFileType = strSearchFileType;
}

/////////////////////////////////////////////////////////////////////////////

void
WFileChooser::setUsageForDir(bool bDir)
{
  bIsForDir = bDir;
}

/////////////////////////////////////////////////////////////////////////////

void
WFileChooser::slotBrowse()
{
  if ( !bIsForDir ) { // for file
    KURL url = KFileDialog::getOpenURL(
                 strStartDir, 
                 strFileType, 
                 this, 
                 strBrowserCaption);
    if ( url.isEmpty() ) {
      return;
    }

    if ( !url.isLocalFile() ) {
      KMessageBox::sorry(this, i18n("VoxStorm cannot handle remote files yet."));
      return;
    }

    LineEditFileName->setText(url.path());

  } else {  // for directory
    KURL url = KDirSelectDialog::selectDirectory(strStartDir, false, this);
    if ( url.isEmpty() ) {
      return;
    }

    if ( !url.isLocalFile() ) {
      KMessageBox::sorry(this, i18n("VoxStorm cannot handle remote files yet."));
      return;
    }

    LineEditFileName->setText(url.path());
  }
}

/////////////////////////////////////////////////////////////////////////////

#include "wfilechooser.moc"
