/***************************************************************************
                          wnamedialog.cpp  -  description
                             -------------------
    begin                : 2004ǯ  5  4  16:49:12 JST
    copyright            : (C) 2003 by Black Sabbath
    email                : solarisphere@yahoo.co.jp
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <qlayout.h>
#include <qlabel.h>
#include <kmessagebox.h>
#include <klocale.h>
#include "wnamedialog.h"

/////////////////////////////////////////////////////////////////////////////

WNameDialog::WNameDialog(QWidget *WidgetParent, const char *cName)
  : KDialogBase(KDialogBase::Plain,
                "Set Name",
                Ok | Cancel,
                Ok,
                WidgetParent,
                cName)
{
  bRestrictNullString = false;

  QFrame *FramePage = plainPage();
  FramePage->setMaximumHeight(80);
  FramePage->setMinimumHeight(80);
  FramePage->setMinimumWidth(240);

  QVBoxLayout *VBoxLayout = new QVBoxLayout(FramePage);

  QLabel *LabelHint = new QLabel("Input name", FramePage);
  VBoxLayout->addWidget(LabelHint);

  LineEditNewName = new KRestrictedLine(FramePage);
  VBoxLayout->addWidget(LineEditNewName);

  LineEditNewName->setFocus();
}

/////////////////////////////////////////////////////////////////////////////

WNameDialog::~WNameDialog()
{
}

/////////////////////////////////////////////////////////////////////////////

void
WNameDialog::showEvent()
{
  LineEditNewName->setFocus();
}

/////////////////////////////////////////////////////////////////////////////

QString
WNameDialog::getNameFromDialog() const
{
  return LineEditNewName->text();
}

/////////////////////////////////////////////////////////////////////////////

void
WNameDialog::setNameToDialog(const QString& strName)
{
  LineEditNewName->setText(strName);
}

/////////////////////////////////////////////////////////////////////////////

void 
WNameDialog::setValidChars(const QString& strValid)
{
  LineEditNewName->setValidChars(strValid);
}

/////////////////////////////////////////////////////////////////////////////

void
WNameDialog::restrictNullString(bool bRestrict)
{
  bRestrictNullString = bRestrict;
}

/////////////////////////////////////////////////////////////////////////////

void 
WNameDialog::slotOk()
{
  if ( LineEditNewName->text() == "" ) {
    KMessageBox::sorry(this, i18n("A track has to have name."));
    return;
  }
  accept();
}

/////////////////////////////////////////////////////////////////////////////

#include "wnamedialog.moc"
