/***************************************************************************/
/*! \file   wvoxstorm.h
    \brief  饹WVoxStormΥإåե롣
    \author Tomoaki Murakami
    \date   2004ǯ  5  4  15:41:12 JST
*/
/***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef _WVOXSTORM_H_
#define _WVOXSTORM_H_

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <sys/types.h>
#include <qwidget.h>
#include <qpushbutton.h>
#include <qstring.h>
#include <qpixmap.h>
#include <qdom.h>
#include <kapp.h>
#include <kmainwindow.h>
#include <kaction.h>
#include "wvoxbase.h"
#include "wprefdialog.h"
#include "cecaiamanager.h"

/*-------------------------------------------------------------------------*/
/*! \class  WVoxStorm
    \brief  ץꥱΥᥤ󥦥ɥ
    ˥塼ġСơСʤɤĥץꥱ
    ȥꥦɥ
*/
/*-------------------------------------------------------------------------*/
class WVoxStorm : public KMainWindow
{
  Q_OBJECT

public:
  //! \brief 󥹥ȥ饯
  //! \param WidgetParent ƥåȤؤΥݥ󥿡
  //! \param cName åȤ̾Ρ
  WVoxStorm(QWidget* WidgetParent=0, const char *cName=0);
  //! \brief 󥹥ȥ饯
  //! \param strFileName VoxStormåե̾Ρ
  //! \param WidgetParent ƥåȤؤΥݥ󥿡
  //! \param cName åȤ̾Ρ
  WVoxStorm(const QString& strFileName, QWidget* WidgetParent=0, const char *cName=0);
  //! \brief ǥȥ饯
  ~WVoxStorm();

  //! \brief եξPreferencesɤ߹ࡣ
  void readConfigurationFile();
  //! \brief եPreferecesξ񤭹ࡣ
  void writeConfigurationFile();

protected:
  //! \brief ɥ׵Υ٥ȥϥɥ
  bool queryClose();

private:
  //! ȥåץ٥Υᥤ󥦥åȡ
  WVoxBase    *VoxBase;
  //! ơСΤᡣ
  QLabel      *LabelStatusBar;
  //! Vox Stormåե̾Ρ
  QString      strSessionFile;
  //! Ecasound-IAޥ͡㡣
  CEcaIAManager EcaIAManager;
  //! 
  SPreferences Preferences;
  //! DOMɥ
  QDomDocument  *pDocVox;
  //! Ͽ˥塼ID
  int          nMenuIDRec;
  //! ϿġܥID
  int          nToolIDRec;
  //! Ͽ
  KToggleAction* ToggleActionRec;
  //! 󥿥饯ƥ֥⡼ɥ
  KToggleAction* ToggleActionInteractive;
  //! ƥե饰
  bool         bDirty;

  //! \brief ŪʽԤ
  void initialize();
  //! \brief νԤ
  void setupActions();
  //! \brief ơСνԤ
  void setupStatusBar();

  //! \brief ѹ뤫ɤȽǤ롣
  bool isChanged() const;
  //! \brief 椫ɤȽǤ롣
  bool isPlaying();
  //! \brief ¸Ԥ桼˿Ҥͤ롣
  bool maybeSave();
  //! \brief ֿ׻˥ǥեȤΥե̾Τư롣
  QString createNewUntitledName() const;
  //! \brief  ߤΥե̾Τ饻å̾Τꤷ֤
  //! \return å̾Ρ
  QString sessionName() const;
  //! \brief åե򳫤
  //! \brief strFileName ե̾Ρ
  void loadFile(const QString& strFileName);
  //! \brief ¸Ԥ
  //! \param strFileName ¸ե̾Ρ
  void saveFile(const QString& strFileName);
  //! \brief ߤΥåե򥢥ץꥱꤹ롣
  void setCurrentFile(const QString& strFileName);
  //! \brief 󥿥饯ƥ֥⡼ɤؽꤹ롣
  //! \param bEnter Ȥϡtrueꡣ
  void enterIAMode(bool bEnter);
  //! \brief 󥿥饯ƥ֥⡼ɤξ֤ˤäơ
  //! åȤξ֤ѹ롣
  void setWidgetsByIAState();
  //! \brief Vox Storm󥹥󥹤ξ֤
  //! DOMΡɤ֤
  QDomNode stateInDOM();

private slots:
  //! \brief ֿפꤵ줿Υåȡ
  void slotNew();
  //! \brief ֳפꤵ줿Υåȡ
  void slotOpen();
  //! \brief ¸פꤵ줿Υåȡ
  bool slotSave();
  //! \brief ̾Ĥ¸פꤵ줿Υåȡ
  bool slotSaveAs();
  //! \brief ֺפꤵ줿Υåȡ
  void slotPlay();
  //! \brief Ͽפꤵ줿Υåȡ
  void slotRecord();
  //! \brief ְߡפꤵ줿Υåȡ
  void slotPause();
  //! \brief ߡפꤵ줿Υåȡ
  void slotStop();
  //! \brief ֻפꤵ줿Υåȡ
  void slotJumpToStart();
  //! \brief ִᤷפꤵ줿Υåȡ
  void slotRewind();
  //! \brief פꤵ줿Υåȡ
  void slotForward();
  //! \brief פꤵ줿Υåȡ
  void slotPreferences();
  //! \brief ֥󥿥饯ƥ֥⡼ɡפꤵ줿Υåȡ
  void slotInteractive();
  //! \brief ֥ȥåɲáפꤵ줿Υåȡ
  void slotAddTrack();
  //! \brief ֥ȥåνפꤵ줿Υåȡ
  void slotTrackOrder();

  //! \brief ȥå꤬ѹ줿Υåȡ
  //! ץ쥤ХåǥХѹ
  void slotChangePlaybackDevice(const QString& strTrackName, const QString& strFileName);
  //! \brief ȥå꤬ѹ줿Υåȡ
  //! 쥳ǥ󥰥ǥХѹ
  void slotChangeRecordingDevice(const QString& strTrackName, const QString& strFileName);
  //! \brief ȥå줿Υåȡ
  void slotRemoveTrack(const QString& strTrackName);
  //! \brief ȥå꤬ѹ줿Υåȡ
  //! ե̾ѹ
  void slotChangeFileName(const QString& strTrackName, const QString& strFileName);
  //! \brief ȥå꤬ѹ줿Υåȡ
  //! ٥ѹ
  void slotChangeLevel(const QString& strTrackName, int nLevel);
  //! \brief ȥå꤬ѹ줿Υåȡ
  //! ѥѹ
  void slotChangePan(const QString& strTrackName, int nPan);
  //! \brief ȥå꤬ѹ줿Υåȡ
  //! ߥ塼Ⱦѹ
  void slotToggleMute(const QString& strTrackName, bool bMute);
  //! \brief ȥå꤬ѹ줿Υåȡ
  //! Ͽѹ
  void slotToggleRec(const QString& strTrackName, bool bRec);
  //! \brief ȥå꤬ѹ줿Υåȡ
  //! ϰѹ
  void slotChangeStartPosition(const QString& strTrackName, const QTime& TimeStartPosition);
  //! \brief ȥå꤬ѹ줿Υåȡ
  //! եåѹ
  void slotChangeOffset(const QString& strTrackName, const QTime& TimeOffset);
  //! \brief ȥå꤬ѹ줿Υåȡ
  //! Ĺѹ
  void slotChangeLength(const QString& strTrackName, const QTime& TimeLength);

  //! \brief EcasoundIA⡼ɺλΥåȡ
  void slotFinish();
};

#endif // _WVOXSTORM_H_
