/***************************************************************************/
/*! \file   wprefdialog.h
    \brief  饹WPrefDialogΥإåե롣
    Ǽ¤WPreferencesԤ
    \author Tomoaki Murakami
    \date   2004ǯ  5  4  16:41:12 JST
*/
/***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef _WPREFDIALOG_H_
#define _WPREFDIALOG_H_

#include <qstring.h>
#include <qstringlist.h>
#include <kdialogbase.h>
#include <kcombobox.h>
#include <klistbox.h>
#include <krestrictedline.h>
#include <knuminput.h>
#include "wfilechooser.h"
#include "cvoxstormglobal.h"


/*-------------------------------------------------------------------------*/
/*! \struct SPreferences
    \brief  Ǽ뤿ι¤Ρ
*/
/*-------------------------------------------------------------------------*/
struct SPreferences
{
  //! ǥХ
  QString              strPlayDevice;
  //! ϿǥХ
  QString              strRecDevice;
  //! ե륿ס
  CVoxStormGlobal::FileType FileType;
  //! ץ¸ǥեȥѥ
  QString              strProjectPath;
  //! ץ󥰥졼ȡ
  uint                 uiSampleRate;
  //! ץХåե
  uint                 uiBuffer;
  //! Υǥեȥȥå̾Ρ
  QStringList          strlDefaultTracks;
  //! ᤷÿ
  int                  iFrameSeconds;
};


/*-------------------------------------------------------------------------*/
/*! \class  WPrefDialog
    \brief  ץꥱΤΥ
    ecasoundꡢǥХ򡢥ץ¸ǥ쥯ȥꡢ
    ե¸ǥ쥯ȥԤ
*/
/*-------------------------------------------------------------------------*/
class WPrefDialog : public KDialogBase
{
  Q_OBJECT
public:
  //! \brief 󥹥ȥ饯
  //! \param WidgetParent ƥåȤؤΥݥ󥿡
  //! \param cName åȤ̾Ρ
  WPrefDialog(QWidget* WidgetParent=0, const char *cName=0);
  //! \brief ǥȥ饯
  ~WPrefDialog();

  //! \brief ȿǤ롣
  //! \param PreferencesSet ȿǤǼ롣
  void setFields(const SPreferences& PreferencesSet);
  //! \brief γ롣
  SPreferences fields();

protected:

private:
  //! \brief ǥХڡꤹ롣
  void setupDevicesPage();
  //! \brief եڡꤹ롣
  void setupFilePage();
  //! \brief ɥڥåڡꤹ롣
  void setupSoundSpecPage();
  //! \brief ȥåڡꤹ롣
  void setupTrackPage();
  //! \brief ̥ڡꤹ롣
  void setupGenericPage();

  //! ѥǥХΤΥåȡ
  WFileChooser    *FileChooserPlay;
  //! ϿѥǥХΤΥåȡ
  WFileChooser    *FileChooserRec;

  //! եΤΥåȡ
  KComboBox       *ComboBoxFileType;
  //! ץ¸ΤΥåȡ
  WFileChooser    *DirChooserProject;

  //! ץ󥰥졼ΤΥåȡ
  KComboBox       *ComboBoxSampleRate;
  //! ץΥХåեΤΥåȡ
  KComboBox       *ComboBoxBuffer;

  //! ǥեȥȥå̾ɲäΤΥåȡ
  KRestrictedLine *LineEditName;
  //! ǥեȥȥå̾ɲäΤΥåȡ
  QPushButton     *PushButtonAdd;
  //! ǥեȥȥåꥹȤ뤿Υåȡ
  KListBox        *ListBoxTracks;
  //! ǥեȥȥåνѹ뤿Υåȡء
  QPushButton     *PushButtonUp;
  //! ǥեȥȥåνѹ뤿Υåȡء
  QPushButton     *PushButtonDown;
  //! ǥեȥȥåκԤΥåȡ
  QPushButton     *PushButtonRemove;

  //! ᤷÿΤΥåȡ
  KIntNumInput    *IntNumInputFrameSeconds;

private slots:
  //! \brief ǥեȥȥå̾ΥǥåѹΥåȡ
  //! \param strTrack ǥåȤϤƤ벾Υȥå̾Ρ
  void slotChangeAddState(const QString& strTrack);
  //! \brief ǥեȥȥå˿ȥå̾ΤɲäΥåȡ
  void slotAddTrackToList();
  //! \brief ǥեȥȥåꥹȤ֤ѹ줿Υåȡ
  void slotChangeTrackSelection();
  //! \brief ־ءפå줿Υåȡ
  void slotTrackUp();
  //! \brief ֲءץܥ󤬥å줿Υåȡ
  void slotTrackDown();
  //! \brief ǥեȥȥå򤵤줿ȥå̾ΤΥåȡ
  void slotRemoveTrackFromList();
};

#endif
