/***************************************************************************/
/*! \file   cvoxstormglobal.h
    \brief  饹CVoxStormGlobalΥإåե롣
    \author Black Sabbath
    \date   2004ǯ  5  4  17:06:12 JST
*/
/***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef _CVOXSTORMGLOBAL_H_
#define _CVOXSTORMGLOBAL_H_

#include <qstring.h>
#include <qstringlist.h>

/*-------------------------------------------------------------------------*/
/*! \class CVoxStormGlobal
    \brief CVoxStormGlobal֤̾
    ѥθߴΤ˥饹Ȥ롣
    Do not create instance of this class.
*/
/*-------------------------------------------------------------------------*/
class CVoxStormGlobal
{
public:
  //! ȥå̾Τ˻ѤǤʸΥȥꡣ
  static const QString ValidCharsTrack;

  //! ȥå
  enum FileType
  {
    ecaWAV = 0,
    ecaMP3
  };

  //! \brief strSrc˥ơǰϤޤ줿ʸ󤬤ä硢
  //! ʸ"//0//""//1//""//2//"֤ʸ֤
  //! pstrlOrgˤϡ֤ʸ(ơ򳰤)
  //! Ǽ롣\n
  //!  strSrcʲʸä硢\n
  //! "abcde" abc"de" \\"abcde\\"\n
  //! ʲΤ褦Ѵ롣\n
  //! //0// abc//1// "abcde"
  //   strSrcʲʸä硢
  //  "abcde  abc"de" \"abcde\"
  //  ʲΤ褦Ѵ롣
  //  //0// abc//1// "abcde"
  //! \param strSrc Ѵʸ
  //! \param pstrlOrg ִγʸǼ뤿ΰ衣
  static QString replaceQuartedToSlash(const QString& strSrc,
                                       QStringList* pstrlOrg);

  //! \brief  ʸꥹȤ˻ꤷʸ¸ߤƤ뤫ɤĴ
  //! ¸ߤƤϡʸΥǥ֤
  //! \param  strSrc ʸ
  //! \param  strlList ʸꥹȡ
  //! \return strSrcstrlList¸ߤƤ硢strlList
  //! ǽ˸Ĥäб륤ǥ֤
  //! ¸ߤƤʤϡ-1֤
  static int findStringFromList(const QString& strSrc,
                                const QStringList& strlList);

  //! \brief  ʸ˥ڡޤޤƤ硢
  //! ֥륯ȤǰϤʸ֤
  //! ڡޤޤƤʤ硢Ϳ줿ʸ򤽤Τޤ֤
  //! \param  strSrc Ĵ٤ʸ
  //! \return strSrc˥ڡޤޤƤС֥륯ȤǰϤޤ줿ʸ
  //! ڡޤޤƤʤϡstrSrcʸ
  static QString fenceString(const QString& strSrc);

  //! \brief  VoxStormݡȤƤ벻ե̾ɤ֤
  //! \param  strFileName ե̾Ρ
  static bool isSupportedFileType(const QString& strFileName);

private:
  //! \brief 󥹥󥹲ػߤ뤿Υߡؿ
  virtual void dummy() = 0;
};

#endif
