/***************************************************************************/
/*! \file   wvoxtrack.h
    \brief  饹WVoxTrackΥإåե롣
    \author Tomoaki Murakami
    \date   2004ǯ  5  4  16:58:12 JST
*/
/***************************************************************************/

/***************************************************************************
 *   Copyright (C) 2004 by Tomoaki Murakami                                *
 *   solarisphrere@yahoo.co.jp                                             *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef WVOXTRACK_H
#define WVOXTRACK_H

#include <qhbox.h>
#include <qvbox.h>
#include <qlabel.h>
#include <qpopupmenu.h>
#include <qpushbutton.h>
#include <qdom.h>
#include <qvaluevector.h>
#include <knuminput.h>
#include "wfilechooser.h"
#include "wsoundlocator.h"
#include "ctrackinf.h"
#include "cladspaeffect.h"

/*-------------------------------------------------------------------------*/
/*! \class  WVoxTrack
    \brief  ȥååȡ
    ȥåɽEcasoundΥ롣
    ե̾λꡢ쥳ǥ󥰥ȥåȤƻꡢ
    ߥ塼ȥȥåȤƻꤹʤɤԤȤǤ롣
    ƥåȤʣWVoxTrack硢ƥʥ
    ̻ҤȤȯԤ롣
    ̻Ҥˤϥȥå̾ΤѤ뤿ᡢWVoxTrack֤ǰդ
    ʸȤʤʤФʤʤ
*/
/*-------------------------------------------------------------------------*/
class WVoxTrack : public QWidget
{
  Q_OBJECT

public:
  //! \brief 󥹥ȥ饯
  //! \param strName ȥå̾Ρ
  //! \param strDeviceIn ϥǥХ
  //! \param strDeviceOut ϥǥХ
  //! \param timeMaxSession åĹ
  //! \param WidgetParent ƥåȤؤΥݥ󥿡
  //! \param cName åȤ̾Ρ
  WVoxTrack(const QString& strName,
            const QString& strDeviceIn,
            const QString& strDeviceOut,
            const QTime&   timeMaxSession, 
            QWidget*       WidgetParent=0,
            const char*    cName=0);
  //! \brief 󥹥ȥ饯
  //! \param trackInf ȥå
  //! \param timeMaxSession åĹ
  //! \param WidgetParent ƥåȤؤΥݥ󥿡
  //! \param cName å̾Ρ
  WVoxTrack(const CTrackInf& trackInf, 
            const QTime&     timeMaxSession, 
            QWidget*         WidgetParent=0,
            const char*      cName=0);
  //! \brief ǥȥ饯
  virtual ~WVoxTrack();

  //! \brief ȥå̾Τ롣
  QString   name() const;
  //! \brief ץ쥤ХåǥХ̾롣
  QString   playbackDevice() const;
  //! \brief 쥳ǥ󥰥ǥХ̾롣
  QString   recordingDevice() const;
  //! \brief ꤵƤΥ٥롣
  //! 0100ϰϡ
  int       level() const;
  //! \brief ꤵƤΥѥ롣
  //! 0100ϰϡ
  int       pan() const;
  //! \brief ϸΥե̾Τ롣
  QString   fileName() const;
  //! \brief ϰ֤֤
  QTime     startPosition() const;
  //! \brief եåȤ֤
  QTime     offset() const;
  //! \brief ֤֤
  QTime     length() const;
  //! \brief ߥ塼ȤꤵƤ뤫ɤ롣
  bool      isMuted() const;
  //! \brief 쥳ǥ󥰥ȥåȤꤵƤ뤫ɤ롣
  bool      isSetRec() const;
  //! \brief ե̾ꤵƤ뤫ɤ֤
  bool      isBindedToFile() const;
  //! \brief եȤ֤
  QValueVector<CLadspaEffect> effects() const;
  //! \brief ХѥꤵƤ뤫ɤ롣
  bool      isBypassed() const;
  //! \brief ȥåξ礷Ƽ롣
  CTrackInf stateInTrackInf() const;
  //! \brief  󥹥󥹤ξ֤DOM֤
  //! \param  pDoc   DOMɥȡ
  //! \return DOMΡɡ
  QDomNode  stateInDOM(QDomDocument* pDoc) const;

  //! \brief ȥå̾Τꤹ롣
  //! \param strName ȥå̾Ρ
  void      setName(const QString& strName);
  //! \brief ٥ꤹ롣
  //! \param nLevel ٥롣400ޤǤϰϡ
  void      setLevel(int nLevel);
  //! \brief ѥꤹ롣
  //! \param nPan ѥ0100ޤǤϰϡ
  void      setPan(int nPan);
  //! \brief ե̾Τꤹ롣
  //! \param strFileName ե̾Ρ
  void      setFileName(const QString& strFileName);
  //! \brief ߥ塼Ȥꤹ롣
  //! \param bMute ߥ塼Ȥξ硢true
  void      setMute(bool bMute);
  //! \brief 쥳ǥ󥰥ȥåɤꤹ롣
  //! \param bRecPort 쥳ǥ󥰥ȥåξ硢true
  void      setRec(bool bRecPort);
  //! \brief ȥåξ֤CTrackInfꤹ롣
  //! \param trackInfSet ꤵȥå
  void      setStateByTrackInf(const CTrackInf& trackInfSet);

  //! \brief  ȥåκĹꤹ롣
  void      setMaxSessionLength(const QTime& time);

  //! \brief  ȥå򥹥뤹롣
  //! \param  x Xɸ
  void      scrollLocator(int x);

  //! \brief  Ū˥褹롣
  void      forceRepaintLocator();

  //! ߥ塼ȥȥܥ
  static unsigned int Mute;
  //! Ͽȥܥ
  static unsigned int Record;
  //! ե塼
  static unsigned int File;
  //! ݥåץåץ˥塼
  static unsigned int Remove;
  //! ǥХѹݥåץåץ˥塼
  static unsigned int Device;
  //! ϰѹݥåץåץ˥塼
  static unsigned int StartPosition;
  //! Υեåѹݥåץåץ˥塼
  static unsigned int Offset;
  //! ѹݥåץåץ˥塼
  static unsigned int Length;

protected:
  //! \brief ޥץ쥹줿Υ٥ȥϥɥ顣
  //! \param MouseEvent ޥ٥Ⱦ
  void      mousePressEvent(QMouseEvent* MouseEvent);
  //! \brief ޥ֥륯å줿Υ٥ȥϥɥ顣
  //! \param MouseEvent ޥ٥Ⱦ
  void      mouseDoubleClickEvent(QMouseEvent* MouseEvent);

private:
  //! ץ쥤ХåǥХ
  QString strInputDevice;
  //! 쥳ǥ󥰥ǥХ
  QString strOutputDevice;
  //! ϰ֡
  QTime timeStartPosition;
  //! եåȡ
  QTime timeOffset;
  //! ֡
  QTime timeLength;

  //! ¦Υ١åȡ
  QVBox         *VBoxController;
  //! VBoxController̾Υ٥ȥ٥륹饤Υ١åȡ
  QHBox         *HBoxStandard;
  //! VBoxControllerΥե塼ȥܥ󷲤Υ١åȡ
  QHBox         *HBoxButtonBase;
  //! ȥå̾Ρ
  QLabel        *LabelName;
  //! ٥ȥѥꥦåȡ
  QVBox         *VBoxValue;
  //! ٥ѥ饤ҥȡ
  QLabel        *LabelLevel;
  //! ٥ѥ饤
  KIntNumInput  *IntNumInputLevel;
  //! ѥѥ饤ҥȡ
  QLabel        *LabelPan;
  //! ѥѥ饤
  KIntNumInput  *IntNumInputPan;
  //! ϸΥեꤹ뤿Υåȡ
  WFileChooser  *FileChooserTrack;
  //! ڡ
  QWidget       *WidgetSpacer;
  //! ߥ塼ȤON/OFFꤹܥ
  QPushButton   *PushButtonMute;
  //! 쥳ǥ󥰤ON/OFFꤹܥ
  QPushButton   *PushButtonRec;
  //! ХѥON/OFFꤹܥ
  QPushButton   *PushButtonBypass;
  //! ɥ
  WSoundLocator *Locator;
  //! ݥåץåץ˥塼
  QPopupMenu    *PopupMenu;
  //! ˥塼ID()
  int            nMenuIDRemove;
  //! ˥塼ID(̾ѹ)
  int            nMenuIDRename;
  //! ˥塼ID(ץ쥤ХåǥХ)
  int            nMenuIDPlaybackDevice;
  //! ˥塼ID(쥳ǥ󥰥ǥХ)
  int            nMenuIDRecordingDevice;
  //! ˥塼ID(ϰ)
  int            nMenuIDStartPosition;
  //! ˥塼ID(եå)
  int            nMenuIDOffset;
  //! ˥塼ID()
  int            nMenuIDLength;
  //! ˥塼ID(ե)
  int            nMenuIDEffects;
  //! ˥塼ID(ץѥƥ)
  int            nMenuIDProperty;
  //! եȡ
  QValueVector<CLadspaEffect> fxs;

  //! \brief åȤꡣ
  //! 󥹥ȥ饯Τ߸ƤӽФġ
  //! åĹ
  void setupWidgets(const QTime& timeMaxSession);
  //! \brief ݥåץåץ˥塼ꡣ
  //! 󥹥ȥ饯Τ߸ƤӽФġ
  void setupPopupMenu();

public slots:
  //! \brief ꤵ줿åȤ̵ͭꤹ륹åȡ
  //! \param unWidgets åȤӥåȤǻꡣ
  //! \param bEnabled  ꤵ줿åȤͭˤ硢trueꡣ
  void slotSetEnabledWidgets(unsigned int unWidgets, bool bEnabled);

  //! \brief ϰ֤ꤹ롣
  void slotSetStartPosition(const QTime& time);
  //! \brief եåȤꤹ롣
  void slotSetOffset(const QTime& time);
  //! \brief ֤ꤹ롣
  void slotSetLength(const QTime& time);
  
private slots:
  //! \brief ե̾ѹΥåȡ
  void slotChangedFileName(const QString& strFileName);

  //! \brief ץ쥤ХåǥХѹ׵Υåȡ
  void slotChangePlaybackDevice();
  //! \brief 쥳ǥ󥰥ǥХѹ׵Υåȡ
  void slotChangeRecordingDevice();
  //! \brief ꤵ줿Υåȡ
  //! åܥåǺγǧԤ
  void slotRemove();
  //! \brief ̾ѹ׵Υåȡ
  //! ̾ɽ롣
  void slotRename();
  //! \brief ϰ׵ṹΥåȡ
  void slotChangeStartPosition();
  //! \brief եåѹ׵Υåȡ
  void slotChangeOffset();
  //! \brief ѹ׵Υåȡ
  void slotChangeLength();
  //! \brief եѹ׵Υåȡ
  void slotEditEffects();
  //! \brief ץѥƥɽ׵Υåȡ
  void slotProperty();

  //! ѡ
  void slotMovedContents(int x);
  //! ߥ塼ȥȥܥȥΥåȡ
  void slotToggledMute(bool bToggled);
  //! ϿȥܥȥΥåȡ
  void slotToggledRec(bool bToggled);

signals:
  //! \brief ץ쥤ХåǥХѹΥʥ롣
  void playbackDeviceChanged(const QString&);
  //! \brief 쥳ǥ󥰥ǥХѹΥʥ롣
  void recordingDeviceChanged(const QString&);
  //! \brief Υʥ롣
  void removed();
  //! \brief ե̾ѹΥʥ롣
  void fileNameChanged(const QString&);
  //! \brief ٥ѹΥʥ롣
  void levelChanged(int);
  //! \brief ѥѹΥʥ롣
  void panChanged(int);
  //! \brief ߥ塼Ⱦ֤ѹ줿Υʥ롣
  void muteToggled(bool);
  //! \brief Ͽ֤ѹ줿Υʥ롣
  void recToggled(bool);
  //! \brief ϰ֤ѹ줿Υʥ롣
  void startPositionChanged(const QTime&);
  //! \brief եåȤѹ줿Υʥ롣
  void offsetChanged(const QTime&);
  //! \brief Ĺѹ줿Υʥ롣
  void lengthChanged(const QTime&);
  //! \brief եȤѹ줿Υʥ롣
  void effectsChanged(const QValueVector<CLadspaEffect>&);
  //! \brief Хѥ֤ѹ줿Υʥ롣
  void bypassToggled(bool);

  //! \brief ץѥƥɽ׵ᤵ줿Υʥ롣
  void propertyDemanded(const CTrackInf&);

  //! \brief 뤵줿ȯ륷ʥ롣
  void locatorScrolled(QObject* ObjectSender, int);

  //! \brief ֤ѹ줿Υʥ롣
  //! ᥤѹʤΤǡȥåϤʤ
  void stateChanged();
};

#endif
