/***************************************************************************/
/*! \file   wvoxbase.h
    \brief  饹WBoxBaseΥإåե롣
    \author Tomoaki Murakami
    \date   2004ǯ  5  4  17:10:12 JST
*/
/***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef WVOXBASE_H
#define WVOXBASE_H

#include <qsignalmapper.h>
#include <qvbox.h>
#include <qlayout.h>
#include <qvaluevector.h>
#include <qdatetimeedit.h>
#include <qtabwidget.h>
#include <qdom.h>
#include <ktextedit.h>
#include "wvoxtrack.h"
#include "wtrackproperty.h"
#include "ctrackinf.h"

/*-------------------------------------------------------------------------*/
/*! \class  WVoxBase
    \brief  ץꥱΥ١åȡ
    ˳ƥȥå롣
*/
/*-------------------------------------------------------------------------*/
class WVoxBase : public QVBox
{
  Q_OBJECT
public:
  //! \enum  TabType
  //! \brief ֥ס
  enum TabType
  {
    CommandLine,
    Console
  };

  //! \enum  State
  //! \brief ֡
  enum State
  {
    Play,
    Pause,
    Stop
  };

  //! \brief 󥹥ȥ饯
  //! \param WidgetParent ƥåȤؤΥݥ󥿡
  //! \param cName åȤ̾Ρ
  WVoxBase(QWidget* WidgetParent=0, const char *cName=0);
  //! \brief 󥹥ȥ饯
  //! \param nodBase DOMΡɡ
  //! \param WidgetParent ƥåȤؤΥݥ󥿡
  //! \param cName åȤ̾Ρ
  WVoxBase(const QDomNode& nodBase, QWidget* WidgetParent=0, const char *cName=0);
  //! \briefǥȥ饯
  virtual ~WVoxBase();

  //! \brief ȥåɲäԤ
  //! addTrack(const QString& strTrackName)Υåѡؿ
  //! ɽ̾Ϥ¥
  //! ǻꤵ줿ȥå̾ΤåԤ
  //! \param strDeviceIn ϥǥХ
  //! \param strDeviceOut ϥǥХ
  void addTrack(const QString& strDeviceIn, const QString& strDeviceOut);
  //! \brief ȥåɲäԤ
  //! ȥå̾strTrackNameåϹԤʤ
  //! \param strTrackName ȥå̾Ρ
  //! \param strDeviceIn ϥǥХ
  //! \param strDeviceOut ϥǥХ
  void addTrack(const QString& strTrackName, 
                const QString& strDeviceIn,
                const QString& strDeviceOut);
  //! \brief DOMΡpNodTracksꤵƤΥȥåɲäԤ
  //! ȥå̾ΤåϹԤʤ
  //! \param nodTracks ȥå󤬳Ǽ줿DOMΡɡ
  void addTracks(const QDomNode& nodTracks);
  //! \brief  ȥåκԤ
  void clearTracks();
  //! \brief ȥåκԤ
  //! removeTrack(const QString& strTrackName)Υåѡؿ
  void removeTrack();
  //! \brief ȥåκԤ
  //! \param strTrackName ȥå̾Ρ
  void removeTrack(const QString& strTrackName);
  
  //! \brief ߤΥȥå֤
  int getTrackCount() const;
  //! \brief  ꤷȥåξ롣
  //! \param  nID ȥåID(from zero)
  //! \return ȥå
  CTrackInf getTrackInf(int nID) const;
  //! \brief  ꤷȥåξ롣
  //! \param  strTrackName ȥå̾Ρ
  //! \return ȥå
  CTrackInf getTrackInf(const QString& strTrackName) const;
  //! \brief  ꤵ줿ȥå̾Τ¸ߤ뤫䤤碌롣
  //! \param  strName 䤤碌ȥå̾Ρ
  //! \return strName¸ߤȥå̾Τξ硢true֤
  bool queryExistingTrackName(const QString& strName) const;
  //! \brief  ȥå̾ΤѹԤ
  //! \param  strOldName ̾Ρ
  //! \param  strNewName ̾Ρ
  bool requestChangeName(const QString& strOldName, const QString& strNewName) const;

  //! \brief  Ecasoundޥɥ饤ɽ롣
  //! \param  strCmd Ecasoundޥɥ饤ʸ
  void setEcasoundCmd(const QString& strCmd);
  //! \brief  ɽΥޥɥ饤롣
  QString ecasoundCmd() const;

  //! \brief  󥹥󥹤ξ֤DOM֤
  //! \param  pDoc DOMɥȡ
  //! \return DOMΡɡ
  QDomNode stateInDOM(QDomDocument* pDoc);

  //! \brief  åκĹꤹ롣
  void setMaxSessionLength(const QTime& time);

  //! \brief  ɽˤʤȥå֤
  //! \param  nOrder nOrderܤɽƤȥå֤
  //!         from zero
  CTrackInf trackInfByDisplayOrder(int nID) const;

protected:
  void resizeEvent(QResizeEvent* Event);

private:
  //! ϰ֤ɽ뤿Υåȡ
  QTimeEdit     *TimeEditPosition;
  //! ʹԻɽѥåȡ
  QLabel        *LabelProceed;
  //! ʹԻɽѥåȡ
  QTimeEdit     *TimeEditProceed;
  //! ȥåǼ٥
  QValueVector<WVoxTrack*> vVoxTracks;
  //! ȥå֤뤿Υ쥤ȡ
  QVBoxLayout   *VLayoutTracks;
  //! ȥåɽΤΥåȡ
  QFrame        *FrameTracks;
  //! ̤ɽΰ衣
  QTabWidget    *Tab;
  //! Ecasoundޥɥ饤ϤΤΥǥåȡ
  KTextEdit     *TextEditCmdLine;
  //! EcasoundνϷ̤ɽΰ衣
  KTextEdit     *TextEditEcasound;
  //! ȥåץѥƥɽ뤿Υåȡ
  WTrackProperty *TrackProperty;
  //! ȥåץ쥤ХåǥХ̾ѹΤΥʥޥåѡ
  QSignalMapper *SignalMapperPlayback;
  //! ȥå쥳ǥ󥰥ǥХ̾ѹΤΥʥޥåѡ
  QSignalMapper *SignalMapperRecording;
  //! ȥåΤΥʥޥåѡ
  QSignalMapper *SignalMapperRemove;
  //! ȥåե̾ѹΤΥʥޥåѡ
  QSignalMapper *SignalMapperFileName;
  //! ȥå٥ѹΤΥʥޥåѡ
  QSignalMapper *SignalMapperLevel;
  //! ȥåѥѹΤΥʥޥåѡ
  QSignalMapper *SignalMapperPan;
  //! ȥåߥ塼ȾѹΤΥʥޥåѡ
  QSignalMapper *SignalMapperMute;
  //! ȥåϿѹΤΥʥޥåѡ
  QSignalMapper *SignalMapperRec;
  //! ȥåϰѹΤΥʥޥåѡ
  QSignalMapper *SignalMapperStartPosition;
  //! ȥåեåѹΤΥʥޥåѡ
  QSignalMapper *SignalMapperOffset;
  //! ȥåĹѹΤΥʥޥåѡ
  QSignalMapper *SignalMapperLength;
  //! եѹΤΥʥޥåѡ
  QSignalMapper *SignalMapperEffects;
  //! ХѥѹΤΥʥޥåѡ
  QSignalMapper *SignalMapperBypass;

  //! åĹ
  QTime         timeMaxSessionLength;

  //! ʹԻ֡
  QTime         timeProceed;

  //! ΤΥ٥
  mutable QValueVector<WVoxTrack*> vTrackOrder;

  //! åȤꡣ
  //! 󥹥ȥ饯Τ߸ƤӽФġ
  void setupWidgets();
  //! \brief ȥå̾ΤбȥåΥǥ֤
  //! ꤵ줿ȥå̾ΤбȥåĤʤ硢
  //! -1֤롣
  //! \param strTrackName ȥå̾Ρ
  int getIndexByName(const QString& strTrackName) const;
  //! \brief ɬפ˱ƥȥå٥եå夹롣
  void refreshTrackOrderVector() const;

public slots:
  //! \brief 󥽡å񤭹ߤԤåȡ
  //! \param strMessage 󥽡˽񤭹å
  void slotWriteConsoleMessage(const QString& strMessage);
  //! \brief ֤ڤؤ롣
  void slotChangeMessageTab(TabType type);
  //! \brief  ߤȼäơΥåȤ̵ͭꤹ롣
  //! \param  state ξWVoxBase::Playꡢ
  //! ߤξWVoxBase::StopꡢߤξKWVoxBase::Pauseꡣ
  void slotChangeState(State state);
  //! \brief  Ͽλ˸ƤӽФ٤åȡ
  //! ȥåΤϿꤵƤΤΥեåȡ֡Ĺ򥼥ˤ롣
  void slotNotifySucceedInRecording();
  //! \brief  ʹԻ֤륹åȡ
  void slotNotifyCurrentTime(const QTime& time);
  //! \brief  ȥåѹ륹åȡ
  void slotChangeTrackOrder(QValueVector<int> vOrder);

private slots:
  //! \brief ϰ֤ѹ륹åȡ
  void slotChangePosition(const QTime& time);

  //! \brief ץ쥤ХåǥХѹФ륹åȡ
  void slotChangePlaybackDevice(const QString& strTrackName);
  //! \brief 쥳ǥ󥰥ǥХѹФ륹åȡ
  void slotChangeRecordingDevice(const QString& strTrackName);
  //! \brief ȥå׵Ф륹åȡ
  void slotRemove(const QString& strTrackName);
  //! \brief ȥåե̾ѹФ륹åȡ
  //! \param strTrackName ȥå̾Ρ
  void slotChangeFileName(const QString& strTrackName);
  //! \brief ȥå٥ѹФ륹åȡ
  //! ǥʥȯ롣
  //! \param strTrackName ȥå̾Ρ
  void slotChangeLevel(const QString& strTrackName);
  //! \brief ȥåѥѹФ륹åȡ
  //! ǥʥȯ롣
  //! \param strTrackName ȥå̾Ρ
  void slotChangePan(const QString& strTrackName);
  //! \brief ȥåߥ塼ȾѹФ륹åȡ
  //! ǥʥȯ롣
  //! \param strTrackName ȥå̾Ρ
  void slotToggleMute(const QString& strTrackName);
  //! \brief ȥåϿѹФ륹åȡ
  //! ǥʥȯ롣
  //! \param strTrackName ȥå̾Ρ
  void slotToggleRec(const QString& strTrackName);
  //! \brief ȥåϰѹФ륹åȡ
  //! ǥʥȯ롣
  //! \param strTrackName ȥå̾Ρ
  void slotChangeStartPosition(const QString& strTrackName);
  //! \brief ȥåեåѹФ륹åȡ
  //! ǥʥȯ롣
  //! \param strTrackName ȥå̾Ρ
  void slotChangeOffset(const QString& strTrackName);
  //! \brief ȥåĹѹФ륹åȡ
  //! ǥʥȯ롣
  //! \param strTrackName ȥå̾Ρ
  void slotChangeLength(const QString& strTrackName);
  //! \brief եѹФ륹åȡ
  //! ǥʥȯ롣
  //! \param strTrackName ȥå̾Ρ
  void slotChangeEffects(const QString& strTrackName);
  //! \brief ХѥѹФ륹åȡ
  //! ǥʥȯ롣
  //! \param strTrackName ȥå̾Ρ
  void slotToggleBypass(const QString& strTrackName);

  //! \brief ץѥƥɽ륹åȡ
  //! \param trackInf ȥå
  void slotDisplayProperty(const CTrackInf& trackInf);

  //! \brief ȥåΥΥ碌륹åȡ
  void slotSetScrollToAll(QObject* ObjectSender, int x);

signals:
  //! \brief ޥݥѹΥʥ롣
  void masterPositionChanged(const QTime&);

  //! \brief ץ쥤ХåǥХѹΥʥ롣
  void playbackDeviceChanged(const QString&, const QString&);
  //! \brief 쥳ǥ󥰥ǥХѹΥʥ롣
  void recordingDeviceChanged(const QString&, const QString&);
  //! \brief ȥåΥʥ롣
  void trackRemoved(const QString&);
  //! \brief ȥåե̾ѹΥʥ롣
  void fileNameChanged(const QString&, const QString&);
  //! \brief ȥå٥ѹΥʥ롣
  void levelChanged(const QString&, int);
  //! \brief ȥåѥѹΥʥ롣
  void panChanged(const QString&, int);
  //! \brief ȥåߥ塼ȾѹΥʥ롣
  void muteToggled(const QString&, bool);
  //! \brief ȥåϿѹΥʥ롣
  void recToggled(const QString&, bool);
  //! \brief ȥåϰѹΥʥ롣
  void startPositionChanged(const QString&, const QTime&);
  //! \brief ȥåեåѹΥʥ롣
  void offsetChanged(const QString&, const QTime&);
  //! \brief ȥåĹѹΥʥ롣
  void lengthChanged(const QString&, const QTime&);
  //! \brief եѹΥʥ롣
  void effectsChanged(const QString&, const QValueVector<CLadspaEffect>&);
  //! \brief ХѥѹΥʥ롣
  void bypassToggled(const QString&, bool);

  //! \brief ֤ѹ줿Υʥ롣
  //! ᥤѹʤΤǡȥåϤʤ
  void stateChanged();
};

#endif
