/***************************************************************************
                          wprefdialog.cpp  -  description
                             -------------------
    begin                : 2004ǯ  5  4  16:44:12 JST
    copyright            : (C) 2003 by Tomoaki Murakami
    email                : solarisphere@yahoo.co.jp
 ***************************************************************************/

/***************************************************************************
 *   Copyright (C) 2004 by Tomoaki Murakami                                *
 *   solarisphrere@yahoo.co.jp                                             *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include <sys/types.h>
#include <qlabel.h>
#include <qlayout.h>
#include <qframe.h>
#include <qhbox.h>
#include <qvbox.h>
#include <qhgroupbox.h>
#include <qvgroupbox.h>
#include <qpixmap.h>
#include <qpushbutton.h>
#include <kmessagebox.h>
#include <kiconloader.h>
#include <kglobal.h>
#include <klocale.h>
#include "wprefdialog.h"
#include "cvoxstormglobal.h"

/////////////////////////////////////////////////////////////////////////////

WPrefDialog::WPrefDialog(QWidget *WidgetParent, const char *cName)
  : KDialogBase(KDialogBase::IconList,
                i18n("Configure"), 
                Ok | Cancel,
                Ok,
                WidgetParent,
                cName)
{
  // ǥХڡ
  setupDevicesPage();
  // եڡ
  setupFilePage();
  // ɥڥåڡ
  setupSoundSpecPage();
  // ȥåڡ
  setupTrackPage();
  // ̥ڡ
  setupGenericPage();

  setMinimumHeight(380);
}

/////////////////////////////////////////////////////////////////////////////

WPrefDialog::~WPrefDialog()
{

}

/////////////////////////////////////////////////////////////////////////////

void
WPrefDialog::setFields(const SPreferences& preferencesSet)
{
  FileChooserPlay->setFileName(preferencesSet.strPlayDevice);
  FileChooserRec->setFileName(preferencesSet.strRecDevice);
 
  switch ( preferencesSet.FileType ) {
  case CVoxStormGlobal::ecaWAV:
    ComboBoxFileType->setCurrentItem(0);
    break;
  case CVoxStormGlobal::ecaMP3:
    ComboBoxFileType->setCurrentItem(1);
    break;
  default:
    ComboBoxFileType->setCurrentItem(0);
    break;
  }
  DirChooserProject->setFileName(preferencesSet.strProjectPath);

  switch ( preferencesSet.format.sampleFormat() ) {
  case CSourceFormat::U8:
    ComboBoxSampleFormat->setCurrentItem(0);
    break;
  case CSourceFormat::S16_LE:
    ComboBoxSampleFormat->setCurrentItem(1);
    break;
  case CSourceFormat::S16_BE:
    ComboBoxSampleFormat->setCurrentItem(2);
    break;
  case CSourceFormat::S24_LE:
    ComboBoxSampleFormat->setCurrentItem(3);
    break;
  case CSourceFormat::S24_BE:
    ComboBoxSampleFormat->setCurrentItem(4);
    break;
  case CSourceFormat::S32_LE:
    ComboBoxSampleFormat->setCurrentItem(5);
    break;
  case CSourceFormat::S32_BE:
    ComboBoxSampleFormat->setCurrentItem(6);
    break;
  case CSourceFormat::F32_LE:
    ComboBoxSampleFormat->setCurrentItem(7);
    break;
  case CSourceFormat::F32_BE:
    ComboBoxSampleFormat->setCurrentItem(8);
    break;
  default:
    ComboBoxSampleFormat->setCurrentItem(1);
    break;
  }
  SpinBoxChannels->setValue(preferencesSet.format.channelCount());
  switch ( preferencesSet.format.sampleRate() ) {
  case 44100:
    ComboBoxSampleRate->setCurrentItem(0);
    break;
  case 48000:
    ComboBoxSampleRate->setCurrentItem(1);
    break;
  case 96000:
    ComboBoxSampleRate->setCurrentItem(2);
    break;
  default:
    ComboBoxSampleRate->setCurrentItem(0);
    break;
  }
  switch ( preferencesSet.uiBuffer ) {
  case 64:
    ComboBoxBuffer->setCurrentItem(0);
    break;
  case 128:
    ComboBoxBuffer->setCurrentItem(1);
    break;
  case 256:
    ComboBoxBuffer->setCurrentItem(2);
    break;
  case 512:
    ComboBoxBuffer->setCurrentItem(3);
    break;
  case 1024:
    ComboBoxBuffer->setCurrentItem(4);
    break;
  case 2048:
    ComboBoxBuffer->setCurrentItem(5);
    break;
  case 4096:
    ComboBoxBuffer->setCurrentItem(6);
    break;
  default:
    ComboBoxBuffer->setCurrentItem(4);
    break;
  }

  ListBoxTracks->clear();
  ListBoxTracks->insertStringList(preferencesSet.strlDefaultTracks);

  IntNumInputFrameSeconds->setValue(preferencesSet.iFrameSeconds);
  TimeEditSessionMax->setTime(preferencesSet.timeSessionMax);
  FileChooserMixer->setFileName(preferencesSet.strMixerPath);
}

/////////////////////////////////////////////////////////////////////////////

SPreferences
WPrefDialog::fields()
{
  SPreferences preferencesReturn;
  preferencesReturn.strPlayDevice = FileChooserPlay->fileName();
  preferencesReturn.strRecDevice = FileChooserRec->fileName();

  switch ( ComboBoxFileType->currentItem() ) {
  case 0:
    preferencesReturn.FileType = CVoxStormGlobal::ecaWAV;
    break;
  case 1:
    preferencesReturn.FileType = CVoxStormGlobal::ecaMP3;
    break;
  default:
    preferencesReturn.FileType = CVoxStormGlobal::ecaWAV;
    break;
  }
  preferencesReturn.strProjectPath = DirChooserProject->fileName();

  preferencesReturn.format.setSampleFormat(
    CSourceFormat::sampleFormatIdentifier(ComboBoxSampleFormat->currentText()));
  preferencesReturn.format.setChannelCount(SpinBoxChannels->value());
  preferencesReturn.format.setSampleRate(ComboBoxSampleRate->currentText().toInt());
  preferencesReturn.uiBuffer     = ComboBoxBuffer->currentText().toUInt();

  int i, nTrack;
  nTrack = ListBoxTracks->count();
  for ( i = 0; i < nTrack; i++ ) {
    preferencesReturn.strlDefaultTracks.append(ListBoxTracks->item(i)->text());
  }

  preferencesReturn.iFrameSeconds = IntNumInputFrameSeconds->value();
  preferencesReturn.timeSessionMax = TimeEditSessionMax->time();
  preferencesReturn.strMixerPath = FileChooserMixer->fileName();

  return preferencesReturn;
}

/////////////////////////////////////////////////////////////////////////////

void
WPrefDialog::setupDevicesPage()
{
  QPixmap Pix = KGlobal::iconLoader()->loadIcon("voxstorm_hardware", KIcon::NoGroup, 32);
  QVBox *VBoxDevices = addVBoxPage(
                          QString(i18n("Devices")),
                          i18n("Detecting default devices for new track"),
                          Pix);
  VBoxDevices->setMinimumHeight(120);

  // ǥХ
  FileChooserPlay = new WFileChooser("  Play", "Select device file", VBoxDevices);
  FileChooserPlay->setSearchDir("file:///dev");
  FileChooserPlay->setFileType(i18n("*|All files (*)"));
  FileChooserPlay->setFileName("/dev/dsp");

  // ϿǥХ
  FileChooserRec = new WFileChooser("Record", "Select device file", VBoxDevices);
  FileChooserRec->setSearchDir("file:///dev");
  FileChooserRec->setFileType(i18n("*|All files (*)"));
  FileChooserRec->setFileName("/dev/dsp");
}

/////////////////////////////////////////////////////////////////////////////

void
WPrefDialog::setupFilePage()
{
  QPixmap Pix = KGlobal::iconLoader()->loadIcon("voxstorm_sound", KIcon::NoGroup, 32);
  QVBox *VBoxFile = addVBoxPage(
                          QString(i18n("File")),
                          i18n("Detecting file types etc"), 
                          Pix);
  VBoxFile->setMinimumHeight(120);

  // ե륿׻ΤΥåȷꡣ
  QVGroupBox *GroupBoxFileType = new QVGroupBox(
          i18n("File type"), VBoxFile);
  ComboBoxFileType = new KComboBox(GroupBoxFileType);
  ComboBoxFileType->insertItem("MP3 (*.mp3)");
  ComboBoxFileType->insertItem("WAVE (*.wav)");
  ComboBoxFileType->setCurrentItem(0);

  // ץȤΥǥե¸ѥΤΥåȷꡣ
  QVGroupBox *GroupBoxProjectPath = new QVGroupBox(
          i18n("VoxStorm session file saving directory"), VBoxFile);
  DirChooserProject = new WFileChooser(
                            "",
                            i18n("Select VoxStorm session file saving directory"),
                            GroupBoxProjectPath);
  DirChooserProject->setUsageForDir(true);
  DirChooserProject->setFileName("~/voxstorm");
}

/////////////////////////////////////////////////////////////////////////////

void 
WPrefDialog::setupSoundSpecPage()
{
  QPixmap Pix = KGlobal::iconLoader()->loadIcon("voxstorm_soundspec", KIcon::NoGroup, 32);
  QVBox *VBoxSound = addVBoxPage(
                          QString(i18n("Sound Spec")),
                          i18n("Detecting sound spec for recording track"),
                          Pix);
  QGridLayout *GridLayout = new QGridLayout(VBoxSound, 2, 1);

  // sampling format
  QHGroupBox *GroupBoxSampleFormat = new QHGroupBox(
          i18n("Sample format"), VBoxSound);
  GridLayout->addWidget(GroupBoxSampleFormat, 0, 0);
  ComboBoxSampleFormat = new KComboBox(GroupBoxSampleFormat);
  ComboBoxSampleFormat->insertStringList(CSourceFormat::sampleFormatStringList());
  ComboBoxSampleFormat->setCurrentItem(1);

  // count of channels
  QHGroupBox *GroupBoxChannels = new QHGroupBox(
          i18n("Count of channels"), VBoxSound);
  GridLayout->addWidget(GroupBoxChannels, 0, 0);
  SpinBoxChannels = new KIntSpinBox(1, 16, 1, 2, 10, GroupBoxChannels);

  // sampling rate
  QHGroupBox *GroupBoxSampling = new QHGroupBox(
          i18n("Sample rate"), VBoxSound);
  GridLayout->addWidget(GroupBoxSampling, 0, 0);
  ComboBoxSampleRate = new KComboBox(GroupBoxSampling);
  ComboBoxSampleRate->insertItem("44100");
  ComboBoxSampleRate->insertItem("48000");
  ComboBoxSampleRate->insertItem("96000");

  // size of buffer in samples (must be an exponent of 2)
  QVGroupBox *GroupBoxBuffer   = new QVGroupBox(
          i18n("Buffer size in samples"), VBoxSound);
  GridLayout->addWidget(GroupBoxBuffer, 1, 0);
  ComboBoxBuffer = new KComboBox(GroupBoxBuffer);
  ComboBoxBuffer->insertItem("64");
  ComboBoxBuffer->insertItem("128");
  ComboBoxBuffer->insertItem("256");
  ComboBoxBuffer->insertItem("512");
  ComboBoxBuffer->insertItem("1024");
  ComboBoxBuffer->insertItem("2048");
  ComboBoxBuffer->insertItem("4096");
}

/////////////////////////////////////////////////////////////////////////////

void
WPrefDialog::setupTrackPage()
{
  QPixmap Pix = KGlobal::iconLoader()->loadIcon("voxstorm_track", KIcon::NoGroup, 32);
  QVBox *VBoxTrack = addVBoxPage(QString(i18n("Track")),
                          i18n("Detecting default tracks etc"),
                          Pix);

  // åΥǥեȥȥåΤΥåȷ
  QHGroupBox *GroupBoxTracks = new QHGroupBox(
          i18n("Default track names"), VBoxTrack, "GroupBoxTracks");

  // ɲ
  LineEditName = new KRestrictedLine(GroupBoxTracks);
  LineEditName->setValidChars(CVoxStormGlobal::ValidCharsTrack);
  connect(LineEditName, SIGNAL(textChanged(const QString&)),
          this, SLOT(slotChangeAddState(const QString&)));
  PushButtonAdd = new QPushButton(i18n("Add"), GroupBoxTracks);
  PushButtonAdd->setEnabled(false);
  connect(PushButtonAdd, SIGNAL(clicked()),
          this, SLOT(slotAddTrackToList()));

  // ǥեȥȥåꥹ
  ListBoxTracks = new KListBox(GroupBoxTracks);
  connect(ListBoxTracks, SIGNAL(selectionChanged()),
          this, SLOT(slotChangeTrackSelection()));

  // ԽΤΥåȷꡣ
  QWidget     *WidgetBase = new QWidget(GroupBoxTracks);
  QGridLayout *GridLayout = new QGridLayout(WidgetBase, 5, 2);
  PushButtonUp     = new QPushButton(i18n("Up"), WidgetBase);
  GridLayout->addWidget(PushButtonUp, 0, 0);
  connect(PushButtonUp, SIGNAL(clicked()),
          this, SLOT(slotTrackUp()));
  PushButtonDown   = new QPushButton(i18n("Down"), WidgetBase);
  GridLayout->addWidget(PushButtonDown, 1, 0);
  connect(PushButtonDown, SIGNAL(clicked()),
          this, SLOT(slotTrackDown()));
  PushButtonRemove = new QPushButton(i18n("Remove"), WidgetBase);
  GridLayout->addWidget(PushButtonRemove, 4, 0);
  connect(PushButtonRemove, SIGNAL(clicked()),
          this, SLOT(slotRemoveTrackFromList()));
}

/////////////////////////////////////////////////////////////////////////////

void
WPrefDialog::setupGenericPage()
{
  QPixmap Pix = KGlobal::iconLoader()->loadIcon("voxstorm_generic", KIcon::NoGroup, 32);
  QVBox *VBoxGeneric = addVBoxPage(QString(i18n("General")),
                          i18n("VoxStorm generic settings"),
                          Pix);

  // ᤷÿΤΥåȷ
  QHGroupBox *GroupBoxFrameSeconds = new QHGroupBox(
          i18n("Seconds of rewind and forward"), VBoxGeneric, "GroupBoxFrameSeconds");
  IntNumInputFrameSeconds = new KIntNumInput(GroupBoxFrameSeconds);
  IntNumInputFrameSeconds->setRange(1, 240);

  // åκ֤ꤹ뤿Υåȷ
  QHGroupBox *GroupBoxSessionMax = new QHGroupBox(
          i18n("Max time of one session"), 
          VBoxGeneric, 
          "GroupBoxSessionMax");
  TimeEditSessionMax = new QTimeEdit(GroupBoxSessionMax);
  TimeEditSessionMax->setDisplay(QTimeEdit::Hours | 
                                 QTimeEdit::Minutes | 
                                 QTimeEdit::Seconds);

  // ߥץꤹ뤿Υåȷ
  QHGroupBox *GroupBoxMixer = new QHGroupBox(
          i18n("Mixer program path"),
          VBoxGeneric, 
          "GroupBoxMixer");
  FileChooserMixer = new WFileChooser("", "Select mixer program", GroupBoxMixer);
  FileChooserMixer->setFileType(i18n("*|All files (*)"));
}

/////////////////////////////////////////////////////////////////////////////

void
WPrefDialog::slotChangeAddState(const QString& strTrack)
{
  if ( !strTrack.isEmpty() ) {
    PushButtonAdd->setEnabled(true);
  } else {
    PushButtonAdd->setEnabled(false);
  }
}

/////////////////////////////////////////////////////////////////////////////

void
WPrefDialog::slotAddTrackToList()
{
  QString strTrack = LineEditName->text();
  if ( strTrack.isEmpty() ) {
    return;
  }

  QListBoxItem *ItemFound = ListBoxTracks->findItem(strTrack);
  if ( ItemFound != NULL ) {
    QString strMessage = i18n("Track name : ");
    strMessage = "\"" + strTrack + "\"\n";
    strMessage += i18n("The name is already using in other track.\n"
                       "Failed in adding track.");
    KMessageBox::sorry(this, strMessage);
    return;
  } else if ( !CVoxStormGlobal::isValidTrackName(strTrack) ) {
    QString strMessage = 
                QString(i18n("The name \"%1\" cannot be used for "
                             "track name.\nFailed in adding track.").arg(strTrack));
    KMessageBox::sorry(this, strMessage);
    return;
  }

  ListBoxTracks->insertItem(strTrack);
  LineEditName->clear();
}

/////////////////////////////////////////////////////////////////////////////

void
WPrefDialog::slotChangeTrackSelection()
{
  if ( ListBoxTracks->selectedItem() == NULL ) {  // not selected
    PushButtonUp->setEnabled(false);
    PushButtonDown->setEnabled(false);
    PushButtonRemove->setEnabled(false);
  } else {
    PushButtonUp->setEnabled(true);
    PushButtonDown->setEnabled(true);
    PushButtonRemove->setEnabled(true);
  }
}

/////////////////////////////////////////////////////////////////////////////

void
WPrefDialog::slotTrackUp()
{
  QListBoxItem *ItemSelected = ListBoxTracks->selectedItem();
  if ( ItemSelected == NULL ) {  // not selected
    return;
  }
  if ( ListBoxTracks->firstItem() == ItemSelected ) {  // top item
    return;
  }

  QString strTmp = ItemSelected->text();
  int     nIndex = ListBoxTracks->index(ItemSelected);
  ListBoxTracks->changeItem(ListBoxTracks->item(nIndex - 1)->text(), nIndex);
  ListBoxTracks->changeItem(strTmp, nIndex - 1);
  ListBoxTracks->setSelected(nIndex - 1, true);
}

/////////////////////////////////////////////////////////////////////////////

void
WPrefDialog::slotTrackDown()
{
  QListBoxItem *ItemSelected = ListBoxTracks->selectedItem();
  if ( ItemSelected == NULL ) {  // not selected
    return;
  }
  int     nIndex = ListBoxTracks->index(ItemSelected);
  if ( (ListBoxTracks->count() - 1) == (u_int)nIndex ) {  // bottom item
    return;
  }

  QString strTmp = ItemSelected->text();
  ListBoxTracks->changeItem(ListBoxTracks->item(nIndex + 1)->text(), nIndex);
  ListBoxTracks->changeItem(strTmp, nIndex + 1);
  ListBoxTracks->setSelected(nIndex + 1, true);
}

/////////////////////////////////////////////////////////////////////////////

void
WPrefDialog::slotRemoveTrackFromList()
{
  QListBoxItem *ItemSelected = ListBoxTracks->selectedItem();
  if ( ItemSelected == NULL ) {  // not selected
    return;
  }
  ListBoxTracks->removeItem(ListBoxTracks->index(ItemSelected));
}

/////////////////////////////////////////////////////////////////////////////

#include "wprefdialog.moc"
