/***************************************************************************
                          wtrackproperty.cpp  -  description
                             -------------------
    begin                : 2004ǯ  6 26  02:00:12 JST
    copyright            : (C) 2004 by Tomoaki Murakami
    email                : solarisphere@yahoo.co.jp
 ***************************************************************************/

/***************************************************************************
 *   Copyright (C) 2004 by Tomoaki Murakami                                *
 *   solarisphrere@yahoo.co.jp                                             *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

/////////////////////////////////////////////////////////////////////////////

#include <qlayout.h>
#include <qfileinfo.h>
#include <klocale.h>
#include "wtrackproperty.h"
#include "cecatools.h"

/////////////////////////////////////////////////////////////////////////////

WTrackProperty::WTrackProperty(QWidget *WidgetParent, const char *cName)
  : QWidget(WidgetParent, cName)
{
  QVBoxLayout* VBoxLayout = new QVBoxLayout(this);

  LabelName = new QLabel(i18n("-- Track is not detected --"), this);
  VBoxLayout->addWidget(LabelName);

  ListView = new KListView(this);
  VBoxLayout->addWidget(ListView);
  ListView->setSorting(-1); // sorting disabled
  ListView->setSelectionMode(QListView::NoSelection);
  ListView->addColumn("Attribute");
  ListView->addColumn("Value");
  ListView->addColumn("Remarks");
}

/////////////////////////////////////////////////////////////////////////////

WTrackProperty::~WTrackProperty()
{
}

/////////////////////////////////////////////////////////////////////////////

void 
WTrackProperty::slotSetTrack(const CTrackInf& trackInf)
{
  ListView->clear();

  if ( trackInf.strTrackName.isEmpty() ) {
    LabelName->setText(i18n("-- Track is not detected --"));
    return;
  }

  // name
  QString strCaption = 
    QString(i18n("Property of track \"%1\"")).arg(trackInf.strTrackName);
  LabelName->setText(strCaption);

  CEcaTools ecaTools;
  QListViewItem* Item;

  // muting
  Item = new QListViewItem(ListView);
  Item->setText(0, i18n("Muting"));
  if ( trackInf.bMute ) {
    strCaption = "On";
  } else {
    strCaption = "Off";
  }
  Item->setText(1, strCaption);
  ListView->insertItem(Item);

  // recording
  Item = new QListViewItem(ListView);
  Item->setText(0, i18n("Recording"));
  if ( trackInf.bRecPort ) {
    strCaption = "On";
  } else {
    strCaption = "Off";
  }
  Item->setText(1, strCaption);
  ListView->insertItem(Item);

  // length
  Item = new QListViewItem(ListView);
  Item->setText(0, i18n("Length"));
  Item->setText(1, trackInf.timeLength.toString("mm:ss:zzz"));
  ListView->insertItem(Item);

  // offset
  Item = new QListViewItem(ListView);
  Item->setText(0, i18n("Offset"));
  Item->setText(1, trackInf.timeOffset.toString("mm:ss:zzz"));
  ListView->insertItem(Item);

  // start position
  Item = new QListViewItem(ListView);
  Item->setText(0, i18n("Start position"));
  Item->setText(1, trackInf.timeStartPosition.toString("mm:ss:zzz"));
  ListView->insertItem(Item);

  // original length
  {
    Item = new QListViewItem(ListView);
    Item->setText(0, i18n("Original length"));
    QTime timeTmp = ecaTools.sourceLength(trackInf.strFileName);
    Item->setText(1, timeTmp.toString("mm:ss:zzz"));
    ListView->insertItem(Item);
  }

  // pan
  Item = new QListViewItem(ListView);
  Item->setText(0, i18n("Pan"));
  Item->setText(1, QString("%1").arg(trackInf.nPan));
  Item->setText(2, i18n("50 is center, 0 is just left, 100 is just right"));
  ListView->insertItem(Item);

  // level
  Item = new QListViewItem(ListView);
  Item->setText(0, i18n("Level"));
  Item->setText(1, QString("%1").arg(trackInf.nLevel));
  Item->setText(2, "%");
  ListView->insertItem(Item);

  // output device
  Item = new QListViewItem(ListView);
  Item->setText(0, i18n("Output device"));
  Item->setText(1, trackInf.strOutputDevice);
  //!! and setText device type (ALSA or OSS or JACK)
  ListView->insertItem(Item);

  // input device
  Item = new QListViewItem(ListView);
  Item->setText(0, i18n("Input device"));
  Item->setText(1, trackInf.strInputDevice);
  //!! and setText device type (ALSA or OSS or JACK)
  ListView->insertItem(Item);

  // sample format
  {
    int n;

    // sample rate
    Item = new QListViewItem(ListView);
    Item->setText(0, i18n("Sample rate"));
    n = ecaTools.sampleRate(trackInf.strFileName);
    Item->setText(1, QString("%1").arg(n));
    ListView->insertItem(Item);

    // channel count
    Item = new QListViewItem(ListView);
    Item->setText(0, i18n("Channel count"));
    n = ecaTools.channelCount(trackInf.strFileName);
    ecaTools.sampleFormat(trackInf.strFileName);
    Item->setText(1, QString("%1").arg(n));
    ListView->insertItem(Item);

    // sample format
    CSourceFormat::SampleFormat sf;
    Item = new QListViewItem(ListView);
    Item->setText(0, i18n("Sample format"));
    sf = ecaTools.sampleFormat(trackInf.strFileName);
    Item->setText(1, CSourceFormat::sampleFormatString(sf));
    ListView->insertItem(Item);
  }

  // file name
  {
    Item = new QListViewItem(ListView);
    Item->setText(0, i18n("File name"));
    Item->setText(1, trackInf.strFileName);
    QFileInfo fileInfo(trackInf.strFileName);
    if ( fileInfo.exists() ) {
      strCaption = i18n("Exists (possible to  play or record)");
    } else {
      strCaption = i18n("Not exists (possible to record only)");
    }
    Item->setText(2, strCaption);
    //!! and setText file permission
    ListView->insertItem(Item);
  }
}

/////////////////////////////////////////////////////////////////////////////

#include "wtrackproperty.moc"
