/***************************************************************************/
/*! \file   cecamanager.h
    \brief  饹CEcaManagerΥإåե롣
    \author Tomoaki Murakami
    \date   2004ǯ  5  4  17:29:12 JST
*/
/***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef CECAMANAGER_H
#define CECAMANAGER_H

#include <qobject.h>
#include <qvaluevector.h>
#include <qstringlist.h>
#include <qstring.h>
#include "ctrackinf.h"

/*-------------------------------------------------------------------------*/
/*! \class  CEcaManager
    \brief  Ecasoundץδ³ԤΥ饹
*/
/*-------------------------------------------------------------------------*/
class CEcaManager : public QObject
{
  Q_OBJECT
public:
  //! \brief 󥹥ȥ饯
  CEcaManager();
  //! \brief ǥȥ饯
  ~CEcaManager();

  //! \brief ȥåɲä롣
  //! \param TrackInfAdd Ȥɲäȥå
  void addTrackToChain(const CTrackInf& TrackInfAdd);
  //! \brief 򥯥ꥢ롣
  void clear();
  //! \brief  ƥȥåξ󤫤ecasoundΥޥɥ饤
  //! \param  bRecPause trueλϿͭˤޥɥ饤롣
  //! \param  bOutCmdLine trueλEcasoundץΥޥɥ饤֤
  //! \return EcasoundץΥޥɥ饤
  QString compile(bool bRecPause, bool bOutCmdLine=false);
  //! \brief  EcasoundץؤΥޥɥ饤ľܻꤹ롣
  //! Υˤꡢcompileˤä줿ץؤΰ̵Ȥʤ롣
  //! \param  strCommand EcasoundؤΥޥɥ饤
  //! ǽΰ"ecasound"Ǥ뤳ȤȰ˥󥿥饯ƥ֥⡼ɤɽ"-c"
  //! ꤵƤʤȤåå̤ʤä顢
  //! ⤻false֤å̤ä鿷ޥɥ饤
  //! ͭˤtrue֤
  //! ԡ֡ڡХåå夬ޤޤƤ硢
  //! 1ĤΥڡ֤롣
  //! \return strCommandʥޥɥ饤ä硢false
  //! \sa     compile(), strlArgs, ppcArgs
  bool overwriteSettings(const QString& strCommand);
  //! \brief  Ecasoundץư롣
  //! \param pnStatus EcasoundεươǼ뤿ѿؤΥݥ󥿡
  //! NULLꤹȡơϳǼʤ\n
  //!         0 : ˵ư줿硣\n
  //!        -1 : Ecasoundεư˼Ԥ硣\n
  //!        -2 : ȥå1Ĥˤʤ硣\n
  //!        -3 : ѥ뤵Ƥʤ硣
  void start(int* pnStatus=NULL);
  //! \brief  Ecasoundץλ롣
  void stop();
  //! \brief clear()Ƥ饳ѥ뤬ԤƤ硢true֤
  bool isCompiled() const;
  void setInput(const QString& strFileName);
  void setOutput(const QString& strFileName);

  //! "ecasound"
  static const QString EcasoundCmd;

private:
  //! \brief Ecasoundץؤΰ
  //! ˸ߤΥȥåȿǤ뤿ˤϡcompile()򥳡뤹롣
  //! \sa    compile(), ppcArgs
  QStringList strlArgs;
  //! \brief Ecasoundץؤΰ
  //! execˤäƼºݤ˻Ѥʸ
  //! compile()strlArgsƤ򥳥ԡ롣
  //! \sa    compile(), strlArgs
  char **ppcArgs;
  QString strInput;
  QString strOutput;
  //! ȥå٥
  QValueVector<CTrackInf> vTrackChains;

  //! \brief strlArgsppcArgs˥ޥɥ饤ꤹ롣
  //! \sa    strlArgs, ppcArgs, releaseArgs()
  void makeArgs();
  //! \brief ppcArgs롣
  //! \sa    ppcArgs, makeArgs()
  void releaseArgs();
  //! \brief ȥå̾ΤФȥåΥǥ֤
  //! ꤵ줿ȥå̾ΤФȥå󤬸Ĥʤ硢
  //! -1֤롣
  //! \param strTrackName ȥå̾Ρ
  int getIndexByName(const QString& strTrackName) const;

public slots:
  //! \brief ȥå꤬ѹ줿Υåȡ
  //! ٥ѹ
  void slotChangeLevel(const QString& strTrackName, int nLevel);
  //! \brief ȥå꤬ѹ줿Υåȡ
  //! ѥѹ
  void slotChangePan(const QString& strTrackName, int nPan);
  //! \brief ȥå꤬ѹ줿Υåȡ
  //! ߥ塼Ⱦѹ
  void slotToggleMute(const QString& strTrackName, bool bMute);
  //! \brief ȥå꤬ѹ줿Υåȡ
  //! Ͽѹ
  void slotToggleRec(const QString& strTrackName, bool bRec);
};

#endif
