/*
    w32loader
    copyright (c) 1998-2010 Kazuki Iwamoto http://www.maid.org/ iwm@maid.org

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/
#ifndef __WINMM_H__
#define __WINMM_H__


#include "w32ldr.h"


G_BEGIN_DECLS


#define DRV_LOAD            0x0001
#define DRV_ENABLE          0x0002
#define DRV_OPEN            0x0003
#define DRV_CLOSE           0x0004
#define DRV_DISABLE         0x0005
#define DRV_FREE            0x0006
#define DRV_CONFIGURE       0x0007
#define DRV_QUERYCONFIGURE  0x0008
#define DRV_INSTALL         0x0009
#define DRV_REMOVE          0x000a
#define DRV_EXITSESSION     0x000b
#define DRV_EXITAPPLICATION 0x000c
#define DRV_POWER           0x000f
#define DRV_RESERVED        0x0800
#define DRV_USER            0x4000
#define DRV_CANCEL          0x0000
#define DRV_OK              0x0001
#define DRV_RESTART         0x0002
#define DRVCNF_CANCEL       0x0000
#define DRVCNF_OK           0x0001
#define DRVCNF_RESTART      0x0002
#define DRVEA_NORMALEXIT    0x0001
#define DRVEA_ABNORMALEXIT  0x0002
#define DRV_SUCCESS         0x0001
#define DRV_FAILURE         0x0000
typedef struct _HDRVR *HDRVR;

#define SND_SYNC      0x0000
#define SND_ASYNC     0x0001
#define SND_NODEFAULT 0x0002
#define SND_MEMORY    0x0004
#define SND_LOOP      0x0008
#define SND_NOSTOP    0x0010

#define TIMERR_BASE    96
#define TIMERR_NOERROR 0
#define TIMERR_NOCANDO (TIMERR_BASE+1)
#define TIMERR_STRUCT  (TIMERR_BASE+33)
typedef UINT MMRESULT;


extern W32LdrExport w32ldr_winmm_exports[];


LRESULT WINAPI CloseDriver (HDRVR hdrvr, LONG lParam1, LONG lParam2);
LONG WINAPI DefDriverProc (DWORD dwDriverId, HDRVR hDrvr, UINT msg, LONG lParam1, LONG lParam2);
HMODULE WINAPI GetDriverModuleHandle (HDRVR hdrvr);
HDRVR WINAPI OpenDriver (LPCWSTR lpDriverName, LPCWSTR lpSectionName, LONG lParam);
LRESULT WINAPI SendDriverMessage (HDRVR hdrvr, UINT msg, LONG lParam1, LONG lParam2);
BOOL WINAPI sndPlaySoundA (LPCSTR lpszSound, UINT fuSound);
BOOL WINAPI sndPlaySoundW (LPCSTR lpszSound, UINT fuSound);
MMRESULT WINAPI timeBeginPeriod (UINT uPeriod);
MMRESULT WINAPI timeEndPeriod (UINT uPeriod);
DWORD WINAPI timeGetTime (VOID);


#ifdef UNICODE
# define sndPlaySound sndPlaySoundW
#else /* not UNICODE*/
# define sndPlaySound sndPlaySoundA
#endif /* not UNICODE */


G_END_DECLS


#endif /* __WINMM_H__ */
